/*
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue May 24 23:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */
 
/*
 * P is now just a pointer to the preg structure regex_t
 * but... man will still break if regex.c is replaced with rx.c 
 * in the shared libc.
 */
 
#define P	(regex_t *) NULL  

static struct big_regex_buffer {
	char *regex;
	char *replace;
	regex_t *preg;
} regex_buf[] = {

/*
 * This is where we describe translations to enable extraction of the man
 * references and description.
 *
 * Some of this is just ported from Rik Faith's makewhatis, which in turn is 
 * taken from Tom Christiansen's perl script
 */

/* Regex exp. to be located, replacement, P structure, comment */ 

"^[ ]|[^\\]-$",			"",	P, /* kill init spaces, hyphenation */
"^\\.[IB] |^\\.[BIRS][IRBM] |"		   /* kill Italic/Bold and derivatives */
"^\\.(DT|PD|RE|RS|SS|Nm|Li|Xr|Tn) |"       /* kill indents, Misc */
"^\\.(BE|na|ad|sp)|"			   /* Kill tcl/OI macros */
"^\\.[HILTP][P]|"		 	   /* kill Paragraphs etc */
"\\\\f[PRIB0123]|"			   /* kill Font changes */   
"\\\\s[-+0-9]*|"			   /* kill size changes */
"\\\\\\*\\(..|^\\.\\\\\".*|"	 	   /* kill troff strings, comments */
"\\\\&", 			"", 	P, 
"--",				"-",	P, /* convert -- to - */
"\\\\\\((mi|hy|em|)|"
"^\\.Nd", 			" - ", 	P, /* convert to DASH */
"\\\\\\((ru|ul)", 		"_", 	P, /* convert to UNDERSCORE */

/* now we just have to clean up a little */

"\t|\n|  ", 			" ", 	P, /* newline, tab, double space to single space */
"^[ ]|\\\\", 			"", 	P, /* kill more init spaces & backslashes */
"\\.br ",			"\x11",	P, /* provide separator between definitions */
NULL,				NULL,	P

};

static struct small_regex_buffer {
	char *regex;
	regex_t *preg;
} regex_find[] = {

"^\\.[Ss][HhYySs] \"*[Nn][Aa][Mm][Ee]",	P,
"^\\.[Ss][HhYS] |^\\.IX ",		P, /* .IX stuff for OI man pages */
"^[Nn][Aa][Mm][Ee]",			P,
"^S[yYeE]|^\n|__",			P,
NULL,					P

};

