;;; tex-18.el - Special support for Emacs 18

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Version: $Id: tex-18.el,v 5.14 1994/05/05 14:51:22 amanda Exp $

;;; Code:

(condition-case error
    (require 'outline)			;No provide in Emacs 18 outline.el 
  (error (provide 'outline)))

;; Emacs 18 grok this regexp, but you loose the ability to use
;; whitespace anywhere in your documentstyle command.
(defvar LaTeX-auto-minimal-regexp-list
  '(("\\\\documentstyle\\[\\([^#\\\\\\.\n\r]+\\)\\]{\\([^#\\\\\\.\n\r]+\\)}"
     (1 2) LaTeX-auto-style)
    ("\\\\documentstyle{\\([^#\\\\\\.\n\r]+\\)}" (1) LaTeX-auto-style)
    ("\\\\documentclass\\[\\([^#\\\\\\.\n\r]+\\)\\]{\\([^#\\\\\\.\n\r]+\\)}"
     (1 2) LaTeX-auto-style)
    ("\\\\documentclass{\\([^#\\\\\\.\n\r]+\\)}" (1) LaTeX-auto-style))
  "Minimal list of regular expressions matching LaTeX macro definitions.")
	    
;; The Emacs 19 definition of `comment-region'.
(defun comment-region (beg end &optional arg)
  "Comment the region; third arg numeric means use ARG comment characters.
If ARG is negative, delete that many comment characters instead.
Comments are terminated on each line, even for syntax in which newline does
not end the comment.  Blank lines do not get comments."
  ;; if someone wants it to only put a comment-start at the beginning and
  ;; comment-end at the end then typing it, C-x C-x, closing it, C-x C-x
  ;; is easy enough.  No option is made here for other than commenting
  ;; every line.
  (interactive "r\np")
  (or comment-start (error "No comment syntax is defined"))
  (if (> beg end) (let (mid) (setq mid beg beg end end mid)))
  (save-excursion
    (save-restriction
      (let ((cs comment-start) (ce comment-end))
        (cond ((not arg) (setq arg 1))
              ((> arg 1)
               (while (> (setq arg (1- arg)) 0)
                 (setq cs (concat cs comment-start)
                       ce (concat ce comment-end)))))
        (narrow-to-region beg end)
        (goto-char beg)
        (while (not (eobp))
          (if (< arg 0)
              (let ((count arg))
                (while (and (> 1 (setq count (1+ count)))
                            (looking-at (regexp-quote cs)))
                  (delete-char (length cs)))
                (if (string= "" ce) ()
                  (setq count arg)
                  (while (> 1 (setq count (1+ count)))
                    (end-of-line)
                    ;; this is questionable if comment-end ends in whitespace
                    ;; that is pretty brain-damaged though
                    (skip-chars-backward " \t")
                    (backward-char (length ce))
                    (if (looking-at (regexp-quote ce))
                        (delete-char (length ce)))))
		(forward-line 1))
            (if (looking-at "[ \t]*$") ()
              (insert cs)
              (if (string= "" ce) ()
                (end-of-line)
                (insert ce)))
            (search-forward "\n" nil 'move)))))))

;; The Emacs 19 definition of `add-hook'.
(defun add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION.
FUNCTION is not added if already present.
FUNCTION is added (if necessary) at the beginning of the hook list
unless the optional argument APPEND is non-nil, in which case
FUNCTION is added at the end.
 
HOOK should be a symbol, and FUNCTION may be any valid function.  If
HOOK is void, it is first set to nil.  If HOOK's value is a single
function, it is changed to a list of functions."
  (or (boundp hook) (set hook nil))
  ;; If the hook value is a single function, turn it into a list.
  (let ((old (symbol-value hook)))
    (if (or (not (listp old)) (eq (car old) 'lambda))
        (set hook (list old))))
  (or (if (consp function)
          ;; Clever way to tell whether a given lambda-expression
          ;; is equal to anything in the hook.
          (let ((tail (assoc (cdr function) (symbol-value hook))))
            (equal function tail))
        (memq function (symbol-value hook)))
      (set hook 
           (if append
               (nconc (symbol-value hook) (list function))
             (cons function (symbol-value hook))))))

;; An Emacs 19 function.
(defun make-directory (dir)
  "Create the directory DIR."
  (shell-command (concat "mkdir " (if (string-match "/$" dir)
				      (substring dir 0 -1)
				    dir))))
 
;; An Emacs 19 function.
(defun abbreviate-file-name (name)
  name)

;; Different interface for each variant.
(defun TeX-active-mark ()
  ;; Emacs 18 does not have active marks.
  nil)

;; Different interface for each variant.
(defun TeX-mark-active ()
  ;; In Emacs 18 (mark) returns nil when not active.
  (mark))

;; An Emacs 19 function.
(defun member (elt list)
  "Return non-nil if ELT is an element of LIST.  Comparison done with EQUAL.
The value is actually the tail of LIST whose car is ELT."
  (while (and list (not (equal elt (car list))))
    (setq list (cdr list)))
  list)

(provide 'tex-18)

;;; tex-18.el ends here
