%% $Id: xyguide.man,v 2.10 1994/06/15 12:55:07 kris Exp $
%%
%% ``XY-pic User's Guide''.
%% Copyright (c) 1991-1994	Kristoffer H. Rose	<kris@diku.dk>
%%
%% This file is part of the XY-pic package for graphs and diagrams in TeX.
%% See the companion README and INSTALL files for further information.
%% Copyright (c) 1991-1994	Kristoffer H. Rose	<kris@diku.dk>
%%
%% The XY-pic package is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by the
%% Free Software Foundation; either version 2 of the License, or (at your
%% option) any later version.
%%
%% The XY-pic package is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
%% or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
%% for more details.
%%
%% You should have received a copy of the GNU General Public License along
%% with this package; if not, write to the Free Software Foundation, Inc.,
%% 675 Mass Ave, Cambridge, MA 02139, USA.
%%
\documentstyle[twocolumn,xydoc]{article}
\def\LaTeXe{{\LaTeX\kern.15em$2_{\textstyle\varepsilon}$}} % avoid `bug'
\CompileAllDiagrams{xyguide-}
\begin{document}

% TOPMATTER

\title{	\XY-pic User's Guide }
\author{ Kristoffer H. Rose\quad<kris@diku.dk>\thanks{%
		DIKU (Computer Science dept.), University of Copenhagen,
		Universitetsparken~1, DK--2100 K{\o}benhavn {\O}, Denmark.}}
\date{Version \xyversion, \printdate{\xydate}}
\maketitle

\begin{abstract}
	\XY-pic is a package for typesetting graphs and diagrams using plain
	\TeX, \LaTeX, \AMS-\LaTeX, and \AMS-\TeX.  Several modes of input
	are supported; this guide concentrates on how to typeset
	`matrix-like' diagrams like "commutative diagrams" in the following
	style:
%
\begin{code}
\diagram
 U \ddrto_y \drto \drrto^x \\
  & X \times_Z Y \dto^q \rto_p & X \dto_f \\
  & Y \rto^g                   & Z
\enddiagram
\end{code}
$$\docode$$
%
	was typeset by the \XY-pic input lines
%
\displaycode
\noindent
%
	Such diagrams have the following characteristics:
%
\begin{itemize}
\item
	Specified as a matrix of entries that are automatically aligned in
	rows and columns.
\item
	Any entry may be connected to any other entry using a variety of
	arrow styles all rotated and stretched as required.
\item
	Arrows may be decorated with labels that are tied to a specified
	point along the arrow and extend in a particular direction.
\item
	Arrows may be paired, cross each other, and visit/bend around other
	entries `on the way'.
\item
	Complete `low-level' graphic language for drawing independently of
	the matrix structure.
\end{itemize}
%
	\REMARK: \XY-pic release \xyversion\ is also a $\beta$-release for
	\XY-pic version~3, referred to here as "v3".  This is greatly
	enhanced and extended relative to version~2.  Many features described
	in this document are therefore obsolete but remain valid (as a
	special `compatibility' mode).  We remark it at the end of a section
	whenever this is the case; look in the \XY-pic Reference
	Manual~\cite{R94:XY-picRM} for the details.

\end{abstract}

\tableofcontents
\listoffigures
\goodbreak

% TEXT



\section*{Introduction}
%
	This guide explains some features of \XY-pic that are related to
	diagram typesetting.  It assumes that you have some experience in
	using \TeX\ for typesetting mathematics, \eg, have
	studied~\cite[ch.~16--19]{K84:TeXbook}, \cite[sec.~3.3]{L86:LaTeX},
	or~\cite{S90:JoyT}.

	The first section describes what you need to get started.
	Section~??[arrows] and~??[entries] explain advanced use of arrows and
	entries, respectively.  Section~??[avail] explains where and under
	what conditions \XY-pic is available and points to further
	information.  Throughout we give exercises that you should be able to
	solve as you go along; all exercises are answered at the end, just
	prior to the bibliography.



\section{Basics}
??=[basics]
%
	This section explains the \XY-diagram construction concepts needed to
	get started with typesetting category theory diagrams.


\subsection{Loading}
??=[basics.loading]
%
	\XY-pic is loaded by inserting a line with the command
%
\begin{defs1}
 ??c![\input xypic]
\end{defs1}
\noindent\unskip
%
	in the definitions part of your document (after any
	??c![\documentstyle] line).\footnote{This will load \XY-pic in a
	special `compatibility mode' which defines the commands described in
	this guide as they have been available since version 2.4 of the
	package.  Other modes are available; see the Reference
	Manual~\cite{R94:XY-picRM} for details.}
%
\begin{quote}\it
	This describes loading in compatibility mode -- in "v3" the
	individual features of \XY-pic can be loaded separately.
\end{quote}


\subsection{Entries}
??=[basics.entries]
%
	A diagram is created by the commands
%
\begin{defs1}
 ??c![\diagram]~\dots~??c![\enddiagram]
\end{defs1}
\noindent\unskip
%
	where the `\dots' should be replaced by "entries"??w[entry] to be
	"aligned in rows and columns" where
%
\begin{itemize}
\item
	entries in a row are separated by ??c![&] and
\item
	rows are separated by ??c![\\].
\end{itemize}
%
	For example,
\begin{code}
\diagram
  A &\sum_{i=n}^m {i^2} \framed \\
    & \bullet & D \ulto
\enddiagram
\end{code}
$$\docode$$
%
	was typeset by
%
\displaycode
%
\noindent
	Notice the following:
%
\begin{itemize}
\item
	entries are typeset as mathematics (in `text style'),
\item
	all entries are centered,
\item
	the separation between rows and columns is usually quite large in a
	diagram,
\item
	entries at the end of rows that are empty may be omitted, and most
	importantly:
\item
	``\XY-commands'' (like |\framed| and |\ulto| here) can decorate an
	entry and connect it with others without changing the diagram layout.
\end{itemize}
%
	The style and spacing can be changed; we discuss that in
	section~??[entries].
%
\begin{quote}\it
	In "v3" several matrices can be typeset in the same picture (and
	refer to each other's entries), and matrices can be rotated.
\end{quote}


\subsection{Arrows}
??=[basics.arrows]
%
	An `??w![arrow]' in an \XY-pic diagram is a generic term for the
	drawn decorations that are added to the basic matrix structure.  In
	\XY-pic all arrows must be specified along with the entry they start
	in; this is called their "??w![base entry]".  Each particular arrow
	then refers explicitly to its "??w![target entry]".

	The most commonly used arrows have names starting with either~??c![u]
	or ??c![d] for up or down, followed by either ??c![l] or ??c![r] for
	left and right, \eg, the arrow |\drto| reads `down and then right
	to'.  Figure~??[f:directions] shows the possible straight arrows, all
	leaving the entry "base" and ending at the entry with their name in.
	The relative coordinates specified in this way are purely logical,
	\eg, if the diagram contains very wide entries then the arrows will
	be nearly horizontal.  All the constructed arrows are aligned along
	the line between the centers of the base and target entries; they
	will not automatically disappear under entries that they cross (we
	discuss how this is achieved in section~??[arrows.pass]).

\begin{figure*}
$$\let\1=\relax
 \diagram
   \1??c![\uullto]&\1??c![\uulto]	&\1??c![\uuto]	&\1??c![\uurto]  &\1??c![\uurrto]\\
   \1??c![\ullto]&\1??c![\ulto]\ulto&\1??c![\uto]\uto&\1??c![\urto]\urto&\1??c![\urrto]\\
   \1??c![\llto]	&\1??c![\lto]\lto	&\1
   		\uulto				\uurto		
   \ullto	\ulto 		\uto 		\urto		\urrto
   		\lto       	"base"		\rto
   \dllto	\dlto 		\dto 		\drto		\drrto
		\ddlto				\ddrto
						&\1??c![\rto]\rto	&\1??c![\rrto]\\
   \1??c![\dllto]&\1??c![\dlto]\dlto&\1??c![\dto]\dto&\1??c![\drto]\drto&\1??c![\drrto]\\
   \1??c![\ddllto]&\1??c![\ddlto]	&\1??c![\ddto]	&\1??c![\ddrto]	&\1??c![\ddrrto]
\enddiagram$$
\caption{Standard directions for straight arrows.}
??=[f:directions]
\end{figure*}

	If you are making large diagrams where the above predefined arrows
	are not sufficient then you can always resort to the general form
	|\xto[|"hop"|]|??c[\xto] where "hop" should be a sequence of the
	letters |dulr| as described above, \eg, |\xto[u]| is equivalent to
	|\uto| but |\xto[uuulll]| has no short-form equivalent.

	The directions also exist with |to| replaced by various other basic
	line styles:
$$
 \spreaddiagramcolumns{-2pc}\objectwidth{3pc}
 \diagramnocompile
  ??c![to]\xto+<1pc,-2pc>*{}
   &??c![line]\xline+<1pc,-2pc>*{}
    &??c![dashed]\xdashed+<1pc,-2pc>*{}
     &??c![dotted]\xdotted+<1pc,-2pc>*{}
      &??c![double]\xdouble+<1pc,-2pc>*{}
       &\\
 \enddiagram
$$

\begin{exercise}
\begin{code}
\diagram
 \bullet \ddashed\drdouble\rline
         & \bullet \ddotted \\
 \bullet & \bullet \lto
\enddiagram
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author did \displaycode}
\end{exercise}
%
\begin{quote}\it
	In "v3" mnemonic names are used for arrows, \eg, the five basic line
	styles above correspond to arrows |{->}|, |{-}|, |{--}|, |{..}|, and
	|{=}|.
\end{quote}


\subsection{Labels}
??=[basics.labels]
	You can put labels on arrows.  Labels are conceptualized as sub- and
	superscripts on arrows such that they are placed in the usual
	positions (as `limits'), \ie, |^| reads `above' and |_| below on an
	arrow pointing "right" but the positions depend only on the direction
	of the arrow.  For example,
\begin{code}
\diagram
 X \rto^a_b & Y & Z \lto^A_B
\enddiagram
\end{code}
\displaycode
%
\noindent will set
%
$$\docode$$
%
	Labels that do not consist of a single letter, digit, or control
	sequence, should be enclosed in |{|\dots|}|.

	The placement of the labels only depends on the direction of the
	arrow: it is placed perpendicular to the center of the arrow
	(measured from the centers of the objects at the ends).  More details
	concerning labels are given in section~??[arrows.labels].

\begin{exercise}
\begin{code}
$$\diagram
 A \rto^f \drto_{f;g}
  & B \dto^g \drto^{g;h} \\
  & C \rto_h & D
\enddiagram
\qquad(2)$$
\end{code}
%
	Typeset the second axiom of category theory as
%
\docode
%
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}


\subsection{Breaks}
??=[basics.breaks]
	It is also possible to `break' an arrow with a label using the
	character~??c![|]:
%
\begin{code}
\diagram A \rto|f & B \enddiagram
\end{code}
\displaycode
\noindent
	will set
%
$$\NoCompileAllDiagrams\docode$$
%
	If you just want an empty break you should use the special ??c![\hole]
	break: the arrow
\begin{code}
\diagram A \rto|\hole & B \enddiagram
\end{code}
%
	{\NoCompileAllDiagrams\docode} was typeset by including \thecode\ in
	the text.  You may mix a break with other labels, but the break
	should always be last.  There is more on breaks in
	section~??[arrows.tips].

\begin{exercise}
\begin{code}
$$\diagram
 A \dto_f \rto^f & B \dlto|{i_B} \dto^g \\
 B        \rto_g & C
\enddiagram
\qquad(1)$$
\end{code}
%
	Typeset the first axiom of category theory as the display
%
{\NoCompileAllDiagrams\docode}%
%
\answercode
\answertext{The author used \displaycode}
\end{exercise}


\subsection{Bends}
??=[basics.bends]
%
	There are special versions of |to|-arrows that go `around' a neighbor
	entry and point to something `behind' it: here are the horizontal
	ones:
%
$$
\spreaddiagramcolumns{-1pc}
\diagramnocompile
\\
  \txt\tt{ \string\lltou\string^a \\
	  \string\lltod\string^a }
 &\Box
 &\txt\it{entry\\with\\commands}
	\lltou^a \rrtou^a
	\lltod^a \rrtod^a
 &\Box
 &\txt\tt{ \string\rrtou\string^a \\
	   \string\rrtod\string^a }
\\&
\enddiagram
$$
%
	There are similar vertical ones named ??c![\ddtol], ??c![\ddtor],
	??c![\uutol], and ??c![\uutor], and there is a special set of `self'
	arrows:
$$
\spreaddiagramrows{-1pc}
\diagram
\\
 \relax|\toul^a|\toul^a &\relax |\tour^a|\tour^a
\\
 \relax|\todl^a|\todl^a &\relax |\todr^a|\todr^a
\\&
\enddiagram
$$
??c[\toul]??c[\tour]??c[\todl]??c[\todr]%
	and
$$
\spreaddiagramrows{-1pc}
\diagram
\\
 \relax |\tolu^a|\tolu^a &\relax |\toru^a|\toru^a
\\
 \relax |\told^a|\told^a &\relax |\tord^a|\tord^a
\\&
\enddiagram
$$
??c[\told]??c[\tord]??c[\tolu]??c[\toru]%
%
	These only exist for the |to| line style. In section~??[arrows.bend]
	we explain how other variants can be constructed.

\begin{exercise}
	Typeset
%
\begin{code}
\diagram
 x \rrtou|f && \lltod|{f^{-1}} f(x)
\enddiagram
\end{code}
$$
\NoCompileAllDiagrams\docode
$$
\answercode
\answertext{The author did \displaycode}
\end{exercise}


\subsection{Speeding up typesetting}
??=[basics.speeding]
%
	One thing that you will notice is that \XY-pic is sometimes slow in
	typesetting diagrams (this is to be expected considering the number
	of drawing operations performed as reflected by the number last in
	each |xymatrix| message).  You can instruct \XY-pic to save the
	details of a particular diagram in a file "name"|.xyc| (for `compiled
	\XY-pic') every time the diagram changes by replacing the |\diagram|
	command with
%
\begin{defs1}
|\diagramcompileto{|"name"|}|
\end{defs1}
\noindent\unskip
%
	This will cut the typesetting time considerably whenever the diagram
	is retypeset without change.

	\NOTE: this is only safe for diagrams that obey the following
	restriction: "all entries should start with a non-expandable token"
	like an ordinary (non-active), |\relax|, or |{|.
%
\begin{quote}\it
	This is a "v3" feature mentioned here because it is a common
	question.
\end{quote}



\section{More Arrows and Labels}
??=[arrows]
%
	In this section we explain a number of variations of the arrow
	commands that are useful in commutative diagrams.


\subsection{Explicit positioning of labels}
??=[arrows.labels]
%
	The label commands explained in section~??[basics.labels] place the
	label text near the center of the arrow.  This, however, may be
	changed by inserting a "??w![place]" between the ??c![^], ??c![_], or
	??c![|], and the actual label.  In general you may insert the
	following:
%
\begin{itemize}
\item
	??c![<] will place the label at the point where the actual arrow
	begins, \ie, `appears from under' the base, so
%
\begin{code}
\diagram A \rto^<{+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset {\NoCompileAllDiagrams\docode}.

\item
	Similarly, ??c![>] will place the label at the point where the actual
	arrow ends, \ie, `disappears below' the target, so
%
\begin{code}
\diagram A \rto^>{+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset \docode.

\item
	??c![<<] and ??c![>>] will place the following label at a point just
	a bit\footnote{`A bit' is in fact a \TeX\ {\tt\string\jot} which is
	3pt.}\ further from the beginning and end of the arrow, so
%
\begin{code}
\diagram A \rto^>>{+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset \docode.  Using more |<|s will move the
	label further in.

\item
	More |<|s and |>|s may be given to make this distance larger:
%
\begin{code}
\diagram A \rto^>>>{+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset \docode.

\item
	A factor in ??c![()]s: $|(|a|)|$ indicates that the label should be
	`tied' to the point $a$ of the way from the center of the base entry
	(called ??c![(0)]) to the center of the target (called ??c![(1)])
	instead of in the middle, so
%
\begin{code}
\diagram A \rto^(.2){+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset \docode.

\item
	A factor can be given "after" some |<| or |>|s: in that case the
	place is computed as if the base was the place specified by the |<|s
	and the target the place specified by the |>|s:
%
\begin{code}
\diagram A \rto^<(0){+} &B \enddiagram
\end{code}
%
	\thecode\ will typeset {\NoCompileAllDiagrams\docode}.

\item
	Finally, a ??c![-] means the same as |<>(.5)|, \ie, place at the
	"middle of the arrow" rather than the middle between the base and
	target, so
%
\begin{code}
\diagram
 A\times B\times C\times D \rto^-{+} &B
\enddiagram
\end{code}
%
	 \docode\ was typeset by
%
\displaycode
%
	It becomes
$
\diagram
 A\times B\times C\times D \rto^{+} &B
\enddiagram
$
	without~|-|~.

\end{itemize}

\begin{exercise}
\begin{code}
\diagram
 A \dto ^>>\ast ^b \drto ^>>\ast ^c
   \rto ^>>\ast ^d  & D \\
 B                  & C \enddiagram
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}


\subsection{Extra tips}
??=[arrows.tips]
	You can use the `break' feature described in
	section~??[basics.breaks] to add extra arrow tips.  This is done by
	using special `standard tip' labels shown as $\ell$ in
	$|\drto|\,\ell$ in figure~??[f.tips].

\begin{figure*}
$$
 \NoCompileAllDiagrams
 \spreaddiagramrows{-1pc} \spreaddiagramcolumns{1pc} \objectwidth{3pc}
 \diagram
  |\tip| \POS[]+DL\xto[]+<3pc,-2pc>|\tip
  &|\stop| \POS[]+DL\xto[]+<3pc,-2pc>|\stop
 \\
 \\
  |\atip| \POS[]+DL\xto[]+<3pc,-2pc>|\atip
  &|\astop| \POS[]+DL\xto[]+<3pc,-2pc>|\astop
   &|\ahook| \POS[]+DL\xto[]+<3pc,-2pc>|\ahook
    &|\aturn| \POS[]+DL\xto[]+<3pc,-2pc>|\aturn
 \\
 \\
  |\btip| \POS[]+DL\xto[]+<3pc,-2pc>|\btip
  &|\bstop| \POS[]+DL\xto[]+<3pc,-2pc>|\bstop
   &|\bhook| \POS[]+DL\xto[]+<3pc,-2pc>|\bhook
    &|\bturn| \POS[]+DL\xto[]+<3pc,-2pc>|\bturn
	\save \go+<3pc,-2pc>\Drop{}\restore
 \\
 \\
  |{\tip\stop}| \POS[]+DL\xto[]+<3pc,-2pc>|{\tip\stop}
  &|{\rotate\tip}| \POS[]+DL\xto[]+<3pc,-2pc>|{\rotate\tip}
   &|{\rotate(1)\tip\astop}|
	\POS[]+DL\xto[]+<3pc,-2pc>|{\rotate(1)\tip\astop}
    &|{\squash{+}}| \POS[]+DL\xto[]+<3pc,-2pc>|{\squash{+}}
     \save \go+<3pc,-2pc>\Drop{}\restore
 \\
 \enddiagram
$$
\caption{Standard tips.}
??=[f.tips]
\end{figure*}

	Tips with more than one component must be enclosed in |{}|, and tips
	can be rotated $180^\circ$ by the |\rotate| prefix or optionally by
	the factor $|(|f|)|$, ${-2}\lt f\le 2$, to rotate it
	$f\times90^\circ$ clockwise.  Furthermore you can enclose any math in
	$|\squash{|\dots|}|$ to make it of zero size and use it as a tip;
	|\squash| attempts to center it but sometimes you might have to
	`help' by adding spacing (\eg, using |\,| and |\strut|).

	An arrow may have several breaks.  They must, however, be given in
	the same order as they appear from the base to the target of the
	arrow as illustrated here:
$$
\NoCompileAllDiagrams
\spreaddiagramcolumns{1pc}
\begin{tabular}{ll}
 |\rto||a||>\stop|\quad &{\diagram\Box \rto|a|>\stop	&\Box\enddiagram}\\
 |\rto||<\stop||a|\quad &{\diagram\Box \rto|<\stop|a	&\Box\enddiagram}\\
 |\rto||<\hole||<<\stop|\quad
	&{\diagram\Box \rto|<\hole|<<\stop		&\Box\enddiagram}\\
 |\rto||>>\tip|\quad &{\diagram\Box \rto|>>\tip		&\Box\enddiagram}\\
 |\rto||<\hole||<<\ahook|\quad
	&{\diagram\Box\rto|<\hole|<<\ahook		&\Box\enddiagram}\\
 |\rto||<<\hole||<<<\tip|\quad
	&{\diagram\Box \rto|<<\hole|<<<\tip 		&\Box\enddiagram}\\
 |\rto||>{\squash\circ}|\quad
	&{\diagram\Box \rto|>{\squash\circ}	  	&\Box\enddiagram}\\
 |\rto||<{\rotate\tip}|\quad
	&{\diagram\Box \rto|<{\rotate\tip} 		&\Box\enddiagram}\\
 |\rline||>{\rotate(.6)\tip}|\quad
	&{\diagram\Box \rline|>{\rotate(.6)\tip}	&\Box\enddiagram}
\end{tabular}
$$
	Notice how we use an extra |||<\hole| break to shorten arrows to make
	space for `large' tails like hooks that have most of their ink on the
	wrong side.\footnote{In version 2.6 and before this was automatic
	with a |||<<| break but this was a bug which has been fixed.}

	The above tips work with the basic arrow types |to| (as shown),
	|line|, |dashed|, and |dotted|, however, only |\stop| works with all
	arrows, \ie, also with |double|.  If you want an arrowhead on a
	|double| arrow then you must use |\Tip|:
$$
\NoCompileAllDiagrams
\begin{tabular}{ll}
 |\rdouble||>\Tip|\quad
  &{\diagram\Box \rdouble|>\Tip &\Box\enddiagram}\\
 |\rdouble||<\stop||>>\Tip||>\Tip|\quad
  &{\diagram\Box \rdouble|<\stop|>>\Tip|>\Tip &\Box\enddiagram}\\
\end{tabular}
$$
%
\begin{quote}\it
	The "v3" arrow command uses a much simpler scheme: it interprets
	arrow generic definitions, \eg, |{||-->>}| becomes a dashed $\mapsto$
	with a double tip.
\end{quote}


\subsection{Sliding arrows sideways}
??=[arrows.sliding]
	It is often desirable to have several arrows between two objects.
	This can be done by sliding either or both arrows sideways by giving
	the distance as an optional \TeX\ dimension enclosed in |<>|s: it
	specifies how far `sideways' the arrow should be moved, \eg,
%
\begin{code}
\diagram
 A \drto<1ex>^a_{.} \\
   & B \ulto<1ex>^b \rto<1ex>^c
     & C \lto<1ex>^d_{.}
\enddiagram
\end{code}
\displaycode
\noindent will typeset
$$\docode$$
%
	A positive distance will slide the arrow in the `|^|-direction', \eg,
	the two arrows above are slid in the direction of the labels~$a$
	and~$b$, respectively; a negative distance in the `|_|-direction'.
	The distance |<1ex>| is often appropriate since it corresponds
	roughly to the height of letters like `x', independently of the used
	type size.
%
\begin{quote}\it
	In "v3" it is also possible to curve arrows and there is special
	support for 2-cells.
\end{quote}


\subsection{More targets}
??=[arrows.targets]
%
	In the general arrow constructions |\xto|, |\xline|, |\xdashed|,
	|\xdotted|, and |\xdouble|, the target address can be given in a
	large number of formats called "positions".  The full range of
	possibilities is described in the reference
	manual~\cite{R94:XY-picRM}; here is a number of useful possibilities:
%
\begin{itemize}
\item
	$|[|r|,|c|]|$~, where $r,c$ are integers, denotes the "relative
	entry" found $r$~rows below and $c$~columns to the right of the
	current entry (the current entry itself is thus |[0,0]|).  Each such
	pair corresponds to a |[|"hop"|]| as described in
	section~??[basics.arrows], \eg, |[1,2]| is the same as |[drr]|.

\item
	$|"|r|,|c|"|$~, where $r,c$ are positive integers, denotes the
	"absolute entry" found in the $r$th row and $c$th column of the
	diagram; the top left entry is |"1,1"|.

\item
	$t'|;|t$~, where $t'$ is any target, changes the ??!w[base entry] of
	the present arrow to $t'$ and then sets the target to $t$ relative to
	the original base.  For example,
%
\begin{code}
\diagram
 A \\
 B & C \ulto    <1ex>
       \ulto;[] <1ex>
\enddiagram
\end{code}
\displaycode
%
\noindent typesets
$$
\docode
$$
	\ie~the |\ulto| arrow "starts" at the |[ul]| entry and ends in the
	current entry (remember from \S??[basics.arrows] that |\ulto|
	is the same as |\xto[ul]|).

\end{itemize}
%
	Composite targets may be constructed: any complete target can be
	followed by
%
\begin{itemize}
\item
	??c![+]"vector" or ??c![-]"vector" which changes the target to be a
	zero-sized one at the position obtained by adding or subtracting the
	"vector" to its center, or

\item
	??c![!]"vector" which moves the center of the target by the "vector";
\end{itemize}
%
	where a "vector" should have the form
%
\begin{itemize}
\item
	$|<|D_x|,|D_y|>|$ , where $D_x,D_y$ are \TeX\ dimensions, is the
	vector with those coordinates,

\item
	the following `corner offsets' of a target are vectors as shown:
 $$
\def\[#1]{\POS"box"+0;"box"+#1 **\dir{-} ?>*\dir{>} +/1pc/ *\hbox{\tt#1}}
%
\xy 0.(-11,-6).(11,6)!C="box"*\frm{.},"box";
 "box"+L**\dir{.}, "box"+R**\dir{.}, "box"+D**\dir{.}, "box"+U**\dir{.}
%
 \[L] \[R] \[D] \[U]
 \[DL]\[DR]\[UL]\[UR]
\endxy
$$
	(they must be specified in upper case), and

\item
	|0| is the zero vector.

\end{itemize}
%
	These constructions are useful for pointing to corners of entries,
	\eg,
%
\begin{code}
\diagram
 \left[\sum^i\right] & j \lto+UR
\enddiagram
\end{code}
\displaycode
%
\noindent will typeset
$$
\docode
$$

\begin{exercise}
%
	What is the difference between a target $t$ and the target $t$|+0|?
\answertext{The size: $t$|+0| always has zero size.}
\end{exercise}
%
\begin{quote}\it
	The position language of "v3" is much richer than this: there it is
	possible to build stacks of positions, typeset material in the middle
	of locating a position, etc.
\end{quote}


\subsection{Arrows passing under}
??=[arrows.pass]
%
	The `|x|-form' of the morphisms may pass under any other entry: Just
	insert $|'|t$, \ie, a quote character followed by a target, for each
	entry that should be visited except the last, `ordinary \& final'
	entry:
%
\begin{code}
\diagram
 \circ
  \xdashed '[dr] ^a |<\stop
           '[rr]+D ^b
            [drrr] ^c |>\tip
       & \circ & \circ & \circ \\
 \circ & \circ & \circ & \circ
\enddiagram
\end{code}
\displaycode
%
\noindent
	typesets
$$
\docode
$$
	As you see, labels are set separately on each segment.

\begin{exercise}
\begin{code}
\diagram
 & \lambda\omega \rrline\xline'[d][dd]
   & & \lambda C \ddline
\\
 \lambda2\urline \rrline\ddline
 & & \lambda P2 \urline\ddline
\\
 & \lambda\underline\omega \xline'[r][rr]
   & & \lambda P\underline\omega
\\
 \lambda{\to} \rrline\urline
 & & \lambda P \urline
\enddiagram
\end{code}
%
	Typeset the `lambda cube'
$$
\docode
$$
	"Hint": `going under' an empty entry leaves a small gap at that
	location.
%
\answercode
\answertext{The author typed \displaycode}
\end{exercise}


\subsection{More bending arrows}
??=[arrows.bend]
%
	Finally, the |x|-form of arrows may bend around entries: just insert
	$|`|d\,t$, \ie, a backquote, direction $d$, target $t$, for each
	`turn' that starts out in the $d$-direction and ends in a quarter
	turn towards the target~$t$.

	The possible directions are named like "hop"s:
$$
\xy *[o]\cir<1pc>{}="c",
  "c"; (-1,-1)**{},p+/4pc/ *+{|dl|} **\dir{-}?>*\dir{>},
  "c"; ( 0,-1)**{},p+/4pc/ *+{|d|}  **\dir{-}?>*\dir{>},
  "c"; ( 1,-1)**{},p+/4pc/ *+{|dr|} **\dir{-}?>*\dir{>},
  "c"; ( 1, 0)**{},p+/4pc/ *+{|r|}  **\dir{-}?>*\dir{>},
  "c"; ( 1, 1)**{},p+/4pc/ *+{|ur|} **\dir{-}?>*\dir{>},
  "c"; ( 0, 1)**{},p+/4pc/ *+{|u|}  **\dir{-}?>*\dir{>},
  "c"; (-1, 1)**{},p+/4pc/ *+{|ul|} **\dir{-}?>*\dir{>},
  "c"; (-1, 0)**{},p+/4pc/ *+{|l|}  **\dir{-}?>*\dir{>},
\endxy
$$
	and the possible targets include all those discussed above and in the
	reference manual~\cite{R94:XY-picRM}.

	Actually the direction letter is only required for the first in a
	series of turns since the final direction of one turn is the default
	for the following turn.  The quarter turns will have radius 10pt by
	default, but this can be changed to any dimension $R$ from a
	particular turn and onwards by inserting $|/|R$ immediately after the
	|'| of the turn.  Here is an example involving all of these features:
%
\begin{code}
\diagram
 \circ \xto `r[d] ^a
            `[rr] ^b
            `/4pt[rr] ^c
            `[rrr]^d
            `[drrr]^e
             [drrr]^f
       & \circ & \circ & \circ \\
 \circ & \circ & \circ & \circ
\enddiagram
\end{code}
\displaycode
%
	typesets
$$
\docode
$$
	The example illustrates the following points:
%
\begin{itemize}
\item
	If the segment can not be made as short as required then it will point
	`past' the target.  This is useful for `going around' entries.

\item
	Each target appears as many times as there are quarter turns towards
	it, except the last target that appears both as the last |`|-target
	and once as an `ordinary' target to set the final stretch.

\item
	The sizes of the intermediate targets are ignored.

\end{itemize}
%
	The bending arrows in section~??[basics.bends] are special cases of
	the above construction.  There are several more advanced
	possibilities described in~\cite{R94:XY-picRM}, notably the
	possibility for non-quarter turns.
%
\begin{quote}\it
	The "v3" reference manual explains how the in- and out-going
	direction and orientation of each turn can be specified.
\end{quote}


\subsection{Defining new arrow types}
??=[arrows.defining]
%
	All of the above arrows are really defined using the primitive
	|\morphism| that is used like this:
%
\begin{defs1}
 |\morphism| <line type> <tip> <tip> <path>
\end{defs1}
\noindent\unskip
%
	where
%
\begin{itemize}
\item
	<line type> is one of the following (shown above a sample):
$$
\spreaddiagramcolumns{-1pc}
\spreaddiagramrows{-1pc}
\diagram
 \relax|\solid|\go+DL\morphism\solid\notip\notip+<3pc,-2pc>
 &\relax|\Solid|\go+DL\morphism\Solid\notip\notip+<3pc,-2pc>
 &\relax|\Ssolid|\go+DL\morphism\Ssolid\notip\notip+<3pc,-2pc>
 &
\\
\\
 \relax|\dashed|\go+DL\morphism\dashed\notip\notip+<3pc,-2pc>
 &\relax|\Dashed|\go+DL\morphism\Dashed\notip\notip+<3pc,-2pc>
 &\relax|\Ddashed|\go+DL\morphism\Ddashed\notip\notip+<3pc,-2pc>
\\
\\
 \relax|\dotted|\go+DL\morphism\dotted\notip\notip+<3pc,-2pc>
 &\relax|\Dotted|\go+DL\morphism\Dotted\notip\notip+<3pc,-2pc>
 &\relax|\Ddotted|\go+DL\morphism\Ddotted\notip\notip+<3pc,-2pc>
 \null\\
\enddiagram
$$
	or the special $|{\dottedwith{|x|}}|$ (where $x$ may be any
	math formula) to typeset lines like
$$
\xy \morphism{\dottedwith{x}}\notip\notip +<3pc,-2pc>*{} \endxy
$$

\item
	The first <tip> specifies what to do with the target end of the
	connection, the second with the base end.  Each must be either
	|\notip| if no tip is desired, one of the tips described in
	section~??[arrows.tips], or several such tips grouped together in
	|{|\dots|}| (\eg, use |{\tip\stop}| to get the tip of $\diagram
	\morphism\solid{\tip\stop}\notip[0,1] & \enddiagram$).  Remember to
	use the special |\Tip| with |\Solid| and |\Dashed|.
\end{itemize}
%
	As an example, the |\ddrto| command described in
	section~??[basics.arrows] is really just an abbreviation for
	|\morphism| |\solid| |\tip| |\notip| |[ddr]|.

	You can also define new `straight arrow types' that are available in
	all the standard directions shown in the figure in
	section~??[basics.arrows] as well as the `|x|-form'.  The following
	uses this for a new arrow type |mapsto|:
%
\begin{code}
\definemorphism{mapsto}\solid\tip\stop
\diagram
 A \rmapsto^f & A\times A \dlmapsto_g \\
 B \umapsto
\enddiagram
\end{code}
\displaycode
\noindent\unskip
%
	typesets
$$
\docode
$$
	You should only use |\definemorphism| if you need it, though, since
	it defines many control sequences.  The reference
	manual~\cite{R94:XY-picRM} describes how to define your own groups of
	bent arrows and how to make double and triple tips.  It also
	describes a much more general way of defining new arrows.
%
\begin{quote}\it
	The "v3" arrow and directional commands make this obsolete in that
	most arrows can be specified directly in a very compact way.
\end{quote}



\section{More Entries}
??=[entries]
%
	This section explains what can go in an entry and how the general
	form of the entries??w[entry] is changed.


\subsection{Text}
??=[entries.text]

	The simplest form of text in diagrams is set with the |\text|
	command:
%
\begin{code}
\diagram
 \text{Program} \rto & \text{Code}
\enddiagram
\end{code}
\displaycode
%
\noindent will typeset
$$
\docode
$$

	If your text contains several centered lines, you can use |\Text|
	instead:
%
\begin{code}
\diagram
 \Text{A very long and stupid\\program}
 \rrto^-{\Text{weird\\arrow}}
   && \Text<2pc>{Com\-pli\-cated\\Code}
\enddiagram
\end{code}
\displaycode
%
\noindent will typeset
$$
\NoCompileAllDiagrams\docode
$$
	which illustrates that |\text| and |\Text| can also be used to format
	labels; in particular notice how the |-| place specifier is useful in
	this context.  Lines will be broken where you have specified |\\| and
	if they are longer than any \TeX\ dimension specified in |<>|s
	between |\Text| and the text in |{}|s.
%
\begin{quote}\it
 	In "v3" many variations are allowed, provided the DVI-driver can 
	support them. This includes rotation and scaling of text.
\end{quote}


\subsection{Extra entries outside the matrix}
??=[entries.extra]
%
	It is possible to put extra entries in your diagrams that are not
	part of any `entry' of the matrix created by |&| and |\\|.  This is
	done with the `excursion command'
%
\begin{defs1}
 |\save| $t$ |\Drop| |{|"stuff"|}| \dots |\restore| \dots
\end{defs1}
\noindent\unskip
%
	where $t$ should be a target in one of the formats described in
	section~??[arrows.targets] and "stuff" may be anything that can
	appear in an ordinary entry.

	This will create a `pseudo entry' at $t$ containing |{|"stuff"|}|:
	any \XY-pic commands following before |\restore| will be relative to
	the pseudo entry rather than to the entry hosting the excursion.
	Here is an example, using an entry relative position as target:
%
\begin{code}
\diagram
 A \drline
 & \save +<3cm,0cm>
    \Drop{\Text<8pc>{%
     This is a very big commentary
     but it does not otherwise affect
     the diagram.}}
    \lto \dto \restore
\\
 & B \rline & C \rline & D
\enddiagram
\end{code}
\displaycode
%
\noindent will typeset
$$
\NoCompileAllDiagrams\docode
$$
	It illustrates how a `down' arrow does not necessarily have to point
	particularly straight down---in this case because it is based in the
	displaced pseudo entry.  There is a variant of |\Drop| called |\drop|
	that will set the argument formula without any surrounding margin.
%
\begin{quote}\it
	The "v3" position language makes excursions much simpler and more
	general.
\end{quote}


\subsection{Resizing and spacing}
??=[entries.resizing]
%
	Entries can have their size and spacing changed in the following
	ways:
%
\begin{itemize}
\item
	|\grow{|"formula"|}| is the same as "formula" except that it is
	made the current "objectmargin" larger in all directions.

\item
	|\grow<|$D$|>{|"formula"|}|, where $D$ is a \TeX\ dimension, is
	similar except that $D$ is used for the enlargement
	instead---negative $D$ means shrink it.

\item
	|\squarify{|"formula"|}| will make "formula" square by extending
	the smaller of its vertical/horizontal size equal to the larger.

\item
	|\squarify<|$D$|>{|"formula"|}|, where $D$ is a \TeX\ dimension, is
	similar except the square will be $D$ on each side.

\end{itemize}
%
	You can change the "??!w[objectmargin]" from the default jot using
	the command
%
\begin{defs1}
 |\objectmargin| |{|<dimen>|}|
\end{defs1}

	The usual spacing between the rows and columns can be adjusted
	relative to the default 2pc by
%
\begin{defs1}
 |\spreaddiagramrows| |{|<dimen>|}|\cr
 |\spreaddiagramcolumns| |{|<dimen>|}|\cr
\end{defs1}
\noindent\unskip
%
	that will increase the row/column separation by the specified amount
	(similar to |\spreadmatrixlines| of \AMS-\TeX).

	Finally, the ??!w[minimal width] and ??!w[minimal height] of all
	objects can be set by
%
\begin{defs1}
	|\objectwidth| |{|<dimen>|}| \cr
	|\objectheight| |{|<dimen>|}| \cr
\end{defs1}
%
\begin{quote}\it
	With the "v3" matrix feature an individual entry can be readjusted
	and resized without affecting the overall structure.  Also the entire
	matrix can be rotated.
\end{quote}


\subsection{Style}
??=[entries.style]
%
	As mentioned above, the entries of a diagram are set in math mode in
	text style.  You may change this by redefinining the macro
	|\objectstyle|, and the label style by redefining |\labelstyle|.  We
	can combine this with the above to get `small diagrams', \eg, typing
%
\begin{code}
$\left(
 \spreaddiagramrows{-1.2pc}
 \spreaddiagramcolumns{-1.2pc}
 \def\objectstyle{\scriptstyle}
 \def\labelstyle{\scriptstyle}
 \diagram
  A \rto^{a}  & B \dto^{b} \\
  A'\uto^{a'} & B'\lto_{b'}
 \enddiagram
\right)$
\end{code}
\displaycode
%
\noindent in a paragraph will typeset ``\docode''.

	You can even abandon the use of math mode entirely: the command
	|\def| |\objectstyle| |{\hbox}|\ will change the format of entries to
	plain text.
%
\begin{quote}\it
	With the "v3" matrix command the style and shape of individual
	entries can be changed.
\end{quote}


\subsection{Framing and circling}
??=[entries.framing]
%
	You can put a box around an entry in a diagram by inserting the
	|\framed| command anywhere in the entry; if you prepend a \TeX\
	dimension in |<>|s then the box will have rounded corners with radius
	as the \TeX\ dimension.  There is also |\Framed| that does the same
	but makes a double box.  Here are some examples:
$$
\spreaddiagramrows{-1pc}\spreaddiagramcolumns{-1pc}
\diagram
 \relax|\framed|\framed
 &\relax|\Framed|\Framed
\\
 \relax|\framed<5pt>|\framed<5pt>
  &\relax~\Text{|\Framed<100pt>|\\(with maximum)}~\Framed<100pt>
\enddiagram
$$
	As you can see, the radius is scaled down to be useable; furthermore
	none of these commands are guaranteed to produce curves with a radius
	of more than 40pt.

	In case you want `perfect' circles there are |\circle| and |\Circle|
	commands that will just use half the width of the current entry as
	their outer radius unless an explicit radius is given in |<>|s.  They
	should be used with |\squarify|; \eg,
%
\begin{code}
\spreaddiagramrows{-1pc}
\diagram
   \rto^>(.5){\text{start}}
 & \squarify<1em>{0} \circled \toru^b \rto_a
 & \squarify<1em>{1} \circled \rto^b \tord_a
 & \squarify<1em>{2} \circled \rto^b
   \xto `r+D `[l]  _a `[l]   [l]
 & \squarify<1em>{3} \Circled
   \xto `r+U `[lll]^b `[lll] [lll]
   \xto `r+D `[ll] _a `[ll]  [ll]
\enddiagram
\end{code}
\displaycode
%
\noindent will typeset
$$
\NoCompileAllDiagrams\docode
$$
	Many more frames types are described in the reference
	manual~\cite{R94:XY-picRM}.
%
\begin{quote}\it
	In "v3" objects can be truly round.
\end{quote}


\subsection{Naming for later use as targets}
??=[entries.naming]
%
	If you build an entry with a long and complicated excursion then you
	might wish to be able to refer to it later.  \XY-pic provides a
	mechanism for this: if you specify
%
\begin{defs1}
 |\save| \dots |\go="|"name"|"| |\restore|
\end{defs1}
\noindent\unskip
%
	then the last pseudo entry (target with the last object |\Drop|'ed on
	it) build within the \dots\ excursion will be saved for later
	referencing as |"|"name"|"|; however, it is only possible to
	reference it `after' the naming, that is, from entries right of the
	base entry in the current row and below it.  We need this if we want
	to point to objects created in excursions:
%
\begin{code}
\diagram
 A \drline
 & \save \go+<3cm,0cm>\Drop{\Text<8pc>{
     This is still just a big commentary.}}
   \lto \dto \go="comment" \restore \\
 & B \rline & C \xto"comment" & D
\enddiagram
\end{code}
\displaycode
%
\noindent typesets
$$
\NoCompileAllDiagrams\docode
$$
%
\begin{quote}\it
	In "v3" naming of labels is possible.
\end{quote}


\subsection{Grouping objects}
??=[entries.grouping]
%
	Sometimes you wish to frame or otherwise treat a rectangle of objects
	as a single object.  This is possible with special excursions of this
	form:
%
\begin{defs1}
 |\save| $t$ |\merge| \dots |\restore| \dots
\end{defs1}
\noindent\unskip
%
	will make the entire rectangle of entries with the host entry in one
	corner and the target entry~$t$ in the other corner the `current
	entry' until the |\restore|.  Here is an example where we frame a
	couple of objects and point from the frame:
\begin{code}
\diagram
 0,{-1} & 0,0
  \save\go[1,2]\merge\framed<5pt>
   \xto[0,-1]\xto[1,-1]\xto[0,3]\xto[1,3]
  \restore
	      & 0,1 & 0,2 & 0,3 \\
 1,{-1} & 1,0 & 1,1 & 1,2 & 1,3 \enddiagram
\end{code}
\displaycode
\noindent will typeset
$$
\docode
$$
	As you can see, the center of the |\merge|d object is the same as
	the one of the target preceeding it.

	Here is a more advanced example where we create two |\merge|d
	objects with center in their center, name them and then connect to
	them:
\begin{code}
\def\g#1{%
 \save
  \go[dr]\merge\go+C\merge\go="g#1"\framed
 \restore}
%
\diagram
\g1 A\rto & B\dto  & \g2 A'\rto & B'\dto \\
    C\uto & D\lto  &     C'\uto & D'\lto
  \save \go"g1" \xdotted"1,4"|>\tip \restore
  \save \go"2,1"\xdashed"g2" |>\tip \restore
\enddiagram
\end{code}
$$
\NoCompileAllDiagrams\docode
$$
	can be typeset by
%
\displaycode
%
	The centering trick is achieved by using |\merge| twice in~|\g|: the
	second just merges with a dummy object with center where we want the
	final merged object to be centered!  Then we can make arrows from/to
	the two frames by using the two new targets |"g1"| and |"g2"|.
%
\begin{quote}\it
	Merging is part of the "v3" position language.
\end{quote}



\section{Availability and Further Information}
??=[avail]

\subsection{Getting \XY-pic}

	The latest version of \XY-pic can be retrieved from Internet
	anonymous ftp host {\tt ftp.diku.dk} in {\tt /diku\slash users\slash
	kris\slash TeX} as well as from {\tt ftp.mpce.mq.edu.au} in {\tt
	/pub\slash maths\slash TeX} in files starting with |xy|.  It has also
	been contributed to the CTAN archives where it is located (unpacked
	only) in the directory {\tt macros\slash generic\slash diagrams\slash
	xypic}.

\paragraph*{License:}
%
	\XY-pic is free software in the sense that it is available under the
	following license conditions:
$$
\xy
 *+\txt{\XY-pic: Graphs and Diagrams with \TeX\\
	\copyright~1991--1994\quad Kristoffer H. Rose}
 *\frm{-}
\endxy
$$
	The \XY-pic package is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of the
	License, or (at your option) any later version.

	The \XY-pic package is distributed in the hope that it will be
	useful, but "without any warranty"; without even the implied warranty
	of "merchantability" or "fitness for a particular purpose".  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this package; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.

\subsection{The future and backwards compatibility}
%
	\XY-pic version~3 is currently under development through
	collaboration between the author and Ross Moore.  Partial funding for
	this project has been provided by a Macquarie University Research
	Grant (MURG), by the Australian Research Council (ARC), and through a
	research agreement with the Digital Equipment Corporation (DEC).

	We invite all users of \XY-pic to participate in this venture with
	suggestions for adding features, eliminating misfeatures, and
	anything else that might improve the usefulness of \XY-pic.  Please
	contact the author for further information or if you want to be kept
	up to date with the development.

	This does mean, however, that from time to time features may turn out
	to be redundant because they can be implemented in a better way.
	This is currently the case for the following features of version~2.6
	and earlier versions; in each case a fix is proposed:
%
\begin{itemize}
\item
	Automatic `shortening' of arrow tails by ??c![|<<] break was a bug
	and has been `fixed' so it does not work any more.  "Fix": Put a
	|||<\hole| break before it as described in section~??[arrows.tips].
\item
	The version~2.6 ??c![*] position operator is not available.  "Fix":
	Use the |:| and |::| operators (described in detail in the reference
	manual~\cite{R94:XY-picRM}).
\item
	Using $t_1|;|t_2|:(|x|,|y|)|$ as the target of an arrow command does
	not work.  "Fix": Enclose it in braces, \ie, write
	$|{|t_1|;|t_2|:(|x|,|y|)}|$.
\item
	The older ??c![\pit], ??c![\apit], and ??c![\bpit] commands are not
	defined.  "Fix": Use |\dir{>}| (or |\tip|) with variants and
	rotation.
\end{itemize}
%
	Finally note that sometimes the spacing with version~\xyversion\ is
	slightly different from that of earlier versions which had some
	spacing bugs.

	Please report all other things that do not work the same in
	version~2.6 and~\xyversion\ to the author.



\ANSWERS
\BIBLIOGRAPHY

\end{document}

% $Log: xyguide.man,v $
% Revision 2.10  1994/06/15  12:55:07  kris
% Second 3beta release: bug fixes.
%
% Revision 2.9  1994/06/09  14:59:19  kris
% Release 3beta.
%
% Revision 2.8  1994/04/08  04:30:00  kris
% Second (bug fix) 3alpha release.
%
% Revision 2.7  1994/03/08  02:06:01  kris
% Release 3alpha.
%
% Revision 2.6.9.1  1994/03/07  04:22:46  kris
% Last internal 3alpha and pre-2.7 release.
%
% Reformatted for LaTeX with companion xydoc.sty.
% Renamed from xypicman.doc to xyguide.man.
%
% Revision 2.6.1.1  1992/07/01  07:08:24  kris
% Send to EuroTeX '92...
%
% Revision 2.6  1992/06/24  01:23:34  kris
% Reorganised...
% Documented new features: hooks, triple lines, positions, and LaTeXdiagrams.
%
% Revision 2.5  1992/02/24  03:30:54  kris
% Documented changes in xypic.doc[2.5].
%
% Revision 2.4  1992/01/22  02:15:10  kris
% Cosmetic changes; removed \pit and introduced \rotate.
%
% Revision 2.3  1992/01/13  01:51:02  kris
% Changed to use `pure' XPPT [1.20].
% Several cosmetic changes, e.g., corrected definition of \ddtor in footnote.
%
% Revision 2.2  1992/01/09  04:05:40  kris
% Patched to fix problem with \text and support AMS-LaTeX.
%
% Revision 2.1  1992/01/02  14:54:07  kris
% Release version.
%
% Revision 1.7  1991/12/17  04:53:23  kris
% Version distributed as `final draft' on Usenet.
% Added bent arrows properly; support for double tips; proper \Text;
% fixed name clashes...
% This version is for bug fixes only!!
%
% Revision 1.6  1991/12/06  08:53:06  kris
% Draft ready for wider distribution...
% Fits xypic.doc[1.39]; still needs better examples.
%
% Revision 1.5  1991/12/03  07:53:28  kris
% Extended with the xypic.doc[1.37] possibility for exotic arrow
% tips; also added description of \merge.
%
% Revision 1.4  1991/12/02  06:08:42  kris
% Fixed various things; fits xypic.doc[1.36].
%
% Revision 1.3  1991/12/01  07:40:07  kris
% Corresponds to xypic.doc[1.35].
%
% Revision 1.2  1991/11/28  04:42:49  kris
% Corresponds to xypic.doc[1.34].
% Cleaned up a lot; now only bending arrows are missing...and good examples.
%
% Revision 1.1  1991/11/27  06:48:17  kris
% Initial: \beta-test on DIKU.
%
% Based on version in DIKU student report 91-7-10.


% Tell Emacs that this is a LaTeX document and how it is formatted:
% Local Variables:
% mode:latex
% fill-prefix:"\t"
% fill-column:77
% paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% End:
