%% $Id: xyrefer.man,v 2.11 1994/07/05 10:37:32 kris Exp $
%%
%% Wrapper to print ``\XY-pic Reference Manual''.
%% Copyright (c) 1994 Kristoffer H. Rose <kris@diku.dk>, all rights reserved.

\documentstyle[twocolumn,xydoc]{article}
\def\LaTeXe{{\LaTeX\kern.15em$2_{\textstyle\varepsilon}$}} % avoid `bug'

\let\originalxyprovide=\xyprovide
\def\specialxyprovide#1#2#3#4#5#6{%
 \let\xyprovide\originalxyprovide
 \edef\OPROPER{#2}\edef\OVERSION{#3}%
 \def\OAUTHOR{#4}\def\OAUTHOREMAIL{#5}\def\OAUTHORADDRESS{#6}%
 \expandafter\section\expandafter{\OPREFIX\OPROPER}??g=[#1]%
 \subsubsection*{\raggedright Vers. \OVERSION\ by~\OAUTHOR\ <\OAUTHOREMAIL>\\*
   \LOADAS{#1}}%
 \OEXTRA
 \xyprovide{#1}{#2}{#3}{#4}{#5}{#6}}

\def\OSECTION#1{\let\xyprovide=\specialxyprovide
 \def\OPREFIX{}%
 \def\LOADAS##1{Load as: {\tt\string\xyoption\string{##1\string}}}%
 \def\OEXTRA{}%
 \input{#1}\inputdoc1{#1}}

\let\defaultinputdocmode=1

\begin{document}

% TOPMATTER

\title{	\XY-pic Reference Manual }
\author{ Kristoffer H. Rose\\<kris@diku.dk>\thanks{%
		DIKU (Computer Science dept.), University of Copenhagen,
		Universitetsparken~1, DK--2100 K{\o}benhavn {\O}, Denmark.}
	\and
	 Ross Moore\\<ross@mpce.mq.edu.au>\thanks{%
		MPCE (Mathematics dept.), Macquarie University,
		North Ryde, Sydney, Australia NSW~2109.}
}
\date{Version \xyversion/$3\beta$\thanks{%
	The ``/$3\beta$'' in the version is meant to indicate that this is a
	$\beta$-test version of \XY-pic version~3 currently under development
	by the authors.  Partial funding for this project has been provided
	by a Macquarie University Research Grant (MURG), by the Australian
	Research Council (ARC), and through a research agreement with the
	Digital Equipment Corporation (DEC).  Thus this manual contains a few
	`Bug' and `To Do' paragraphs describing facilities not yet fully
	implemented.}\quad<\xydate>}
\maketitle

\begin{abstract}

	This manual summarises the capabilities of the \XY-pic package for
	typesetting graphs and diagrams in \TeX.

	A characteristic of \XY-pic is that it is build around a "kernel
	drawing language" which is a concise notation for general graphics,
	\eg,
%
\begin{code}
\xy (3,0)*{A} ; (20,6)*+{B}*\cir{} **\dir{-}
    ? *_!/3pt/\dir{)} *_!/7pt/\dir{:}
    ?>* \dir{>} \endxy
\end{code}
%
$$\docode$$
%
	was drawn by the \XY-pic kernel code
%
\displaycode\noindent
%
	It is an object-oriented graphic language in the most literal sense:
	`objects' in the picture have `methods' describing how they typeset,
	stretch, etc., however, the syntax is rather terse.

	Particular applications make use of "extensions" that enhance the
	graphic capabilities of the kernel---in fact the kernel is quite
	useless without any extensions that handle such diagrams as
%
\begin{code}
\xy *[o]=<40pt>\hbox{Round}="o"*\frm{oo}
    +<5em,-5em>="c1",
    (46,11)*+\hbox{Square}="s"  *\frm{-,}
    -<5em,-5em>="c2"
 \POS"o";"s" \curve{~*i{}"c1"&"c2"}
 \POS ?*+\hbox{Bend}="b"*\frm{.} ?>*\dir{>}
 \POS"o";"s"."b" \curve{"c1"&"c2"}
 \POS"o"."b";"s" \curve{"c1"&"c2"}
\endxy
\end{code}
$$\docode$$
%
	which was typeset by
%
\displaycode
\noindent
%
	using the `curve' and `frame' extensions.

	All this is made accesible through "features" that provide convenient
	notation such that users can enter special classes of diagrams in an
	intuitive form, \eg, commutative diagrams are catered for by the
	`matrix' and `graph' features with which the diagram
%
\begin{code}
\xy\xygraph{
 !M{X \times_Z Y \="xy" \:[r]_p \:[d]^q 
                    & X \="X" \:[d]_f \\
    Y \="Y" \:[r]^g & Z }
 [ul]U   ( ? :@/^.5pc/ ^x        "X" ,
           ? :@{-->}   |-{(x,y)} "xy" ,
           ? :@/_.5pc/ _y        "Y" )
}\endxy
\end{code}
$$\docode$$
%
	was typeset by the \XY-pic input lines
%
\displaycode

	We will not describe the combination of features in this manual:
	refer to the User's Guide~\cite{R94:XY-picUG} for a tutorial on how
	diagrams like the above can be typeset.

	The current implementation is programmed completely within ``standard
	\TeX\ and \MF'', \ie, using \TeX\ macros (no |\special|s) and fonts
	designed using \MF.  Optionally a special `backend' makes it possible
	to produce DVI files with `specials' for
	PostScript\footnote{PostScript is a trademark of Adobe, Inc.}
	drivers.

\end{abstract}

\tableofcontents
\listoffigures

%$$
%\xy
% *+\txt<.8\hsize>{{\bf Note:} This manual typeset
%  \PStest{as pure DVI (without any specials) so some effects are missing}%
%   {with `\PStype' \PS\ specials}.}
% *\frm{-}
%\endxy
%$$



\part{The Kernel}
\subsubsection*{Vers. \xyversion\ by Kristoffer H. Rose <kris@diku.dk>}

\def\APPENDIX{part}
\inputdoc1{xy.doc}



\part{Extensions}

	This part documents the graphic capabilities added by each standard
	extension option.  For each is indicated the described version
	number, the author, and how it is loaded.

\OSECTION{xycurve.doc}
\OSECTION{xyframe.doc}
\OSECTION{xyline.doc}
\OSECTION{xyrotate.doc}
\OSECTION{xycolor.doc}



\part{Features}

	This part documents the notation added by each standard feature
	option.  For each is indicated the described version number, the
	author, and how it is loaded.

	The first two, `all' and `dummy', described in~\S\S??g[:all]
	and~??g[:dummy], are trivial features that nevertheless prove useful
	sometimes.  The next two, `arrow' and `2cell', described
	in~\S??g[:arrow] and~??g[:2cell], provide special commands for
	objects that `point'.  The following two, `matrix' and `graph',
	described in~\S\S??g[:matrix] and~??g[:graph], are "input modes" that
	support different overall structuring of (parts of) \XY-pictures.
	The final feature, `v2' described in~\S??g[:v2], supports the input
	mode and arrow commands that were available in \XY-pic version~2.

\OSECTION{xyall.doc}
\OSECTION{xydummy.doc}

\OSECTION{xyarrow.doc}
\OSECTION{xy2cell.doc}

\OSECTION{xymatrix.doc}
\OSECTION{xygraph.doc}

\OSECTION{xyv2.doc}



\part{Backends}

	This part describes variant backends that support the customisation
	of the produced DVI files to particular output devices.  For each is
	indicated the described version number, the author, and how it is
	loaded.  Currently there is only backend supporting output to \PS\
	devices.

\OSECTION{xyps.doc}



\ANSWERS
\BIBLIOGRAPHY
\addtocontents{toc}{\protect\contentsline
 {section}{Bibliography}{\protect\pageref{BIBLIOGRAPHY}}}%

%\INDEX

\end{document}

% $Log: xyrefer.man,v $
% Revision 2.11  1994/07/05  10:37:32  kris
% Third 3beta release [bug fixes].
% Experimental graph feature included (for ECCT-94 presentation).
%
% Revision 2.10  1994/06/15  12:55:07  kris
% Second 3beta release: bug fixes.
%
% Revision 2.9  1994/06/09  14:59:19  kris
% Release 3beta.
%
% Revision 2.8  1994/04/08  04:30:00  kris
% Second (bug fix) 3alpha release.
%
% Revision 2.7  1994/03/08  02:11:01  kris
% Release 3alpha.
%
% NEW for version 2.7.

% Tell Emacs that this is a LaTeX document and how it is formatted:
% Local Variables:
% mode:latex
% fill-prefix:"\t"
% fill-column:77
% paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% End:
