#include <X11/X.h>
#include <X11/Xlib.h>
#include <math.h>
#include <stdio.h>
#include "trippy.h"

struct well
{
  double x,y;
  int mass;
} *wells;

struct particle** partlst;
void reset_part(struct particle *,int);

void
init_gravity(int winno)
{
  register int i;
  struct particle *temp;
  static int inited=0;
  
  if(!inited)
    {
      partlst= (struct particle**)malloc(options.windows*
					 sizeof(struct particle*));
      inited=1;
      wells = (struct well *)malloc(options.number*sizeof(struct well));
    }

  partlst[winno]=(struct particle *)malloc(options.numparts*
					   sizeof(struct particle));
  
  /* set up the gravity wells */
  for(i=0;i<options.number;i++)
    {
      wells[i].x=rndm(CX[winno]);
      wells[i].y=rndm(CY[winno]);
      wells[i].mass=100;
      XDrawPoint(display,window[winno],color_gcs[1],wells[i].x,wells[i].y);
    }
/* and init the particles */
  
  for(i=0;i<options.numparts;i++)
    {
      reset_part(&partlst[winno][i],winno);      
      /*      temp[i]=new_part(winno); */
    }
}

void
set_part(int winno,int x,int y,struct particle *thingy)
{
  thingy->x=x;
  thingy->y=y;
  thingy->mass=rndm(20);
  thingy->vx=thingy->vy=0.0;
  thingy->color=rndm(numcolors);
}

void
reset_part(struct particle *thingy,int winno)
{
  thingy->x=rndm(CX[winno]);
  thingy->y=rndm(CY[winno]);
  thingy->mass=rndm(20);
  thingy->vx=thingy->vy=0.0;
  thingy->color=rndm(numcolors);
}


int
draw_gravity(int winno)
{
  register int i,j;
  double F,ax,ay,theta;  

  for(j=0;j<options.numparts;j++)
    {
      struct particle *thingy =&partlst[winno][j];
      for(i=0;i<options.number;i++)
	{
	  /* do the forces from each well */
	  F=(double)(6.67e-4*wells[i].mass)/  /* *thingy->mass */
	    hypot((wells[i].x-thingy->x),(wells[i].y-thingy->y));
	  theta=atan2((wells[i].y-thingy->y),(wells[i].x-thingy->x));

/*
	  theta=((double)(theta*16)/(double)M_PI);
	  if(theta<0)
	    theta=32+theta;
*/
	  ax=ay=F; /* /(double)thingy->mass; */
	  ax*=cos(theta); /* CosTbl[(int)theta]; */
	  ay*=sin(theta); /* SinTbl[(int)theta]; */
	  thingy->vx+=ax;
	  thingy->vy+=ay;
	}
  
      for(i=0;i<options.numparts;i++)
	{
	  if(i==j)
	    continue;
      
	  /* do the forces from each particle */
	  F= (double)(6.67e-4*partlst[winno][i].mass)/   /* *thingy->mass */
	    hypot((partlst[winno][i].x-thingy->x),(partlst[winno][i].y-
						  thingy->y));
	  theta=atan2((partlst[winno][i].y-thingy->y),(partlst[winno][i].x-
						      thingy->x));
/*
	  theta=((theta*16)/(double)M_PI);
	  if(theta<0)
	    theta=32+theta;
 */  
	  ax=ay=F;   /* /(double)thingy->mass; */
	  ax*=cos(theta);  /* CosTbl[(int)theta]; */
	  ay*=sin(theta);  /* SinTbl[(int)theta]; */
	  thingy->vx+=ax;
	  thingy->vy+=ay;
	}
      
      /* move the particle */
      thingy->x+=thingy->vx;
      thingy->y+=thingy->vy;

      if(options.multi)
	thingy->color= (thingy->color+1)%numcolors;

      XDrawPoint(display,window[winno], color_gcs[thingy->color],thingy->x,
		 thingy->y);

      if((thingy->x>CX[winno])||(thingy->y>CY[winno])||
	 (thingy->x<0)||(thingy->y<0))
	reset_part(thingy,winno);
    }
  return 0;
}

