#include <X11/X.h>
#include <X11/Xlib.h>
#include <math.h>
#include <stdio.h>
#include "trippy.h"

/* Yow! have some global pointers */
int *X1, *Y1, *X2, *Y2, *X3, *Y3, *XV1, *YV1, *XV2, *YV2, *XV3, *YV3, *HC, HCV;
int *XA, *YA, *XB, *YB, *XC, *YC, *XD, *YD, *XE, *YE, *XF, *YF, *XG, *YG;


init_kaleid(int nwin)
{
  static int inited=0;
  int i;
  if(!inited)
    {
      if ((X1 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((Y1 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((X2 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((Y2 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((X3 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((Y3 =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XV1=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YV1=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XV2=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YV2=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XV3=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YV3=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XA =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YA =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XB =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YB =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XC =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YC =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XD =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YD =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XE =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YE =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((XF =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((YF =(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      inited=1;
    }
}

void
randomize_kal(int i)
{
  X1[i] = rndm((long)M) + 1;
  X2[i] = rndm((long)M) + 1;
  X3[i] = rndm((long)M) + 1;
  Y1[i] = rndm((long)X1[i]);
  Y2[i] = rndm((long)X2[i]);
  Y3[i] = rndm((long)X3[i]);
  
  XV1[i] = rndm(7L)-3;
  XV2[i] = rndm(7L)-3;
  XV3[i] = rndm(7L)-3;
  YV1[i] = rndm(7L)-3;
  YV2[i] = rndm(7L)-3;
  YV3[i] = rndm(7L)-3;
}

void fill_tris(int winno)
{
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]+XA[winno],
		   CY[winno]-YB[winno],
		   CX[winno]+XC[winno],
		   CY[winno]-YD[winno],
		   CX[winno]+XE[winno],
		   CY[winno]-YF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]-YA[winno],
		   CY[winno]+XB[winno],
		   CX[winno]-YC[winno],
		   CY[winno]+XD[winno],
		   CX[winno]-YE[winno],
		   CY[winno]+XF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]-XA[winno],
		   CY[winno]-YB[winno],
		   CX[winno]-XC[winno],
		   CY[winno]-YD[winno],
		   CX[winno]-XE[winno],
		   CY[winno]-YF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]-YA[winno],
		   CY[winno]-XB[winno],
		   CX[winno]-YC[winno],
		   CY[winno]-XD[winno],
		   CX[winno]-YE[winno],
		   CY[winno]-XF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]-XA[winno],
		   CY[winno]+YB[winno],
		   CX[winno]-XC[winno],
		   CY[winno]+YD[winno],
		   CX[winno]-XE[winno],
		   CY[winno]+YF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]+YA[winno],
		   CY[winno]-XB[winno],
		   CX[winno]+YC[winno],
		   CY[winno]-XD[winno],
		   CX[winno]+YE[winno],
		   CY[winno]-XF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]+XA[winno],
		   CY[winno]+YB[winno],
		   CX[winno]+XC[winno],
		   CY[winno]+YD[winno],
		   CX[winno]+XE[winno],
		   CY[winno]+YF[winno]),
	       3,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       tri(CX[winno]+YA[winno],
		   CY[winno]+XB[winno],
		   CX[winno]+YC[winno],
		   CY[winno]+XD[winno],
		   CX[winno]+YE[winno],
		   CY[winno]+XF[winno]),
	       3,Convex,CoordModeOrigin);
}

void fill_rects(int winno)
{
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]+XA[winno],
		       CY[winno]-YB[winno],
		       CX[winno]+XC[winno],
		       CY[winno]-YD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]-YA[winno],
		       CY[winno]+XB[winno],
		       CX[winno]-YC[winno],
		       CY[winno]+XD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]-XA[winno],
		       CY[winno]-YB[winno],
		       CX[winno]-XC[winno],
		       CY[winno]-YD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]-YA[winno],
		       CY[winno]-XB[winno],
		       CX[winno]-YC[winno],
		       CY[winno]-XD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]-XA[winno],
		       CY[winno]+YB[winno],
		       CX[winno]-XC[winno],
		       CY[winno]+YD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]+YA[winno],
		       CY[winno]-XB[winno],
		       CX[winno]+YC[winno],
		       CY[winno]-XD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]+XA[winno],
		       CY[winno]+YB[winno],
		       CX[winno]+XC[winno],
		       CY[winno]+YD[winno]),
	       4,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       wrecked(CX[winno]+YA[winno],
		       CY[winno]+XB[winno],
		       CX[winno]+YC[winno],
		       CY[winno]+XD[winno]),
	       4,Nonconvex,CoordModeOrigin);
}

void fill_circles(int winno)
{ 
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]+XA[winno],
			   CY[winno]-YB[winno],
			   CX[winno]+XC[winno],
			   CY[winno]-YD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]-YA[winno],
			   CY[winno]+XB[winno],
			   CX[winno]-YC[winno],
			   CY[winno]+XD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]-XA[winno],
			   CY[winno]-YB[winno],
			   CX[winno]-XC[winno],
			   CY[winno]-YD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]-YA[winno],
			   CY[winno]-XB[winno],
			   CX[winno]-YC[winno],
			   CY[winno]-XD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]-XA[winno],
			   CY[winno]+YB[winno],
			   CX[winno]-XC[winno],
			   CY[winno]+YD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]+YA[winno],
			   CY[winno]-XB[winno],
			   CX[winno]+YC[winno],
			   CY[winno]-XD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]+XA[winno],
			   CY[winno]+YB[winno],
			   CX[winno]+XC[winno],
			   CY[winno]+YD[winno]),
	       33,Nonconvex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[HC[winno]],
	       make_circle(CX[winno]+YA[winno],
			   CY[winno]+XB[winno],
			   CX[winno]+YC[winno],
			   CY[winno]+XD[winno]),
	       33,Nonconvex,CoordModeOrigin);
}

void draw_lines(int winno)
{
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]+XA[winno],
	    CY[winno]-YB[winno],
	    CX[winno]+XC[winno],
	    CY[winno]-YD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]-YA[winno],
	    CY[winno]+XB[winno],
	    CX[winno]-YC[winno],
	    CY[winno]+XD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]-XA[winno],
	    CY[winno]-YB[winno],
	    CX[winno]-XC[winno],
	    CY[winno]-YD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]-YA[winno],
	    CY[winno]-XB[winno],
	    CX[winno]-YC[winno],
	    CY[winno]-XD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]-XA[winno],
	    CY[winno]+YB[winno],
	    CX[winno]-XC[winno],
	    CY[winno]+YD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]+YA[winno],
	    CY[winno]-XB[winno],
	    CX[winno]+YC[winno],
	    CY[winno]-XD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]+XA[winno],
	    CY[winno]+YB[winno],
	    CX[winno]+XC[winno],
	    CY[winno]+YD[winno]);
  XDrawLine(display,window[winno],color_gcs[HC[winno]],
	    CX[winno]+YA[winno],
	    CY[winno]+XB[winno],
	    CX[winno]+YC[winno],
	    CY[winno]+XD[winno]);
}


XPoint 
*wrecked(int x1, int y1, int x2, int y2)
{
  XPoint *temp =(XPoint *)malloc(sizeof(XPoint)*4);
  
  temp[0].x = x1;
  temp[0].y = y1;
  temp[1].x = x2;
  temp[1].y = y1;
  temp[2].x = x2;
  temp[2].y = y2;
  temp[3].x = x1;
  temp[3].y = y2;
  
  return temp;
}

XPoint 
*tri(int x1,int y1, int x2, int y2, int x3, int y3)
{
  XPoint *temp=(XPoint *)malloc(sizeof(XPoint)*3);
  
  temp[0].x = x1;
  temp[0].y = y1;
  temp[1].x = x2;
  temp[1].y = y2;
  temp[2].x = x3;
  temp[2].y = y3;
  
  return temp;
}

XPoint
*make_bozo(int x1,int y1, int x2, int y2,
	   int x3,int y3, int x4, int y4)
{
  XPoint *temp;
  
  temp = (XPoint *)malloc(sizeof(XPoint)*5);
  
  temp[0].x = x1;
  temp[0].y = y1;
  temp[1].x = x2;
  temp[1].y = y2;
  temp[2].x = x3;
  temp[2].y = y3;
  temp[3].x = x4;
  temp[3].y = y4;
  temp[4].x = x1;
  temp[4].y = y1;
  
  return temp;
}


XPoint
*make_circle(int x1,int y1,int x2,int y2)
{
  /* (x1,y1) is the center;
  ** (x2,y2) is a point on the circle;
  */
  int radius;
  int count;
  int addx,addy;
  XPoint *temp;
  
  temp = (XPoint *)malloc(sizeof(XPoint)*33);
  radius = (int)hypot(x2-x1,y2-y1);
  
  for(count=0;count<=8;count++)
    { 
/* Finally added sin and cos, instead of faking it with Pythag's Theorem */
      addx=radius*SinTbl[count];
      addy=radius*CosTbl[count];
      temp[count].x=x1+addx;
      temp[count].y=y1+addy;
      temp[16-count].x= x1+addx;
      temp[16-count].y= y1-addy;
      temp[count+16].x= x1-addx;
      temp[count+16].y= y1-addy;
      temp[32-count].x= x1-addx;
      temp[32-count].y= y1+addy;
    }
  temp[32].x=temp[0].x;
  temp[32].y=temp[0].y;
  
  return temp;  
}

void draw_kaleid(yesno *rect,int winno)
{ 
  void boing(int);
  
  if (((!rndm(15L)&&(*rect==lizard_spit)))||(!rndm(40L))) 
    {
      switch (*rect)
	{
	case yes:
	  *rect=lizard_spit; break;
	case no:
	  *rect=maybe; break;
        case maybe:
	  *rect=yes; break;
	case lizard_spit:
	  *rect=no; break;
	}
    }
  boing(winno);
  
  if ((options.norect)||(*rect==no))
    {
      draw_lines(winno);
    }
  else if (*rect==yes)
    {
      fill_rects(winno);
    }
  else if (*rect==maybe)/* TRIANGLE */
    { 
      fill_tris(winno);  
    }
  else if (*rect==lizard_spit)
    {
      fill_circles(winno);
    }
}

void
draw_tunnel(int winno)
{
  int i,rev;
  XPoint points[4];
  int npoints = 4, shape = Convex,  mode = CoordModeOrigin;
  float frac;
  int min_x, max_x, mid_x, min_y, max_y, mid_y;
  
  if(rev==-1)
    rev=rndm(2);

  min_x = 0 - CX[winno]/2;
  max_x = CX[winno] * 3 / 2;
  mid_x = CX[winno] / 2;
  min_y = 0 - CY[winno]/2;
  max_y = CY[winno] * 3 / 2;
  mid_y = CY[winno] / 2;
  points[0].y = points[2].y = (short) mid_y;
  points[1].x = points[3].x = (short) mid_x;
  for (i=0; i<numcolors; i++)
    {
      frac = (float) i/numcolors;
      points[0].x = (short) min_x + CX[winno] * frac;
      points[2].x = max_x - points[0].x + min_x;
      points[1].y = (short) min_y + CY[winno] * frac;
      points[3].y = max_y - points[1].y + min_y;
      if(rev)
	XFillPolygon (display, window[winno], color_gcs[numcolors-i-1], points,
		      npoints, shape, mode);
      else
	XFillPolygon (display, window[winno], color_gcs[i], points,
		      npoints, shape, mode);
    }
}

void draw_clover(int winno)
{
  int x,y,gaaak;
  int midX=CX[winno]>>1;
  int midY=CY[winno]>>1;
  int col=1;
  int numLines=2*CX[winno]+2*CY[winno];
  int numberToSkip= numLines%numcolors/4; /* skip this many per side */

  for(x=0;x<CX[winno];x++)
    {
      XDrawLine(display,window[winno],color_gcs[col],
		CX[winno]-x,CY[winno],midX,midY);
      gaaak=x%(CX[winno]/numberToSkip);
      
      if(gaaak)
	{
	  col++;
	  if(col>numcolors-1)
	    col=1;	  
	}
    }
  for(y=0;y<CY[winno];y++)
    {
      XDrawLine(display,window[winno],color_gcs[col],
		0,CY[winno]-y,midX,midY);
      gaaak=y%(CY[winno]/numberToSkip);
      if(gaaak)
	{
	  col++;
	  if(col>numcolors-1)
	    col=1;	  
	}
    }
  for(x=0;x<CX[winno];x++)
    {
      XDrawLine(display,window[winno],color_gcs[col],
		x,0,midX,midY);
      gaaak=x%(CX[winno]/numberToSkip);
      
      if(gaaak)
	{
	  col++;
	  if(col>numcolors-1)
	    col=1;	  
	}
    }
  for(y=0;y<CY[winno];y++)
    {
      XDrawLine(display,window[winno],color_gcs[col],
		CX[winno],y,midX,midY);
      gaaak=y%(CY[winno]/numberToSkip);
      if(gaaak)
	{
	  col++;
	  if(col>numcolors-1)
	    col=1;	  
	}
    }
}

void draw_test(int winno)
{
  int x,y;
  int fx,fy;
  if(options.palette==3)
 {
   fx=fy=sqrt(numcolors);
  }
  else
  {
    fx=(numcolors/6);
    fy=6;
  }
  for (x=0;x<fx;x++)
    {
      for (y=0;y<fy;y++)
	{
	  XFillPolygon(display,window[winno],color_gcs[y*fx+x],
		       wrecked((float)(CX[winno]/fx)*x,
			       (float)(CY[winno]/fy)*y,
			       (float)(CX[winno]/fx)*(x+1),
			       (float)(CY[winno]/fy)*(y+1)),
		       4,Convex,CoordModeOrigin);
	}
      XFlush(display);
    }
}

void
draw_sphere(winno)
{
  int x2=rndm(CX[winno]);
  int y2=rndm(CY[winno]);
  int x1=rndm(CX[winno]);
  int y1=rndm(CY[winno]);

  HC[winno]=rndm(numcolors);

  while((abs(x1-x2)>1)&&(abs(y1-y2)>1))
    {
      XFillPolygon(display,window[winno],color_gcs[HC[winno]],
		   make_circle(x1, y1, x2, y2),
		   33,Nonconvex,CoordModeOrigin);
      if(x1-x2<0)
	{ x1++; x2--; }
      else if (x1-x2>0)
	{ x1--; x2++; }
      if(y1-y2<0)
	{ y1++; y2--; }
      else if (y1-y2>0)
	{ y1--; y2++; }
      HC[winno]=(HC[winno]+1)%numcolors;
      if(HC[winno]==0) HC[winno]=1;
    }
}

void
draw_off(int winno)
{
  int x,i;
  XGCValues values;
  /* White, Yellow,   Cyan,     Green,     Magenta,    Red, Blue */
  /* alloc, numcol/6, numcol/2, numcol/3,  5*numcol/6, 1,   2*numcol/3  */
  int foob[8];
  foob[0]= numcolors/12;
  foob[1]= numcolors/6;
  foob[2]= numcolors/2;
  foob[3]= numcolors/3;
  foob[4]= 5*numcolors/6;
  foob[5]= 1;
  foob[6]= 2*numcolors/3;
  
/* make an Orange into a White*/
  values.foreground=StrColor("white",WhitePixel(display,screen));
  XChangeGC(display,color_gcs[numcolors/12],GCForeground,&values);
  
/* and a blue-purple into a Navy */
  values.foreground=StrColor("navy blue",BlackPixel(display,screen));
  XChangeGC(display,color_gcs[9*numcolors/12],GCForeground,&values);

  for(i=0,x=0;i<7;i++,x++)
  {
    XFillPolygon(display,window[winno],color_gcs[foob[i]],
		 wrecked((float)(CX[winno]/7)*x,
			 (float)0,
			 (float)(CX[winno]/7)*(x+1),
			 (float)CY[winno]*.75),
		 4,Convex,CoordModeOrigin);
  }
 /* and the squares across the bottom */
  XFillPolygon(display,window[winno],color_gcs[9*numcolors/12],
	       wrecked((float)0,
		       (float)CY[winno]*.75,
		       (float)(CX[winno]/5),
		       (float)CY[winno]),
	       4,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[numcolors/12],
	       wrecked((float)(CX[winno]/5),
		       (float)CY[winno]*.75,
		       (float)(2*CX[winno]/5),
		       (float)CY[winno]),
	       4,Convex,CoordModeOrigin);
  XFillPolygon(display,window[winno],color_gcs[9*numcolors/12],
	       wrecked((float)(2*CX[winno]/5),
		       (float)CY[winno]*.75,
		       (float)(3*CX[winno]/5),
		       (float)CY[winno]),
	       4,Convex,CoordModeOrigin);
}

void boing(int winno)
{
  if (!rndm(50L)) 
    {
      X1[winno] = rndm(M[winno]) + 1;
      X2[winno] = rndm(M[winno]) + 1;
      X3[winno] = rndm(M[winno]) + 1;
      Y1[winno] = rndm(M[winno]);
      Y2[winno] = rndm(M[winno]);
      Y3[winno] = rndm(M[winno]);
    }
  
  if (!rndm(10L)) 
    {
      XV1[winno] = rndm(7L)-3;
      XV2[winno] = rndm(7L)-3;
      XV3[winno] = rndm(7L)-3;
      YV1[winno] = rndm(7L)-3;
      YV2[winno] = rndm(7L)-3;
      YV3[winno] = rndm(7L)-3;
      if (options.multi)
	HC[winno] = (HC[winno]+1)%numcolors;
      else
	HC[winno] = rndm((long)numcolors);
    }
  if (CX[winno]<CY[winno]) 
    {
      XA[winno] = (long)X1[winno]*(long)CX[winno]/(long)CY[winno];
      YA[winno] = (long)Y1[winno]*(long)CX[winno]/(long)CY[winno];
      XB[winno] = X1[winno];
      YB[winno] = Y1[winno];
      XC[winno] = (long)X2[winno]*(long)CX[winno]/(long)CY[winno];
      YC[winno] = (long)Y2[winno]*(long)CX[winno]/(long)CY[winno];
      XD[winno] = X2[winno];
      YD[winno] = Y2[winno];
      XE[winno] = (long)X3[winno]*(long)CX[winno]/(long)CY[winno];
      YE[winno] = (long)Y3[winno]*(long)CX[winno]/(long)CY[winno];
      XF[winno] = X3[winno];
      YF[winno] = Y3[winno];
    }
  else 
    {
      XA[winno] = X1[winno];
      YA[winno] = Y1[winno];
      XB[winno] = (long)X1[winno]*(long)CY[winno]/(long)CX[winno];
      YB[winno] = (long)Y1[winno]*(long)CY[winno]/(long)CX[winno];
      XC[winno] = X2[winno];
      YC[winno] = Y2[winno];
      XD[winno] = (long)X2[winno]*(long)CY[winno]/(long)CX[winno];
      YD[winno] = (long)Y2[winno]*(long)CY[winno]/(long)CX[winno];
      XE[winno] = X3[winno];
      YE[winno] = Y3[winno];
      XF[winno] = (long)X3[winno]*(long)CY[winno]/(long)CX[winno];
      YF[winno] = (long)Y3[winno]*(long)CY[winno]/(long)CX[winno];
    }
    
  X1[winno]= (X1[winno] + XV1[winno]) % M[winno];
  Y1[winno]= (Y1[winno] + YV1[winno]) % M[winno];
  X2[winno]= (X2[winno] + XV2[winno]) % M[winno];
  Y2[winno]= (Y2[winno] + YV2[winno]) % M[winno];
  X3[winno]= (X3[winno] + XV3[winno]) % M[winno];
  Y3[winno]= (Y3[winno] + YV3[winno]) % M[winno];
}
