/* 
 *  The Rules to Life, as explained to me by Duane Morin
 *   If a Dead cell has 3 neighbors, it becomes alive. Otherwise, it stays
 *      dead.
 *   If a alive cell has 2 or 3 neighbors, it stays alive.
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include "trippy.h"

static short** neighbors; /* 0 to 8 , plus an extra bit to tell status*/
static short** age;      /* 0 to numcolors */

#define ON 0x0010
static void findNeighbors(int,int,int);
static void kAA(int,int,int);
static int ENDOFPOND;

void
getALife(int winno)
{
  static int initd=0;
  int i,x,y;

  if(!initd)
    {
      age=(short **)calloc(options.windows,sizeof(short **));
      neighbors=(short **)calloc(options.windows,sizeof(short **));
      initd=1;
    }
    
  age[winno]=(short *)calloc(CX[winno]*CY[winno],sizeof(short));
  neighbors[winno]=(short *)calloc(CX[winno]*CY[winno],sizeof(short));
  
  for(x=0;x<CX[winno];x++)
  {
    for(y=0;y<CY[winno];y++)
      {
	if(rndm(100)<options.number)
	  {
	    neighbors[winno][y*CX[winno]+x]=ON;
	    XDrawPoint(display,window[winno],
		       color_gcs[age[winno][y*CX[winno]+x]=1], x,y);
	  }
    }
  }
}

void
drawLife(int winno)
{
  int x,y;

  for(y=0;y<CY[winno]+2;y++)
  {
    for(x=0;x<CX[winno];x++)
    {
      findNeighbors(x,y,winno);
/*      findNeighbors((x+100)%(CX[winno]),y); */
      if(y-2>0)      kAA(x,y-2,winno);
/*      if((x+98)%(CX[winno])>0) kAA((x+98)%(CX[winno]),y); */
    }
  }
}

void
findNeighbors(int x,int y, int winno)
{
  int foo,bar;
  if(x>=CX[winno]) return;
  if(neighbors[winno][y*CX[winno]+x]&ON)
  {
    for(bar=y-1;bar<=y+1;bar++)
      for(foo=x-1;foo<=x+1;foo++)
      {
	if( (foo<0) || (bar<0) || (foo>=CX[winno]) || (bar>=CY[winno]) ||
	   (foo==x&&bar==y)) 
	  continue;
	else
	{
	  neighbors[winno][bar*CX[winno]+foo]++; /* tell everyone around you
						    that they have a neighbor*/
	}	    
      }
  }
}

void
kAA(int x, int y, int winno) /* it's alive... it's dead... */
{ 
  int nov;
  if(((nov=neighbors[winno][y*CX[winno]+x]&0x000f)==3)||
     ((nov==2)&&(neighbors[winno][y*CX[winno]+x]&ON)))
  {
    neighbors[winno][y*CX[winno]+x]=ON;
    if(++age[winno][y*CX[winno]+x]>=numcolors)
      age[winno][y*CX[winno]+x]=1;

  }
  else
  {
    if(neighbors[winno][y*CX[winno]+x]==0) return; /* already dead,
						      don't bother */
    age[winno][y*CX[winno]+x]=0;
    neighbors[winno][y*CX[winno]+x]=0;
  }
  XDrawPoint(display,window[winno],color_gcs[age[winno][y*CX[winno]+x]],x,y);
}

