/*  
 *   Plasma Cloud and other Fractal Stuff
 *
 *  improvement in drawSpiral by Daniel Cabeza Gras
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include "trippy.h"

struct COMPLEX
{
  double real;
  double imag;
};

struct COMPLEX addComplex(struct COMPLEX,struct COMPLEX);
struct COMPLEX multComplex(struct COMPLEX,struct COMPLEX);
struct COMPLEX expComplex(struct COMPLEX);

/* Plasma code based on OOZE.C, written by Jeff Clough for the IBM/PCs */

void draw_grid(int,int,short,int,short*);
short adjust(int,int,int,int,int,int,int,short *); 
void subdiv (int,int,int,int,int,short *); 

extern XEvent event;
extern Visual *vis;

/* Generate a plasma cloud */
void draw_plasma(int winno)
{
  int x,y;
  short *grid; /* grid is a list of the colors */   
  
  /* Yow! This puppy could get HUGE */

  if ((grid = (short *)calloc((CX[winno]*CY[winno]),sizeof(short)))==NULL)
  {
    fprintf(stderr, "Can't Alloc enough memory for the plasma grid\n");
    exit(1);
  }

  /* make points at (0,0) (0,CY[winno]) (CX[winno],0) (CX[winno],CY[winno])
     of random colors */
  
  x=CX[winno]-1;
  y=CY[winno]-1;
  draw_grid(0,0,rndm(numcolors),winno,grid);
  draw_grid(x,0,rndm(numcolors),winno,grid);
  draw_grid(0,y,rndm(numcolors),winno,grid);
  draw_grid(x,y,rndm(numcolors),winno,grid);
  subdiv(0,0,x,y,winno,grid); 
  
  free(grid); 
}

void draw_grid(int x, int y, short colr, int winno,short *grid)
{
  XDrawPoint(display,window[winno],color_gcs[colr],x,y);
  grid[x+y*CX[winno]]=colr;
}

void subdiv(int x1,int y1, int x2, int y2, int winno,short *grid)
{
  int x,y;
  if (x2-x1<2 && y2-y1<2)
    return;
  
  x=(x1+x2)/2;
  y=(y1+y2)/2;
  adjust(x1,y1,x,y1,x2,y1,winno,grid);
  adjust(x2,y1,x2,y,x2,y2,winno,grid);
  adjust(x1,y2,x,y2,x2,y2,winno,grid);
  adjust(x1,y1,x1,y,x1,y2,winno,grid);
  if((grid[x+y*CX[winno]]==0)||(options.mono)) 
    {
      short spooge;
      if (options.trell)
	spooge=(grid[x1+y1*CX[winno]]+grid[x1+y2*CX[winno]]+
		grid[x2+y1*CX[winno]]+grid[x2+y2*CX[winno]])%numcolors; 
      else
	spooge=(grid[x1+y1*CX[winno]]+grid[x1+y2*CX[winno]]+
		grid[x2+y1*CX[winno]]+grid[x2+y2*CX[winno]])/4; 
      draw_grid(x,y,spooge,winno,grid);
    }
  subdiv(x1,y1,x,y,winno,grid);
  subdiv(x,y1,x2,y,winno,grid);
  subdiv(x1,y,x,y2,winno,grid);
  subdiv(x,y,x2,y2,winno,grid);
}

short adjust(int x1, int y1, int x, int y, int x2, int y2,
	     int winno,short *grid)
{
  short c;
  int d;
  int spoo;
  short clr1,clr2,clr3,clr4;
  long horz,vert;
  if(!options.mono)
    if (grid[x+y*CX[winno]]!=0)
      return grid[x+y*CX[winno]];
  clr1=grid[x1+y1*CX[winno]];
  clr2=grid[x2+y2*CX[winno]];
  clr3=grid[x1+y2*CX[winno]];
  clr4=grid[x2+y1*CX[winno]];
  horz=x2-x1;
  vert=y2-y1;
  d=hypot(horz,vert);
/*sqrt(horz*horz+vert*vert);*/
/* leave the next 8 lines commented out for mellow colors...*/
  if((spoo=rndm(100))>options.number)
    {
      if(spoo%2==1)
	c=(((clr1+clr2)/2)+rndm(d))%numcolors;
      else
	c=(((clr1+clr2)/2)-rndm(d))%numcolors;
    }
  else 

    c=((clr1+clr2+clr3+clr4)/4); /* %numcolors; */
  if(c<0)
    c=abs(c);
  else if(c==0)
    c=1;
  draw_grid(x,y,c,winno,grid);
  return c;
}

XPoint PolartoRect(float radius, float angle)
{
  XPoint temp;
  
  temp.x=(int) (radius*cos(angle));
  temp.y=(int) (radius*sin(angle));
  
  return temp;
}

double RecttoPolar(int x,int y)
{
  return (atan2(y,x));
}

void draw_rose(int n,int winno)
{
  XPoint plotme;
  float r;
  int i;
  static int size;
  static int *X1,*Y1;
  static int inited=0;
  static float ang=0.0;
  static int clr=1;
  static int spodge=1;

  if(!inited)
    {
      X1=(int *)calloc(options.number,sizeof(int));
      Y1=(int *)calloc(options.number,sizeof(int));
      size=min(CY[winno],CX[winno])>>1;
      HC[0]=rndm(numcolors)+1;
      inited=1;
    }

  r = sin(n*ang)*size; 
  plotme = PolartoRect(r,ang);
  ang=ang+(float)(M_PI/(n*size));
  if (ang>2*M_PI)
    ang-=2*M_PI;
  
  if(options.multi)
    clr=1;
  else
    clr=0;
  
  X1[0]= plotme.x;
  Y1[0]= plotme.y;
  HC[0]= (HC[0]+clr)%numcolors;
  
  for(i=options.number;i>0;i--)
    {
      X1[i]=X1[i-1];
      Y1[i]=Y1[i-1];
      HC[i]=HC[i-1];
    }
  XDrawPoint(display,window[winno],color_gcs[HC[0]],X1[0]+(CX[winno]/2),
	     Y1[0]+(CY[winno]/2)); 
/*
  XDrawPoint(display,window[winno],color_gcs[0],
	     X1[options.number]+(CX[winno]/2),
	     Y1[options.number]+(CY[winno]/2)); 
*/
}

void draw_spiral(int winno)
{      

/* A spiral has the formula rad=ang */ 

  XPoint plotme;
  float ang=0.0;
  short clr=rndm(numcolors-1);
  double theend= hypot(((double)CX[winno]),((double)CY[winno]));
  do
    {
      plotme=PolartoRect(ang/3,ang);
      ang+=(float)M_PI/737;
      if((abs(plotme.x)<(CX[winno]/2))&&(abs(plotme.y)<(CY[winno]/2)))
	XDrawPoint(display,window[winno],color_gcs[clr],
		   plotme.x+(CX[winno]/2),plotme.y+(CY[winno]/2)); 
      
      clr--;
      if(clr<=0)
	clr=numcolors-1;

    } while((2*ang/3) < theend);
} 

void
draw_mandel(int l,int t,int r, int b, int winno )
{
  /* do funky shit with complex numbers */
  int x,y,i;
  double left,right,top,bottom;
  struct COMPLEX C;
  struct COMPLEX Z;
  
  top=(double)t/(CY[winno]*.5)-1.25;
  bottom=(double)b/(CY[winno]*.5)-.75;
  left=(double)l/(CX[winno]*.5)-1.875;
  right=(double)r/(CX[winno]*.5)-1.375;
  printf("Drawing Mandel from (%lf,%lf) to (%lf,%lf)\n",
	 ((right-left)*0/CX[winno])+left,
	 ((bottom-top)*0/CY[winno])+top,
	 ((right-left)*CX[winno]/CX[winno])+left,
	 ((bottom-top)*CY[winno]/CY[winno])+top);

  for(y=0;y<CY[winno];y++)
    {
      if (XCheckMaskEvent(display,~0L,&event)==True) 
	handle_event(&event); /* check for kills every so often */
      for(x=0;x<CX[winno];x++)
	{
	  C.real=(double)((right-left)*x/CX[winno])+left;
	  C.imag=(double)((bottom-top)*y/CY[winno])+top;
	  Z.real=C.real;
	  Z.imag=C.imag;	  
	  for (i=1;i<(options.number*10);i++)       
	    {
	      Z=multComplex(Z,Z);
	      Z=addComplex(Z,C);
	      if((Z.real*Z.real)+(Z.imag*Z.imag)>4.0)
		break;
	    }
	  XDrawPoint(display,window[winno],
		     color_gcs[(i%numcolors)?(i%numcolors):1],x,y); 
      }
    }
}

/* julia.. the fractal set, not the person */
void
draw_julia(int winno)
{
  /* do funky shit with complex numbers */
  int x,y,i;
  struct COMPLEX C;
  struct COMPLEX Z;
  for(y=0;y<CY[winno];y++)
    {
      if (XCheckMaskEvent(display,~0L,&event)==True) 
	handle_event(&event);
      for(x=0;x<CX[winno];x++)
	{
	  Z.real=(double)(-(CX[winno]/2)+x)/(double)(CX[winno]/2.5);
	  Z.imag=(double)(-(CX[winno]/2)+y)/(double)(CY[winno]/2.5);
	  C.real =0.3;
	  C.imag =0.6;
	  /* F(z)=z^2+c */
	  for (i=0;i<(options.number*10);i++)
	    {
	      Z=multComplex(Z,Z);
	      Z=addComplex(Z,C);
	      if((Z.real*Z.real)+(Z.imag*Z.imag)>4.0)
		break;
	    }
	  XDrawPoint(display,window[winno],color_gcs[(i%numcolors)+1],x,y); 
	}
    }
}

/* newton.. the fractal set, not the person */
void
draw_newton(int winno)
{
  /* do funky shit with complex numbers */
  int x,y,i;
  struct COMPLEX C;
  struct COMPLEX Z;
  for(y=0;y<CY[winno];y++)
    {
      if (XCheckMaskEvent(display,~0L,&event)==True) 
	handle_event(&event);
      for(x=0;x<CX[winno];x++)
	{
	  Z.real=(double)(-(CX[winno]/2)+x)/(double)(CX[winno]/2.5);
	  Z.imag=(double)(-(CX[winno]/2)+y)/(double)(CY[winno]/2.5);  
/*	   	Z.real=(double)(-(CX[winno]/2)+x);  */
/*	  	Z.imag=(double)(-(CX[winno]/2)+y);  */
	
	  C.real =-1.0;
	  C.imag =0.0;
	  
	  /* z -1 - exp(-z) */
	  for (i=0;i<(options.number*10);i++)
	    {
	      /*	    Z=multComplex(Z,Z); */
	      struct COMPLEX minus1=     {-1.0,-1.0};
	      struct COMPLEX temp=multComplex(Z,minus1);
	      Z=addComplex(Z,C);
	      Z=addComplex(Z,multComplex((expComplex(temp)),minus1));
	      
	      if((Z.real*Z.real)+(Z.imag*Z.imag)>16.0)
		{
		/*  printf("Breaking out "); */
		  break;
		}
/*	      fprintf(stderr,"Iter[%d] Z.real = %lf \t Z.imag= %lf\n",
		      i,Z.real,Z.imag);
*/
	    }
	  XDrawPoint(display,window[winno],color_gcs[(i%numcolors)+1],x,y); 
	}
    }
}

/* from the sci.fractals FAQ 
Q9a: How does complex arithmetic work?
A9a: It works mostly like regular algebra with a couple additional formulas:
(note: a,b are reals, x,y are complex, i is the square root of -1)
Powers of i: i^2 = -1
Addition: (a+i*b)+(c+i*d) = (a+c)+i*(b+d)
Multiplication: (a+i*b)*(c+i*d) = a*c-b*d + i*(a*d+b*c)
Division: (a+i*b)/(c+i*d) = (a+i*b)*(c-i*d)/(c^2+d^2)
Exponentiation: exp(a+i*b) = exp(a)(cos(b)+i*sin(b))
Sine: sin(x) = (exp(i*x)-exp(-i*x))/(2*i)
Cosine: cos(x) = (exp(i*x)+exp(-i*x)/2
Magnitude: |a+i*b| = sqrt(a^2+b^2)
Log: log(a+i*b) = log(|a+i*b|)+i*arctan(b/a)  (Note: log is multivalued.)
Complex powers: x^y = exp(y*log(x))
DeMoivre's theorem: x^a = r^a * [cos(a*theta) + i * sin(a*theta)]
*/

struct COMPLEX expComplex(struct COMPLEX foo)
{
  struct COMPLEX temp;
  temp.real = exp(foo.real)*(cos(foo.imag));
  temp.imag = exp(foo.real)*sin(foo.imag);
  return temp;
}

struct COMPLEX addComplex(struct COMPLEX foo, struct COMPLEX bar)
{
  struct COMPLEX temp;
  temp.real = foo.real + bar.real;
  temp.imag = foo.imag + bar.imag;
  return temp;
}

struct COMPLEX multComplex(struct COMPLEX foo ,struct COMPLEX bar)
{
  struct COMPLEX temp;
  temp.real = (foo.real * bar.real) - (foo.imag * bar.imag);
  temp.imag = (foo.imag * bar.real) + (foo.real * bar.imag);
  return temp;
}

void wander(int *x, int *y,int winno)
{
  int spoo;
  
  XDrawPoint(display,window[winno],color_gcs[HC[winno]],*x,*y);
  if((spoo=rndm(3))==1)
    *x+=1;
  else if (spoo==2)
    *x-=1;
  if((spoo=rndm(3))==1)
    *y+=1;
  else if (spoo==2)
    *y-=1;
  if (*x<=0)
    *x=CX[winno];
  else if (*x>=CX[winno])
    *x=0;
  if (*y<=0)
    *y=CY[winno];
  else if (*y>=CY[winno])
    *y=0;
}

void
draw_funky(int winno)
{
  XPoint plotme,plotme2;
  float ang=0.0;
  float length=(M[winno]*1.4)/2;
  short clr=rndm(numcolors-1);
  int howfunky=options.number;
  while(length>0.0)
    {
      plotme=PolartoRect(length,ang);

      if(howfunky==1)
	{
	  XPoint eris[5];
	  plotme2=PolartoRect(length,ang+M_PI_2);
	  eris[0].x=eris[4].x=plotme.x+(CX[winno]/2);
	  eris[0].y=eris[4].y=plotme.y+(CY[winno]/2);
	  eris[1].x=plotme2.x+(CX[winno]/2);
	  eris[1].y=plotme2.y+(CY[winno]/2);
	  eris[2].x=(CX[winno]/2)-plotme.x;
	  eris[2].y=(CY[winno]/2)-plotme.y;
	  eris[3].x=(CX[winno]/2)-plotme2.x;
	  eris[3].y=(CY[winno]/2)-plotme2.y;
	  XDrawLines(display,window[winno],color_gcs[clr],eris,5,
		     CoordModeOrigin);
	  length-=.5;
	}
      else if(howfunky==2)
	{
	  XPoint plotme3;
	  XPoint eris[4];
	  plotme2 = PolartoRect(length,ang+(.66667*M_PI));
	  plotme3 = PolartoRect(length,ang+(1.3333*M_PI));
	  eris[0].x=eris[3].x=plotme.x+(CX[winno]>>1);
	  eris[0].y=eris[3].y=plotme.y+(CY[winno]>>1);
	  eris[1].x=plotme2.x+(CX[winno]>>1);
	  eris[1].y=plotme2.y+(CY[winno]>>1);
	  eris[2].x=plotme3.x+(CX[winno]>>1);
	  eris[2].y=plotme3.y+(CY[winno]>>1);
	  XDrawLines(display,window[winno],color_gcs[clr],eris,4,
		     CoordModeOrigin);
	  length-=.3;
	}
      else
	{
	  XDrawLine(display,window[winno],color_gcs[clr],
		    plotme.x+(CX[winno]/2),plotme.y+(CY[winno]/2),
		    (CX[winno]/2)-plotme.x,(CY[winno]/2)-plotme.y); 
	  length-=.01;
	}
      ang+=(float)M_PI/737;
      clr--;
      if(clr<=0)
	clr=numcolors-1;
    }
}


void
draw_ripple(int winno)
{
  int clr;
  int x2,y2,a,b;
  XGCValues gcval;

  for(clr=1;clr<numcolors;clr++)
    XDrawLines(display,window[winno],color_gcs[clr],
	       make_circle(CX[winno]>>1,CY[winno]>>1,
			   (CX[winno]>>1)+clr,(CY[winno]>>1)+clr),
	       33,CoordModeOrigin);
  x2=rndm(100)-50;
  y2=rndm(100)-50;
  for(clr=1;clr<numcolors;clr++)
    {
      if(clr%2)
	{
	  a=1;
	  b=0;
	}
      else
	{
	  a=0;
	  b=1;
	}
      gcval.function=GXxor;
      XChangeGC(display,color_gcs[clr],GCFunction,&gcval);
      XDrawLines(display,window[winno],color_gcs[clr],
		 make_circle(x2+CX[winno]>>1,y2+CY[winno]>>1,
			     (CX[winno]>>1)+x2+(a*clr),
			     (CY[winno]>>1)+y2+(b*clr)),
		 33,CoordModeOrigin);
    }  
}

void
draw_static(int winno)
{
  int x,y;
  for(y=0;y<CY[winno];y++)
    for(x=0;x<CX[winno];x++)
      XDrawPoint(display,window[winno],color_gcs[rndm(numcolors-1)+1],x,y);
}

void
draw_max(int winno)
{
/* Point 0 is the center of the screen, initially */
/* Point 1-3 are the 3 points of the cube */
  static XPoint **pts;
  static int initd=0;
  static unsigned int *length;
  
  if(!initd)
    {
      int i;
      
      pts=(XPoint **)malloc(options.windows*sizeof(XPoint*));
      length=(unsigned int *)malloc(options.windows*sizeof(unsigned int));
      for(i=0;i<options.windows;i++)
	{
	  double ang;
	  pts[i]=(XPoint *)calloc(4,sizeof(XPoint));
	  pts[i][0].x=CX[i]>>1;
	  pts[i][0].y=CY[i]>>1;
	  pts[i][1].x=CX[i];
	  pts[i][1].y=CY[i];
	  length[i]=hypot(pts[i][1].x-pts[i][0].x,
			  pts[i][1].y-pts[i][0].y);
	  ang=atan2(pts[i][1].y-pts[i][0].y, pts[i][1].x-pts[i][0].x);
	  pts[i][2]=PolartoRect(length[i],ang+M_PI*.6667); /* PI*2/3 */
	  pts[i][3]=PolartoRect(length[i],ang+M_PI*1.3333); /* PI*4/3 */
	}
      initd=1;
    }
  
  XDrawLine(display,window[winno],color_gcs[1],
	    pts[winno][0].x, pts[winno][0].y,
	    pts[winno][1].x, pts[winno][1].y);
  
  XDrawLine(display,window[winno],color_gcs[50],
	    pts[winno][0].x, pts[winno][0].y,
	    pts[winno][2].x, pts[winno][2].y);
  
  XDrawLine(display,window[winno],color_gcs[100],
	    pts[winno][0].x, pts[winno][0].y,
	    pts[winno][3].x, pts[winno][3].y);
}
