
/*
**  XTacy (X11 Version)                     -><- HAIL ERIS!
**                                   
**  Original EGA/VGA version (for IBM PCs and compatibles) by:
**    Judson D. McClendon
**    Sun Valley Systems
**    329 37th Court N.E.
**    Birmingham, AL 35215
**    Compuserve: [74415,1003]
**
**  Ported to X11 by Nathan Meyers, nathanm@hp-pcd.hp.com.
**
**  Pretty Shapes and Colors, Boxes, Bozogons, Qixes (Qices?), wandering
**  modern art , plasma clouds, Gravity Wells, and...ummm...
**   whatever else I added,
**  added by Jeremy Johnson, mpython@gnu.ai.mit.edu
**
**  thanks to Matt Cross (profesor@wpi), for the Tunnel code 
**
**  
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <setjmp.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <signal.h>
#include <math.h>
#include "vroot.h"  /* for the complete virtual rootwin experience */
#include "trippy.h" /* all the global vars */

#define VERSION "1.12"

static int *jj;
static int startup=0;
static int dropachicken=0;
extern struct particle **partlst;
static int l,r,t,b;
void MakeWindow(int,char **);
void maybe_unlock();
void handle_event(XEvent*);
void MakePerfectWindow(int,char **);
int initstuff(int);
void refreshrootquit();
void fatalerror(char *, char *);
XWindowAttributes win_att;
XSetWindowAttributes s_win_att;
XEvent event;
Visual *vis;
char *password;
static struct timeval *schedule, *intervals; 

main(int argc,char **argv)
{
  int i,j;
  char **o_argv;
  int o_argc;
  
/***** set up the structure *****/
  options.bwidth=2;
  options.number=0;
  options.delayvalue= (-1);
  options.doroot=0;
  options.annoy_tefler = 1; /* Annoy him by Default */
  options.noclear=0;
  options.mono=0;
  options.trell=0;
  options.norect=0;
  options.multi=0;
  options.dynamic_colors=0;
  options.totalrand=0;
  options.mode=kaleid;
  options.tryfor=NCOLORS;
  options.displayname = NULL;
  options.geomstring = NULL;
  options.windows=1;
  options.rillybig=0;
  options.palette=0; /* original */
  options.numparts=0;
  
  o_argc = argc;
  o_argv = argv;
  progname = argv[0];
  
/* go thru the command line arguments, and set the options structure 
   accordingly
 */
  parse_options(o_argc, o_argv);

  if (options.delayvalue == -1)
    options.delayvalue = options.doroot ? 100 : 10;
  
  if ((display=XOpenDisplay(options.displayname))==NULL) 
  {
    fprintf(stderr,
	    (options.displayname==NULL) ?
	    "%s: Failed to open display.\n" :
	    "%s: Failed to open display %s.\n",
	    progname,options.displayname);
    exit(1);
  }
  screen = DefaultScreen(display);

  if (options.lock)
    {
      char *fob;
      fob=(char *)getpass("Enter a key:\0");
      password=(char *)malloc(16*sizeof(char));
      strcpy(password,fob);
      fob=(char *)getpass("Again:\0");
      if(strcmp(fob,password))
	{
	  fprintf(stderr,"NOPE! NOT GONNA LOCK! \n");
	  options.lock=0;
	}
      else
	{
	  fprintf(stderr,"Right-O! Locking your station\n");
	  /* for locking, we pretend that the user is running ' -rillybig '
	     and not in the root
	   */
	  options.rillybig=1;
	  options.doroot=0;
	  options.geomstring=(char *)malloc(10*sizeof(char));
	  sprintf(options.geomstring,"%dx%d",DisplayWidth(display,screen)
		  ,DisplayHeight(display,screen));
	  options.windows=1;
	  options.annoy_tefler=0; /* don't do the shrinking window thing */
	}
    }

  vis=DefaultVisual(display,screen);
  
  if(!vis->class) /* If vis->class = 0, it's a Static Grey display */
    { 
      fprintf(stderr,"Phwee-Hoo.. No Colors, No XTacy\n");
      exit(1); 
      options.mono=1;
      options.tryfor=2;
      if(options.mode==off)
	{
	  fprintf(stderr,"Sorry, 'off' won't work on a monochrome. Dropping you to default\n");
	  options.mode=kaleid;
	}
    }
  
  srandom(getpid());
 
  if ((schedule=(struct timeval *)calloc(1,sizeof(struct timeval))) == NULL)
    return ;
  if ((intervals=(struct timeval *)calloc(1,sizeof(struct timeval))) == NULL)
    return ;
   
  if (options.doroot) 
    {
      if(options.rillybig) /* make one Whopping Huge Window */
	{
	  window=(Window *)malloc(1*sizeof(Window));
	  window[0]=RootWindow(display,screen);
	  nwindows=1;
	  options.windows=1;
	  XSetWindowBackground(display,window[0],options.bgcolor);
	  XClearWindow(display,window[0]);
	  XSelectInput(display,window[0],0);
	  XSync(display,0);
/*	  fprintf(stderr,"Window[0]=%lx\n ",window[0]); */
	  CX=(int *)calloc(nwindows,sizeof(int));
	  CY=(int *)calloc(nwindows,sizeof(int));
	}
      else /* make lotsa little sub-root-windows */
	{
	  Window wdontcare;
	  int dontcare;
	  char *basename, *strrchr();
	  unsigned long   vmask;
	  XSetWindowAttributes    xswat;
	  XSizeHints size_hints;
	  int foo,bar,i,x,y;
	  int sCY,sCX;
      
	  window=(Window *)malloc(1*sizeof(Window));
	  window[0]=RootWindow(display,screen);  
	  XGetGeometry(display,window[0],&wdontcare,
		       &dontcare,&dontcare, &sCX, &sCY, &dontcare, &dontcare);
	  foo=DisplayWidth(display,screen);
	  bar=DisplayHeight(display,screen);
      
/*
     fprintf(stderr,"SuperRoot CX=%d\t SuperRoot CY=%d\n",sCX,sCY);
     fprintf(stderr,"Max visible (%dx%d)... so we can make %d windows\n",
     foo=DisplayWidth(display,screen),
     bar=DisplayHeight(display,screen),
     (sCX/foo)*(sCY/bar));
*/
	  nwindows=((sCX/foo)*(sCY/bar));
	  
	  /*      printf("SuperRootWin:%lx\n",window); */
	  
	  free(window);			/* in every box of Corn Flakes */
	  window=(Window *)malloc(sizeof(Window)*nwindows);
	  CX=(int *)calloc(nwindows,sizeof(int));
	  CY=(int *)calloc(nwindows,sizeof(int));
	  options.windows=nwindows;
	  i=0;
	  for(x=0;x<(sCX/foo);x++)
	    for(y=0;y<(sCY/bar);y++)
	      {
		if ((basename=strrchr(progname,'/'))!=NULL) 
		  basename++;
		else 
		  basename=progname;
		size_hints.flags = PPosition | PSize;
		size_hints.x=DisplayWidth(display,screen);
		size_hints.y=DisplayHeight(display,screen);
		
		xswat.override_redirect = True; 
		vmask = CWOverrideRedirect;
/*
   fprintf(stderr,"Making a new window at %dx%d. (%d,%d)\t",x*foo,
   y*bar, x*foo+foo, y*bar+bar);
 */
		window[i] = XCreateWindow(display, RootWindow(display, screen),
					  x*foo, y*bar, foo, bar, 0,
					  CopyFromParent, CopyFromParent, vis,
					  vmask, &xswat);
		/*
		   fprintf(stderr,"Made #%d\n",i);
		   */    
		XSetStandardProperties(display,window[i],"XTacy",basename,
				       None,o_argv,o_argc,&size_hints);
		XSelectInput(display,window[i],0);
		XLowerWindow(display,window[i]); /* shove the new window
						    down to the bottom */
		
		/*      window=RootWindow(display,screen);  */
		XSync(display,0);
		XMapWindow(display,window[i]);
		XGetGeometry(display,window[i],&wdontcare, &dontcare,&dontcare,
			     &CX[i], &CY[i], &dontcare, &dontcare);
      /*
	 fprintf(stderr,"Root CX=%d\t Root CY=%d\n",CX[i],CY[i]);
	 printf("RootWin:%lx\n",window[i]);
	 */
		i++;
	      }
	}
  }    
  else if (options.perfect) /* make a window with 'perfect' colors...
			       grabs the colormap away from everything else */
    {
      window=(Window *)malloc(sizeof(Window)*options.windows);
      MakePerfectWindow(o_argc,o_argv);
      nwindows=options.windows;
    }
  else if(options.lock)
    {
      int bCX,bCY,sCX,sCY,dontcare;
      Window wdontcare;
      char *basename;
      XSetWindowAttributes    xswat;
      int vmask = CWOverrideRedirect;
      XSizeHints size_hints;
      size_hints.flags = PPosition | PSize;
      size_hints.x=DisplayWidth(display,screen);
      size_hints.y=DisplayHeight(display,screen);
      xswat.override_redirect = True; 
      if ((basename=strrchr(progname,'/'))!=NULL) 
	basename++;
      else 
	basename=progname;
      window=(Window *)malloc(sizeof(Window)*1);
      XParseGeometry(options.geomstring,&bCX, &bCY,&sCX, &sCY);
      window[0] = XCreateWindow(display, RootWindow(display, screen),
				bCX, bCY, sCX , sCY, 0,
				CopyFromParent, CopyFromParent, vis,
				vmask, &xswat);
      XSetStandardProperties(display,window[0],"XTacy",basename,
			     None,o_argv,o_argc,&size_hints);
      XSelectInput(display,window[0],ButtonPressMask|KeyPressMask);
      XRaiseWindow(display,window[0]); /* shove the new window
					  up to the top */
      XSync(display,0);
      XMapWindow(display,window[0]);
      CX=(int *)calloc(1,sizeof(int));
      CY=(int *)calloc(1,sizeof(int));
      XGetGeometry(display,window[0],&wdontcare, &dontcare,&dontcare,
		   &CX[0], &CY[0], &dontcare, &dontcare);
    }
  else
    {
      window=(Window *)malloc(sizeof(Window)*options.windows);
      MakeWindow(o_argc,o_argv);
      nwindows=options.windows;
    }
  
  if(options.lock)
    {
      /* grab everything , keyboard, mouse, etc.*/
      XGrabKeyboard(display,window[0],False,
		    GrabModeAsync,GrabModeAsync,CurrentTime);
      XGrabPointer(display,window[0],False,
		   (ButtonPressMask|KeyPressMask|KeyReleaseMask),
		   GrabModeAsync,GrabModeAsync,window[0],None,CurrentTime);
    }
  
  initstuff(options.windows);
  initTables();
  
/*  fprintf(stderr,"Init'd %d gobs of stuff\n",options.windows); */
  
  XGetWindowAttributes(display,window[0],&win_att);

  options.bdcolor = StrColor(options.border,WhitePixel(display,screen));
  options.bgcolor = StrColor(options.background,
			     BlackPixel(display,screen));
  
  for(i=0;i<options.windows;i++)
    {
      if(options.perfect)
	{
	  colmap = XCreateColormap(display,window[i],vis,AllocNone);
	  s_win_att.colormap=colmap;
	  XChangeWindowAttributes(display,window[i],CWColormap,&s_win_att);
	}
      else
	colmap= win_att.colormap; 

      XSetWindowBackground(display,window[i],options.bgcolor);
      XSetWindowBorder(display,window[i],options.bdcolor);
      XClearWindow(display,window[i]);

      if (options.mode==clover||options.mode==wandering||options.mode==plasma||
	  options.mode==spiral||options.mode==mandel   ||options.mode==julia ||
	  options.mode==tunnel||options.mode==gravity  ||options.mode==newton||
	  options.mode==test  ||options.mode==off      ||options.mode==funky ||
	  options.mode==xstatic)
	{
	  s_win_att.backing_store=Always;
	  XChangeWindowAttributes(display,window[i],CWBackingStore,&s_win_att);
	}
      
      if(options.lock)
	{
	  s_win_att.override_redirect=True;
	  XChangeWindowAttributes(display,window[i],CWOverrideRedirect,
				  &s_win_att);
	}
      
      intervals[i].tv_sec = options.delayvalue/1000;
      intervals[i].tv_usec = (options.delayvalue % 1000) * 1000;
      visible[i]=1;
      nvisible++;
    }
  
  get_them_colors(); /* allocate colors */
    
  for (;;)  
    { 
      int count;
      yesno rect;
      int winno=0;
      int dontcare;
      Window wdontcare;
      int x,y;
      
      if(options.totalrand)
	{
	  options.mode=rndm(13);
	  options.number=rndm(100);
	}
      
      if (options.doroot)
	{
	  struct sigvec 
	    {
	      void    (*sv_handler)();       /* signal handler */
	      int     sv_mask;               /* signal mask to apply */
	      int     sv_flags;              /* see signal options below */
	    } vec;
	  
	  vec.sv_handler = refreshrootquit;
	  vec.sv_mask = 0x0;
	  vec.sv_flags = 0;
	  (void)sigvec(SIGINT,  &vec, (struct sigvec *)NULL);
	  (void)sigvec(SIGQUIT, &vec, (struct sigvec *)NULL);
	  (void)sigvec(SIGTERM, &vec, (struct sigvec *)NULL);
	}
env:
      for(winno=0;winno<options.windows;winno++)
	{
/* set up the min/max for the windows */
	  XGetGeometry(display,window[winno],&wdontcare,
		       &dontcare,&dontcare, &CX[winno], &CY[winno], 
		       &dontcare, &dontcare);
	  if(options.mode==kaleid)
	    {
	      CX[winno]>>=1;
	      CY[winno]>>=1;
	    }
	  M[winno] = max(CX[winno],CY[winno]);
	  M[winno] = M[winno] ? M[winno] : 1;
	  l=0; t=0;
	  r=CX[winno]; b=CY[winno];
	}
      winno=0;
      
      if(options.mode==boxes||options.mode==bozo||options.mode==circ||
	 options.mode==qix||options.mode==qix4)
	/* init the boxes */
	{ 
	  int i;
	  for(i=0;i<options.windows;i++)
	    init_boxes(i);
	}
      else if(options.mode==kaleid)
	{
	  register int i;
	  init_kaleid(options.windows);
	  for(i=0;i<options.windows;i++)
	    randomize_kal(i);
	  rect=no;
	}
      else if(options.mode==gravity)
	{
	  for(i=0;i<options.windows;i++)
	    init_gravity(i);
	}
      else if(options.mode==life)
	{
	  for(i=0;i<options.windows;i++)
	    getALife(i);
	}
      else if(options.mode==wandering)
	{
	  for(i=0;i<options.windows;i++)
	    {
	      /* init the wandering stuff*/
	      x=rndm(CX[i]);
	      y=rndm(CY[i]);
	      HC[i]=rndm(numcolors);
	    }
	}

/*      printf("Window=%lx\n",window); */
      
      while (nvisible) 
	{ 
/*	  fprintf(stderr,"Drawing Window[%d]\n",winno); */
	  switch(options.mode)
	    {
	    case kaleid:
	      {
		draw_kaleid(&rect,winno);
		break;
	      }
	    case test:
	      {
		if (jj[winno]==0)
		  {
		    draw_test(winno);
		    jj[winno]=1;
		  }
		break;
	      }
	    case off:
	      {
		if (jj[winno]==0)
		{
		  draw_off(winno);
		  jj[winno]=1;
		}
		break;
	      }
	    case maxh:
	      {
		draw_max(winno);
		break;
	      }
	    case wandering:
	      {
		wander(&x,&y,winno);
		break;
	      }
	    case rose:
	      {
		if (jj[winno]==0)
		  jj[winno]=rndm(10)+2;
		draw_rose(jj[winno],winno);
		break;
	      }
	    case life:
	      {
		drawLife(winno);
		break;
	      }
	    case gravity:
	      {
		draw_gravity(winno);
		break;
	      }
	    case spheres:
	      {
		draw_sphere(winno);
		break;
	      }
/* these are the palette shifty ones */
	    case clover:
	    case tunnel:
	    case mandel:
	    case julia:
	    case plasma:
	    case funky:
	    case spiral:
	    case newton:
	    case ripple:
	    case xstatic:
	      {	      
		if(jj[winno])
		  {
		    rotate_colors();
		    startup=0;
		  }
		else
		  {
		    switch (options.mode)
		      {
		      case clover:
			{
			  draw_clover(winno);
			  jj[winno]=1;		  
			  startup=1;
			  break;
			}
		      case tunnel:
			{
			  draw_tunnel(winno);
			  jj[winno]=1;		  
			  startup=1;
			  break;
			}
		      case xstatic:
			{
			  draw_static(winno);
			  jj[winno]=1;
			  startup=1;
			  break;
			}
		      case mandel:
			{
			  draw_mandel(l,t,r,b,winno);
			  jj[winno]=1;
			  startup=1;
			  break;
			}
		      case julia:
			{
			  draw_julia(winno);
			  jj[winno]=1;
			  startup=1;
			  break;
			}
		      case funky:
			{
			  draw_funky(winno);
			  jj[winno]=1;
			  break;
			}
		      case ripple:
			{
			  draw_ripple(winno);
			  jj[winno]=1;
			  break;
			}
		      case plasma:
			{
			  draw_plasma(winno);
			  startup=1;		  
			  jj[winno]=1;
			  break;
			}
		      case spiral:
			{
			  draw_spiral(winno);
			  startup=1;		  
			  jj[winno]=1;
			  break;
			}
		      case newton:
			{
			  draw_newton(winno);
			  startup=1;
			  jj[winno]=1;
			  break;
			}
		      }
		  }
		break;
	      }
/* these are the bouncy ones */
	    case bozo:
	    case circ:
	    case qix:
	    case qix4:
	    case boxes:
	      { 
		move_boxes(winno);
		
		switch(options.mode)
		  {
		  case bozo:
		    {
		      draw_bozo(winno);
		      break;
		    }
		  case circ:
		    {
		      draw_circ(winno);
		      break;
		    }
		  case qix:
		    {
		      draw_qix(winno); break;
		    }
		  case qix4:
		    {
		      draw_qix4(winno); break;
		    }
		  case boxes:
		    {
		      draw_boxes(winno); break;
		    }
		  }
		bounce(winno);
		break;
	      }
	    }

	  XFlush(display);
	  if(options.mode==kaleid||options.mode==test)
	    {
	      if (!rndm(500L)&&!(options.doroot)&&(options.mode!=test)) 
		XClearWindow(display,window[winno]);
	      if (options.dynamic_colors && !rndm((long)(800/numcolors)))
		randomize_color();
	    }
	  else
	    {
	      if (!options.mono) 
		{
		  if(!options.multi && !rndm(500L))
		    HC[winno]=rndm(numcolors);
		  if(options.multi && (options.mode==wandering))
		    HC[winno]=(HC[winno]+1)%numcolors;
		}
	    }
	    winno=scheduler();
	  /* gravity needs no delays */ 
	  /*  Turn this on for no delays at all 
	   ** 	  winno=0; 
	   */

/* if any event is waiting, go try to handle it */
	  if (XCheckMaskEvent(display,~0L,&event)==True) 
	    handle_event(&event);
	  if(dropachicken&&!options.totalrand)
	  {
	    dropachicken=0;
	    goto env;
          }
	  if(options.totalrand&&(rndm(10000L)==2317)||dropachicken)
	    {
	      options.mode=rndm(13);
	      options.dynamic_colors=rndm(1);
	      dropachicken=0;
	      goto env;
	    }
	}
      XNextEvent(display,&event);
      handle_event(&event);
    }
}

void
handle_event(XEvent *event)
{
  int i;
  static int pressed=0;
  
  if(event->type<2)
    printf("Funky Event Type: %d\n",event->type);
  else if (event->type==ConfigureNotify)
    {
      if (!startup)
	{
	  for(i=0;i<options.windows;i++)
	    {
	      if (event->xconfigure.window==window[i]) 
		{
		  if (CX[i] != event->xconfigure.width ||
		      CY[i] != event->xconfigure.height )
		    {
		      XClearWindow(display,event->xconfigure.window);
		      CX[i] = event->xconfigure.width; 
		      CY[i] = event->xconfigure.height;
		      if ((options.mode==kaleid)&&(!options.doroot))
			{
			  CX[i]>>=1;
			  CY[i]>>=1;
			}
		      M[i] = max(CY[i],CX[i]);
		      M[i] = M[i] ? M[i] : 1;
		      jj[i]=0;
		    }
/*		  else
		    jj[i]=1;
*/
		}
	    }
	}
    }
  else if (event->type==MapNotify) 
    {
      if(options.mode==kaleid)
	for(i=0;i<options.windows;i++)
	  {
	    if (event->xmap.window==window[i]) 
	      { 
		randomize_kal(i);
		
		HC[i] = rndm((long)numcolors);
	      }
	  }
    }
  else if (event->type==VisibilityNotify) 
    {
      for(i=0;i<options.windows;i++)
	{
	  if (event->xvisibility.window==window[i]) 
	    {
	      if (visible[i] &&
		  event->xvisibility.state == VisibilityFullyObscured) 
		{
		  visible[i]=0;
		  nvisible--;
		}
	      else if (!visible[i] &&
		       event->xvisibility.state != VisibilityFullyObscured) 
		{
		  visible[i]=1;
		  nvisible++;
		}
	    }
	}
    }
  else if (event->type==ButtonPress)
    { 
      if (event->xbutton.button==Button1)
	{ 
/*
 * Zoom in on a section of the Mandelbrot set.. only goes 1 layer of zoom in
 * ok, so I'm lazy and didn't bother figure how to store the new coords
 * deal
 */
	  if(options.mode==mandel)
	    {
	      if(!pressed)
		{
		  l=event->xbutton.x;
		  t=event->xbutton.y;
		  printf("Button 1 Pressed at (%d,%d) \n",l,t);
		  pressed=1;
		}
	      else
		{
		  r=event->xbutton.x;
		  b=event->xbutton.y;
		  printf("Button 1 Pressed again at (%d,%d)\n",r,b);
		  pressed=0;
		  jj[0]=0;
 		  dropachicken=1;
		}
	    }
/* drop a new particle in the chamber */
	  else if(options.mode==gravity)
	    {
	      int i,found,winno;
	      for(i=0;i<options.windows;i++)
		{
		  if(event->xbutton.window==window[i])
		    {
		      found=1; winno=i; break;
		    }
		}
	      if(found)
		{
		  set_part(winno,event->xbutton.x,event->xbutton.y,
			   &partlst[winno][rndm(options.numparts)]);
		}
	    }
	  else if(!options.mono)
	    {
	      if(options.dynamic_colors)
		randomize_colors();
	      else
		rotate_colors();
	    }
	}
      else if (event->xbutton.button==Button3)
	{
	  int i,found=0;
	  /*
	    if(options.mode==tunnel)
	    {
	    EndofTunnel();  is there a light? 
	    }
	    */ 
	  if(options.lock)
	    {
	      maybe_unlock();
	    }
	  else
	    {
	      /* do the zoomy close window thing */
	      for(i=0;i<options.windows;i++)
		{
		  if(event->xbutton.window==window[i])
		    {
		      found=1; break;
		    }
		}
	      if(found)
		{
		  if(options.annoy_tefler)
		    {
		      int x,y,dx,dy,dontcare;
		      Window wdontcare;
	      
		      XGetGeometry(display,window[i],&wdontcare,
				   &dx,&dy, &x, &y, &dontcare, &dontcare);
	  
		      while(x>0&&y>0)
			{
			  XMoveResizeWindow(display,window[i],dx++,dy++, x,y);
			  x=x-2;
			  y=y-2;
			  XFlush(display);
			}
		    }
		  
		  nwindows--;
		  /* options.windows--; */
		  visible[i]=0;
		  nvisible--;
		  /* fprintf(stderr,"Killing Window %d: %lx\n",i,window[i]); */
		  XUnmapWindow(display,window[i]);
		  jj[i]=1; /* don't redraw it */
		  
		  XSync(display,False); 
		  if(nwindows==0)
		    {
		      XFreeColors(display, colmap, colors[0], numcolors, 1);
		      XFreeColors(display, colmap, colors[1], numcolors, 1);
		      XFreeColors(display, colmap, colors[2], numcolors, 1);
		      exit(0);
		    }
		}
	    }
	}
      else if (event->xbutton.button==Button2)
	{ 
	  int i,found=0;
	  for(i=0;i<options.windows;i++)
	    {
	      if(event->xbutton.window==window[i])
		{
		  found=1; break;
		}
	    }
	  if(found)
	    jj[i]=0;
	  /* reset screen*/
	  XClearWindow(display,event->xbutton.window);
	  if(options.totalrand)
	    {
	      options.mode=rndm(13);
	    }
          dropachicken=1;
	}
    }
}

void refreshrootquit()
{ 
/* no clear. leave the current pattern on the background */
  if(!options.noclear)
    {
      int i;
      s_win_att.backing_store=WhenMapped;
      for(i=0;i<options.windows;i++)
	XChangeWindowAttributes(display,window[i],CWBackingStore,&s_win_att);
      
      XClearWindow(display,RootWindow(display,screen));
      XFreeColors(display, colmap, colors[0],numcolors,1);
      XFreeColors(display, colmap, colors[1],numcolors,1);
      XFreeColors(display, colmap, colors[2],numcolors,1);
      XFlush(display);
    }
  exit(0);
}

void parse_options(int argc, char **argv)
{
  while (--argc>0) 
    {
      char *option = (*++argv);
      if (!strcmp(option,"-display")) 
	{
	  if (--argc==0)
	    usage();
	  options.displayname = (*++argv);
	}
      else if (strchr(option,':')) 
	{
	  options.displayname = option;
	}
      else if (!strcmp(option,"-bg")) 
	{
	  if (--argc==0) 
	    usage();
	  options.background = (*++argv);
	}
      else if (!strcmp(option,"-bd")) 
	{
	  if (--argc==0)
	    usage();
	  options.border = (*++argv);
	}
      else if (!strcmp(option,"-boxes"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=boxes;
	}
      else if (!strcmp(option,"-bozo"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=bozo;
	}
      else if (!strcmp(option,"-bw")) 
	{
	  if (--argc==0)
	    usage();
	  options.bwidth = atoi(*++argv);
	  if (options.bwidth<0)
	    options.bwidth = 0;
	}
      else if (!strncmp(option,"-circ",5))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode = circ;
	}
      else if (!strcmp(option,"-clover"))
	{
	  options.mode = clover;
	}
      else if (!strcmp(option,"-colors"))
	{
	  if (--argc==0)
	    usage();
	  options.tryfor = atoi(*++argv);
	  if (options.tryfor<0)
	    options.tryfor=2;
	}
      else if (!strcmp(option,"-delay")) 
	{
	  if (--argc==0)
	    usage();
	  options.delayvalue = atoi(*++argv);
	  if (options.delayvalue<0)
	    options.delayvalue = 0;	    
	}
      else if (!strncmp(option,"-dont",5))
	{
	  options.annoy_tefler=0; /* don't do the Zoomy close window thang */
	}
      else if (!strcmp(option,"-few"))
	{
	  options.tryfor=18;
	}
      else if (!strcmp(option,"-funky"))
	{
	  options.mode=funky;
	}
      else if (!strcmp(option,"-several"))
	{
	  options.tryfor=18*4;
	}
      else if (!strcmp(option,"-lotsa"))
	{
	  options.tryfor=NCOLORS;
	}
      else if (!strcmp(option,"-geometry")) 
	{
	  if (--argc==0)
	    usage();
	  options.geomstring = (*++argv);
	}
      else if (*option=='=') 
	{
	  options.geomstring = option;
	}
      else if (!strcmp(option,"-gravity"))
	{
	  options.mode=gravity;
	  options.number=2;
          if(options.numparts==0)
	     options.numparts=1;
	  options.delayvalue = 2;
	}
      else if (!strcmp(option,"-julia"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=julia;
	}
      else if (!strcmp(option,"-kaleid"))
	{
	  options.mode=kaleid;
	}
      else if (!strcmp(option,"-life"))
	{
	  options.mode=life;
	  if(options.number==0)
	    options.number=60;
	}
      else if(!strcmp(option,"-lock"))
	{
	  options.lock=1;
	}
      else if (!strcmp(option,"-mandel"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode= mandel;
	}
      else if (!strcmp(option,"-max"))
	{
	  options.mode=maxh;
	}
      else if (!strncmp(option,"-mono",5)) 
	{
	  options.mono=1;
	}
      else if (!strcmp(option,"-multi")) 
	{	
	  options.multi=1;
	}
      else if (!strcmp(option,"-newton"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=newton;
	}
      else if (!strcmp(option,"-noclear"))
	{
	  options.noclear=1;
	}
      else if (!strncmp(option,"-num",4))
	{
	  if (--argc==0)
	    usage();
	  options.number=atoi(*++argv);
	  if(options.number<0)
	    options.number=0;
	}
      else if(!strcmp(option,"-windows"))
	{
	  if(--argc==0)
	    usage();
	  options.windows=atoi(*++argv);
	  if(options.windows<1)
	    options.windows=1;
	}
      else if (!strcmp(option,"-norect"))
	{
	  options.norect=1;
	}
      else if (!strcmp(option,"-off"))
	{
	  options.mode=off;
	  options.tryfor=30;
	}
      else if (!strncmp(option,"-pal",4))
	{
	  if(--argc==0)
	    usage();
	  options.palette=atoi(*++argv);
	}
      else if(!strncmp(option,"-part",4))
	{
	  if(--argc==0)
	    usage();
	  options.numparts=atoi(*++argv);
	  if(options.numparts<1)
	    options.numparts=1;
	}
      else if (!strcmp(option,"-perfect"))
	{
	  options.perfect=1;
	  options.tryfor=1024;
	}		  
      else if (!strcmp(option,"-plasma"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=plasma;
	}
      else if (!strcmp(option,"-qix"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=qix;
	}
      else if (!strcmp(option,"-qix4"))
	{
	  if(options.number==0)
	    options.number=10;
	  options.mode=qix4;
	}
      else if ((!strcmp(option,"-r")) || (!strcmp(option,"-root")))
	{
	  options.doroot = 1;
	}
      else if (!strncmp(option,"-rand",5)) 
	{
	  options.dynamic_colors = 1;
	}
      else if (!strncmp(option,"-rilly",6))
	{
	  options.geomstring=(char *)malloc(10*sizeof(char));
	  strcpy(options.geomstring,"1024x860");
	  options.rillybig=1;
	}
      else if (!strcmp(option,"-ripple"))
	{
	  options.mode=ripple;
	}
      else if (!strcmp(option,"-rose"))
	{
	  options.mode=rose;
	}
      else if (!strcmp(option,"-sphere"))
	{
	  options.mode=spheres;
	}
      else if (!strcmp(option,"-spiral"))
	{
	  options.mode=spiral;
	}
      else if (!strcmp(option,"-static"))
	{
	  options.mode=xstatic;
	  options.dynamic_colors=1; /* random colors */
	}
      else if (!strcmp(option,"-test"))
	{
	  options.mode=test;
	}
      else if (!strncmp(option,"-total",6))
	{
	  options.totalrand=1;
	}
      else if(!strcmp(option,"-trell"))
	{
	  options.trell=1;
	}
      else if(!strcmp(option,"-tunnel"))
	{
	  options.mode=tunnel;
	}
      else if (!strcmp(option,"-wander"))
	{
	  options.mode=wandering;
	  options.delayvalue=1;
	}
      else usage();
    }
}

void usage()
{
  fprintf(stderr,"XTacy Ver. %s by Jer Johnson (mpython@gnu.ai.mit.edu)\n",VERSION);
  fprintf(stderr,"Usage: %s [-lotsa flags]\n",progname);
  fprintf(stderr," Used everywhere: [-bw <border width>] [-delay <msec>] [-dontannoy]\n");
  fprintf(stderr,"\t[-display <displayname>] [-geometry <geomtry>] [-lock] [-r|root] \n\t[-rillybig] [-windows <number>]\n");
  fprintf(stderr, " Color Options: [-bd <color>] [-bg <color>] [-mono] [-multi] [-few] [-several] \n\t[-colors <num>]");
  fprintf(stderr, " [-rand|randomcolor] [-perfect] [-pal {0|1|2|3}]\n Neat Effects(default is kaleid): [-boxes] [-bozo] [-circ] [-clover] [-funky]\n\t[-gravity] [-julia]");
  fprintf(stderr, " [-life] [-mandel] [-off] [-plasma] [-qix] [-qix4] \n\t[-spiral] [-static] [-test] [-tunnel] [-wander]\n");
  fprintf(stderr, " With kaleid: [-norect]\n");
  fprintf(stderr, " With boxes,bozo,circ,qix:[-number <number>]\n");
  fprintf(stderr, " With plasma: [-trell] [-number <number>] determines graniness.\n");
  fprintf(stderr, " With gravity: [-number <num Wells>] [-part <num Particles>]\n");

  putc('\n',stderr);
  exit(1);
}

void
fatalerror(char *s1, char *s2)
{
  XEvent event;
  
  fprintf(stderr,"%s: ",progname);
  fprintf(stderr,s1,s2);
  if (XCheckMaskEvent(display,~0L,&event)==True) 
    handle_event(&event);  
  putc('\n',stderr);
  exit(1);
}


int scheduler()
{
  struct timeval currtime, *nextalarm, *alarmindex;
  struct timezone tzp;
  int i;

  /* Get current time */
  (void)gettimeofday(&currtime, &tzp);

  /* Find earliest alarm due */
  alarmindex = nextalarm = schedule;
  for (i=1; i<options.windows; i++) 
    {
      if (visible[++alarmindex - schedule] &&
	  ( alarmindex->tv_sec < nextalarm->tv_sec ||
	   alarmindex->tv_sec == nextalarm->tv_sec &&
	   alarmindex->tv_usec < nextalarm->tv_usec ))
	nextalarm = alarmindex;
    }

  /* If the next alarm is not past due, sleep until it comes due */
  if (currtime.tv_sec < nextalarm->tv_sec ||
      currtime.tv_sec == nextalarm->tv_sec &&
      currtime.tv_usec < nextalarm->tv_usec) 
    {
      struct timeval timeout;
      int fd=ConnectionNumber(display), readfds;

      timeout.tv_sec = 0;
      timeout.tv_usec = 0;
      timeout.tv_sec = nextalarm->tv_sec - currtime.tv_sec;
      timeout.tv_usec = nextalarm->tv_usec - currtime.tv_usec;
      if (timeout.tv_usec < 0) 
	{
	  timeout.tv_sec -= 1L;
	  timeout.tv_usec += 1000000L;
	}
      
      readfds = 1<<fd;
      (void)select(fd+1, &readfds, NULL, NULL, &timeout);

      /* Recompute current time */
      (void)gettimeofday(&currtime, &tzp);
    }

  /* Set next alarm to current time + interval */
  nextalarm->tv_sec = currtime.tv_sec+intervals[nextalarm-schedule].tv_sec;
  nextalarm->tv_usec = currtime.tv_usec+intervals[nextalarm-schedule].tv_usec;
  if (nextalarm->tv_usec >= 1000000) 
    {
      nextalarm->tv_sec += 1;
      nextalarm->tv_usec -= 1000000;
    }

  /* Return index of next alarm */
  return nextalarm-schedule;
}

void
MakeWindow(int o_argc,char **o_argv)
{
  XSizeHints size_hints;
  int i;
  char *basename, *strrchr();
  if ((basename=strrchr(progname,'/'))!=NULL) 
    basename++;
  else 
    basename=progname;
  
/* top corner of the window */
  size_hints.x = 0;
  size_hints.y = 0;

  if(options.mode==test)
    {
      size_hints.width = 800;
      size_hints.height = 400;
    }
  else if(options.mode==mandel)
    {
      size_hints.width = 600;
      size_hints.height = 600;
    }
  else
    {
      size_hints.height = 400;
      size_hints.width = 400;
    }

  size_hints.flags = PPosition | PSize;
  
/* if there's a geometry string, parse it */
  if (options.geomstring!=NULL) 
    {
      int result;
      result = XParseGeometry(options.geomstring,&size_hints.x,
			      &size_hints.y,&size_hints.width,
			      &size_hints.height);
      if (result & XNegative)
	size_hints.x += DisplayWidth(display,screen)
	  - size_hints.width - options.bwidth*2;
      if (result & YNegative)
	size_hints.y += DisplayHeight(display,screen)
	  - size_hints.height - options.bwidth*2;
    if (result & XValue || result & YValue) 
	{
	  size_hints.flags |= USPosition;
	  size_hints.flags &= ~PPosition;
	}
      if (result & WidthValue || result & HeightValue) 
	{
	  size_hints.flags |= USSize;
	  size_hints.flags &= ~PSize;
	}
    }
  for(i=0;i<options.windows;i++)
    {
      window[i] = XCreateSimpleWindow(display,RootWindow(display,screen),
				      size_hints.x,size_hints.y,
				      size_hints.width,size_hints.height,
				      options.bwidth,options.bdcolor,
				      options.bgcolor);
      XSetStandardProperties(display,window[i],"XTacy",basename,
			     None,o_argv,o_argc,&size_hints);
      XSelectInput(display,window[i],
		   StructureNotifyMask|VisibilityChangeMask|
		   ButtonPressMask|ButtonMotionMask);
      XMapWindow(display,window[i]);
      XFlush(display);
/*      fprintf(stderr, "Window= %lx\n",window[i]); */
    }
  return;
}

void
MakePerfectWindow(int o_argc, char **o_argv)
{
  Window tempwin;      
  XSizeHints size_hints;
  unsigned long vmask=0;
  XSetWindowAttributes xswat;
  XVisualInfo *vis_info;
  int number,i;
  char *basename, *strrchr();
  if ((basename=strrchr(progname,'/'))!=NULL) 
    basename++;
  else 
    basename=progname;
  size_hints.x = 0;
  size_hints.y = 0;
  if(options.mode==test)
    {
      size_hints.height = 400;
      size_hints.width = 800;
    }
  else if(options.mode==mandel)
    {
      size_hints.width = 600;
      size_hints.height = 600;
    }
  else
    {
      size_hints.height = 400;
      size_hints.width = 400;
    }

  size_hints.flags = PPosition | PSize;
  
  if (options.geomstring!=NULL) 
    {
      int result;
      result = XParseGeometry(options.geomstring,&size_hints.x,
			      &size_hints.y,&size_hints.width,
			      &size_hints.height);
      if (result & XNegative)
	size_hints.x += DisplayWidth(display,screen)
	  - size_hints.width - options.bwidth*2;
      if (result & YNegative)
	size_hints.y += DisplayHeight(display,screen)
	  - size_hints.height - options.bwidth*2;
    if (result & XValue || result & YValue) 
	{
	  size_hints.flags |= USPosition;
	  size_hints.flags &= ~PPosition;
	}
      if (result & WidthValue || result & HeightValue) 
	{
	  size_hints.flags |= USSize;
	  size_hints.flags &= ~PSize;
	}
    }

  xswat.override_redirect = False;
  xswat.do_not_propagate_mask = KeyPressMask | KeyReleaseMask ;
  xswat.background_pixmap=None;
/*      |	ButtonPressMask | ButtonReleaseMask; */
/*      vmask = CWOverrideRedirect | CWDontPropagate; */
  vmask =  CWBackPixmap;
  vis_info=(XVisualInfo *)malloc(sizeof(XVisualInfo));
  vis_info->colormap_size=512;
  
  vis_info=XGetVisualInfo(display,VisualColormapSizeMask,vis_info,&number);
  if(number!=0)
    {
      vis=vis_info->visual;
    }      
  fprintf(stderr,"Vis->map_entries= %d\n",vis->map_entries);
  options.tryfor=vis->map_entries;
  
  for(i=0;i<options.windows;i++)
    {  
      window[i] = XCreateWindow(display, RootWindow(display, screen), 0, 0,
				size_hints.width, size_hints.height,
				options.bwidth, CopyFromParent, InputOutput,
				vis , vmask, &xswat);
      XSetStandardProperties(display,window[i],"Xtacy",basename,
			     None,o_argv,o_argc,&size_hints);
      XSelectInput(display,window[i],
		   StructureNotifyMask|VisibilityChangeMask|
		   ButtonPressMask|ButtonMotionMask);
      XMapWindow(display,window[i]);
    }
  
  free(vis_info);
  return;
}

int
initstuff(int nwin)
{
  if(!options.doroot)
    {
      if ((CX=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
      if ((CY=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
    }
  
  if ((M=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
  if ((jj=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
  if ((visible=(int *)calloc(nwin,sizeof(int))) == NULL) return 0;
  if ((schedule=(struct timeval *)calloc(nwin,sizeof(struct timeval))) == NULL)
    return 0;
  if ((intervals=(struct timeval *)calloc(nwin,sizeof(struct timeval))) == NULL)
    return 0;
  return 1;
}

void
maybe_unlock()
{
  Window textWin;
  char checkme[80];
  XGCValues values;
  checkme[0]=0;
  
/* create a window to take in the text */
  textWin = XCreateSimpleWindow(display,window[0],
				200,50,200,50,
				options.bwidth,options.bdcolor,
				options.bgcolor);
  XSelectInput(display,textWin,KeyPressMask);
  XMapWindow(display,textWin);
  XRaiseWindow(display,textWin);

  values.foreground=StrColor("white",WhitePixel(display,screen));
  XChangeGC(display,color_gcs[1],GCForeground,&values);
  XDrawString(display,textWin,color_gcs[1],5,30,"Enter Your Key:",16);
  XFlush(display);
  
/* grab the text. compare it to the password */
  while(1)
    {
      if (XCheckMaskEvent(display,~0L,&event)==True) 
	{
	  /*	  fprintf(stderr,"Event type= %d\n",event.type); */
	  if(event.type==KeyPress)
	    {
	      KeySym foob;
/*	      fprintf(stderr,"KeyPressed=%x\t",event.xkey.keycode); */
	      foob=XKeycodeToKeysym(display,event.xkey.keycode,0);
	      if((!strcmp(XKeysymToString(foob),"BackSpace"))||
		  (!strcmp(XKeysymToString(foob),"Delete")))
		{
		  checkme[strlen(checkme)-1]=0;
/*		  fprintf(stderr,"String=%s\n",checkme); */
		}
	      else if(strcmp(XKeysymToString(foob),"Return"))
		strcat(checkme,XKeysymToString(foob));
	      else
		{
		  /* fprintf(stderr,"String=%s\n",checkme); */
		  break;
		}
	      
	    }
	  fflush(stderr);
	}
    }
  /* if they're equal... kill the 2 windows */
  if(!strcmp(checkme,password))
  {
    XDestroyWindow(display,textWin);
    XUngrabKeyboard(display,CurrentTime);
    XUngrabPointer(display,CurrentTime);
    XFreeColors(display, colmap, colors[0],numcolors,1);
    XFreeColors(display, colmap, colors[1],numcolors,1);
    XFreeColors(display, colmap, colors[2],numcolors,1);
    exit(0);    
  }
  else
    {
      XDestroyWindow(display,textWin);
/* else return */  
      return;
    }
}

void
initTables()
{
  int i;
  for(i=0;i<32;i++)
    {
      CosTbl[i]=cos(i*M_PI/16);
      SinTbl[i]=sin(i*M_PI/16);
    }
}
