.\" $XConsortium: CTToWC.man,v 1.2 91/10/08 15:24:12 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH _XConvertCTToWC 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
_XConvertCTToWC \- conversion from  CT string to  WC string
.SH SYNOPSIS
.B int _XConvertCTToWC\f2(xlocale, ct_str, ct_bytes, wc_str, wc_len,
.br
.B                                    \f2scanned_bytes, state)
.br
.B XLocale \f2xlocale\f3;
.br
.B char \f2*ct_str\f3;
.br
.B int \f2ct_bytes\f3;
.br
.B wchar \f2*wc_str\f3;
.br
.B int \f2*wc_len\f3;
.br
.B int \f2*scanned_bytes\f3;
.br
.B _State \f2*state\f3;
.br
.SH ARGUMENTS
.IP \fIxlocale\fP 1i
In: specifies locale, the default NULL is the current locale.
.IP \fIct_str\fP 1i 
In: CT string.
.br
.IP \fIct_bytes\fP 1i 
In: length of CT strings, counted in bytes.
.br
.IP \fIwc_str\fP 1i
Out: conversion buffer of result wchar string.
.br
.IP \fIwc_len\fP 1i 
In/Out: as "In" it is length of buffer wc_str passed by caller; 
as "Out" it is the returned number of converted wchars. 
.br
.IP \fIscanned_bytes\fP 1i 
Number of CT bytes converted when the function returns.
.br
.IP \fIstate\fP 1i
In/Out: as "In" it is the state at the beginning of
the CT string;
as "Out" it is the current state stopped at last converted CT
encoding.  The state is defined internally by Xlib.
If this pointer is null, the function will assume
the state to be the default CT state. Of course,
nothing will be put in the null pointer. Do not modify or free this data
.br
.SH DESCRIPTION
The
.B _XConvertCTToWC
converts the string encoded in CT to string encoded in wchar.
After a successful conversion, the null character WNULL will be
appended to wc_str if there is room for it in the buffer.
The terminator WNULL
of wchar string is not counted in length of output buffer wc_len.
.PP
The returned state will point to a state of 
the encoding in the internal table, so do not modify or free this 
pointer.
.PP
When function returns at any time, scanned_bytes always remembers
where stopped, and state always remembers the current CT state
if it is not null pointer.
.PP
The caller of this funcion has to provide the output buffer wc_str,
and store the buffer length(in wchars) into wc_len as input. 
By using scanned_bytes and state, the caller can break a large
CT string into pieces, and convert one piece at a time.
.PP
In other hand caller can pass any broken CT
string to this function for doing conversion.
For example, caller can still be trying of conversion when 
the error BadBuffer is occurred(output buffer was exhausted).
Usually, the application passes the NULL to state for first 
conversion as the following:
.IP "" "   "
char *state = NULL;
.br
\f3_XConvertCTToWC(NULL, ct_str, ct_len, mb_str,
            &mb_len, &scanned, &state)\f2
.PP
The conversion function returns the value of variable state
to use for the conversion of the next unconverted piece of the
same string.  And so on.
.PP
If the value of state is invalid or null-pointer, the function
will suppose the default state of CT as initial.
The default state of CT is defined in 3 cases of encoding:
.IP "" 2
1\. no control sequence, GL and GR of Latin-1 is supposed.
.IP 
2\. control sequence of Latin-1 GL only, GR of Latin-1 is supposed too.
.IP
3\. control sequence of Latin-1 GR only, GL of Latin-1 is supposed too.
.PP
The function returns the BadBuffer meaning that
the output buffer wc_str was exhausted.
The function returns the BadTerminate meaning that
the CT string ct_str is terminated uncompletely, 
e.g., uncompleted ESC sequence or
uncompleted code point ended at tail of ct_str.
.PP
Only in both the case of BadBuffer and BadTerminate the
caller can
move pointer ct_str to (ct_str + *scanned_bytes), then continue
to do conversion.
And function ensure that the wc_str stores the already converted
wchar string; wc_len counts
the number of them in wchars(not bytes); the state stores
the last state of encoding.
.PP
The function returns a number greate than zero meaning a number of
wrong codepoints recovered by the funcition.
The wrong codepoint
will be recovered with the first codepoint of the charset at which
the wrong codepoint occurs.
After replaced, the function will continue to do conversion untill
one of the results Success, BadTerminate, BadBuffer or BadEncoding
is met.
.PP
The funcition returns BadEncoding meaning for unrecoverable wrong code 
which is actually wrong escape sequence, or not registered by
system yet.
.PP
Both the null character and ct_bytes will terminate the conversion.
.PP
All error status are defined to be less than zero, i.e.:
.IP "" 2
#define Success          0
.IP
#define BadBuffer       -1
.IP
#define BadTerminate    -2
.IP
#define BadEncoding     -3
.SH RETURNED VALUE
The
.B _XConvertCTToWC will return the following values:
.TP
.B Success
successful conversion.
.TP
.B BadBuffer
output buffer(wc_str) was exhausted.
.TP
.B BadTerminate
.TP
.B BadEncoding 
wrong codepoints can not be recovered.
.TP
.B "> 0"
number of wrong codepoints, but recovered.
.SH SEE ALSO
Refer to "CT and WC" for their definitions.
