/*
 * dip		A program for handling dialup IP connecions.
 *
 * Version:	@(#)dip.h	3.3.7-uri	05/24/94
 * Version:	@(#)dip.h	3.3.7		12/13/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *              Uri Blumenthal <uri@watson.ibm.com>
 *              (C) 1994
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <netinet/in.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <netdb.h>
#include <pwd.h>
#include <resolv.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include "pathnames.h"


/* DIP definitions. */
#define DIP_SFX		".dip"
#define DIP_SLIP	1		/* we support the SLIP protocol	*/
#define DIP_PPP		0		/* we support the PPP protocol	*/

/* SLIP/PPP/ASK initial protocol configuration. */
#define DEF_MTU		296
#define DEF_PROT	"SLIP"
#define DEF_MODEM	"HAYES"
#define DEF_SPEED	"38400"


struct dip {
  /* Login info. */
  char			name[16];		/* login name of host	*/
  char			passwd[10];		/* any external passwd	*/
  char			home[1024];		/* user home directory	*/

  /* Misc protocol info. */
  char			comment[128];		/* any comments		*/
  char			protocol[16];		/* protocol to use	*/
  int			protonr;		/* decoded protocol #	*/
  int			mtu;			/* MTU to use for conn.	*/

  /* Connection info. */
  char			local[128];		/* local host name	*/
  struct in_addr	loc_ip;			/* mapped IP address	*/
  char			remote[128];		/* remote host name	*/
  struct in_addr	rmt_ip;			/* mapped IP address	*/
  char			gateway[128];		/* remote gateway name	*/
  struct in_addr	rmt_gw;			/* mapped IP address	*/
  char			netmask[32];		/* netmask of route	*/
  char			route[128];		/* name of rmt network	*/
  struct in_addr	rmt_rt;			/* mapped IP address	*/
  int			rtdefault;		/* are we the dflt gw?	*/
};


/* DIP protocol switcher definitions. */
struct protosw {
  char	*name;
  int	type;
  void	(*func)(struct dip *);
};


/* DIP global variables. */
extern int		opt_v;		/* flag: be verbose!		*/
extern struct dip	mydip;		/* global DIP entry		*/
extern struct protosw	protosw[];	/* table with protocol info	*/


/* Global functions. */
extern void	do_command(FILE *file);
extern void	do_login(char *user, char **argp);
extern void	do_terminal(void);
extern int	get_prot(char *name);
extern void	ip_dump(char *ptr, int len);
extern int	dip_daemon(struct dip *dip);
extern int	dip_setup(struct dip *dip);
extern int	dip_login_setup(struct dip *dip);

extern int	mdm_init(char *text);
extern int	mdm_modem(char *modem);
extern int	mdm_dial(char *number);
extern int	mdm_reset(void);
extern int	mdm_hangup(void);

extern int	attach(char *name, struct dip *dip);
extern void	detach(char *name);

extern int	tty_getc(void);
extern int	tty_putc(int c);
extern void	tty_puts(char *s);
extern int	tty_askfd(void);
extern int	tty_get_disc(int *disc);
extern int	tty_set_disc(int disc);
extern int	tty_get_encap(int *encap);
extern int	tty_set_encap(int encap);
extern int	tty_get_name(char *name);
extern int	tty_databits(char *bits);
extern int	tty_stopbits(char *bits);
extern int	tty_parity(char *type);
extern int	tty_speed(char *speed);
extern int	hanguptty(void);
extern int	tty_notlocal(void);
extern int	tty_login(void);
extern int	tty_flush(void);
extern int	tty_close(void);
extern int	tty_login_close(void);
extern int	tty_open(char *name);
extern int	tty_nomesg(void);

/* End of DIP.H */
