;;; Copyright (c) 1991 Wayne Mesard.  May be redistributed only under the
;;; terms of the GNU Emacs General Public License.

;;; 
;;; DM-C  :  Dynamic Macros for C mode
;;; 

;; This file tries to load "dmacro.elc".
;; The "load-path" variable, as set in your Emacs init file, should include
;; a directory containing the file "dmacro.elc".

;;; HISTORY
;;    2.0 wmesard - Oct 18, 1991: Freeze.

;;;
;;; REQUIREMENTS
;;;

(require 'dmacro)


;;; 
;;; KEY BINDINGS
;;; 

(if (not (and (boundp 'dont-bind-my-keys) dont-bind-my-keys))
    (global-set-key "\C-ct" 
		    (dmacro-function "dstamp" "dtstamp" 'insert-timestamp))
  )


;;; 
;;; USER PARAMETERS
;;; 

(setq auto-dmacro-alist (append '(("\\.c$" . masthead) ("\\.h$" . dot-h))
				  auto-dmacro-alist))


;;;
;;; ALIASES
;;;

(def-dmacro-alias
  dn ((month-num) :pad nil)
  dd ((chron) 8 10 :pad nil)
  dy ((chron) 22)
  )
  
;;; 
;;; GLOBAL DMACROS
;;; 

(add-dmacros 'global-abbrev-table '(
    ("dstamp"	" -~((user-initials) :down)~dn/~dd/~dy."
     nil	"user id and date")
    ("dtstamp"	" -~((user-initials) :down)~dn/~dd/~dy ~((hour) :pad nil):~min~ampm."
     nil 	"user id, date and time")
    ))


;;; 
;;; C-MODE DMACROS
;;; 

(add-dmacros 'c-mode-abbrev-table '(
    ("i" 	"#include <~@.h>\n"
     nil	"simple #include directive")
    ("iinclude"	"#ifndef ~((prompt file \"Header file name: \") :up)
# include <~(prompt file).h>
#endif /* ~((prompt file) :up) */\n"    nil
	"interactive #include with #ifndef (prompts for file name)")
    ("d" 	"#define " nil)
    ("ifd"	"#ifdef ~@
~(mark)
#endif \n"	indent	"#ifdef/#endif (no prompting)")
    ("ifdnever"	"#ifdef NEVER
~@
#endif /* NEVER */\n"    nil
	"#ifdef NEVER (ideal for use with dmacro-wrap-region)")
    ("ifddebug"	"#ifdef DEBUG\nif (debuglevel >= ~(prompt debug \"Debug level: \") {
(void) fprintf(stderr, \"DEBUG: ~@\\n\");
(void) fflush (stderr);\n(void) getch ();\n}
#endif /* DEBUG */"
	indent "print debugging info to stderr")
    ("iifd"	"#ifdef ~(prompt constant \"#ifdef condition: \")
~@
#endif /* ~(prompt) */\n"    nil	"#ifdef/#endif (prompts for condition)")
    ("iifnd"	"#ifndef ~(prompt constant \"#ifndef condition: \")
~@
#endif /* ~(prompt) */\n"    nil      "#ifndef/#endif (prompts for condition)")
    ("iifed"	"#ifdef ~(prompt constant \"#ifdef condition: \")
~@
#else
 ~(mark)
#endif /* ~(prompt) */\n"    nil  "#ifdef/#else/#endif (prompts for condition)")
    ("b" 	"{
~@
}"	indent "curly braces (ideal for dmacro-wrap-line)")
    ("switch"	"switch (~@)
{

}"	indent	"switch statement")
    ("case"	"case ~@:

break;"	indent "case/break")
    ("if"	"if (~@)
 ~(mark)\n" 	indent	"if statement")
    ("ife"	"if (~@)
 ~(mark)
else
 ~(mark)\n" 	indent	"if/else statement")
    ("for"	"for (~@; ; )
{
 ~mark
}\n" 	indent "for statment")
    ("fori"	"for (i = 0; i < ~@; ++i)
{
 ~mark
}\n" 	indent "for statement (increments variable i)")
    ("foriefficient"	"for (i = ~@; --i >= 0; )
{
 ~mark
}\n" 	indent "for statement (decrements i efficiently)")
    ("ifor"	"for (~(prompt var \"Variable: \") = 0; ~prompt < ~@; ++~prompt)
{
 ~mark
}\n"	indent	"interactive for statment (prompts for variable name)")
    ("while"	"while (~@)
{
 ~mark
}\n" 	indent "while statement")
    ("void"	"(void)"	indent)
    ("p"	"(void) printf(\"~@\\n\"~mark);" indent "printf")
    ("ifmal"
       "if ((~@ = (~(prompt type \"Variable type: \") *) ~(dmacro malloc)(~(mark)sizeof(~(prompt)))) == NULLP(~(prompt)))\n"	
       indent	"malloc with check for error (prompts for var type)")
    ("mal"	"= (~(prompt type \"Variable type: \") *) ~(dmacro malloc)(~@sizeof(~(prompt)));\n"	
     indent	"call to malloc (prompts for var type)")
    ("fdesc"	"/**
NAME:    
  ~@
PURPOSE:
  ~mark
ARGS:
  > ~mark
RETURNS:
  < ~mark
NOTES:
  ~mark
**/\n"	expand "Standard function comment block")
    ("func"
     "~(prompt type \"Function type: \") ~(prompt name \"Function name: \")(~@)
{\n~mark\n} /* ~(prompt name) */\n"
     indent "function definition (prompts for type and name)")
    ("main"	"main(argc, argv)
int argc;
char **argv;
{
~@
}\n" 	indent "an empty main() function with args")
    ("masthead"
	"/* Copyright (c) ~(year) by A BIG Corporation.  All Rights Reserved */

/***
   NAME
     ~(file-name)
   PURPOSE
     ~point
   NOTES
     ~mark
   HISTORY
~(dmacro history)Created.
***/\n\n"  	expand
	"commment block for the top of a .c file")
    ("history"	"     ~(user-id) - ~(mon) ~dd, ~(year): "	expand
     "a new HISTORY entry in the masthead")
    ("hifndef"	"#ifndef ~((file-name) :up)
#define ~((file-name) :up)

~@

#endif /* ~((file-name) :up) */" expand "used by dot-h macro")

    ("dot-h"	"~(dmacro masthead t)~(dmacro hifndef)"	expand
     "comment block for the top of a .h file")
))
