;;; Copyright (c) 1991 Wayne Mesard.  May be redistributed only under the
;;; terms of the GNU Emacs General Public License.

;;;
;;; DM-COMPAT  :  Dynamic Macro COMPATibility
;;;

;;; HISTORY
;;    2.0 wmesard - Oct 18, 1991: Freeze.

;; You are urged to convert your old templates to the new dmacro format.  But
;; for you lazy folk out there this file defines some aliases to make Template
;; v1.5 files more compatible with Dmacro v2.0.  It doesn't produce complete 
;; compatibility.  Specifically:
;;
;;  o You should change the ~s# directives by hand to the new ~(prompt)
;;    syntax and get rid of those ridiculous lambda expressions.
;;    The old syntax will sort of work, except your prompt will be replaced
;;    by a default one.
;;  o The ~pC directive is no longer supported.  You must now use
;;    the pad modifier.
;;  o ~>> and ~>@ are not supported.  You must use the new ~(dmacro) function.
;;  o Not every single v1.5 directive is supported.  For example, ~u# is
;;    supported only if # is less than 4.  ~fd is supported, but ~Fd is not.
;;    If I left out your favorite, you should be able to add it by using
;;    the others as a model.
;;
;; Note that ~@ and ~~ will work without modification.

(def-dmacro-alias
  dy ((chron) 22)
  dY year
  dm ((mon) :down)
  Dm ((mon) :down :cap)
  DM ((mon) :down :up)
  dn ((month-num) :pad nil)
  dN ((month-num) :pad ?0)
  dd ((chron) 8 10 :pad nil)
  dd ((chron) 8 10 :pad ?0)
  dw ((day) :down)
  Dw ((day) :cap)
  DW ((day) :up)
  ta ampm
  Ta ((ampm) :cap)
  TA ((ampm) :up)
  th ((hour) :pad nil)
  tH ((hour) :pad ?0)
  te ((hour24) :pad nil)
  tE ((hour24) :pad ?0)
  tm min
  ts sec
  ui user-id
  Ui ((user-id) :cap)
  UI ((user-id) :up)
  u1 ((user-id) 0 1)
  u2 ((user-id) 0 2)
  u3 ((user-id) 0 3)
  U1 ((user-id) :up 0 1)
  U2 ((user-id) :up 0 2)
  U3 ((user-id) :up 0 3)
  un ((user-name) :down)
  Un ((user-name) :cap)
  fn file
  FN ((file) :up)
  fd (file-dir)
  fp file-name
  FP ((file-name) :up)
  fe file-ext
  FE ((file-ext) :up)
  s0 prompt
  S0 ((prompt) :up)
  s1 (prompt string-two)
  S1 ((prompt string-two) :up)
  s2 (prompt string-three)
  S2 ((prompt string-three) :up)
  s3 (prompt string-four)
  S3 ((prompt string-four) :up)
  )

(defun template-prompt (&rest ignore)
  (dmacro-expand))

(defun template-prompt-indent (&rest ignore)
  (dmacro-indent))

(fset 'template-indent 'dmacro-indent)
(fset 'template-expand 'dmacro-expand)
(fset 'add-templates   'add-dmacros)

