.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XKeyCaps 1 "8-dec-93" "X Version 11"
.SH NAME
xkeycaps - graphically display and edit the keyboard mapping
.SH SYNOPSIS
.B xkeycaps
[-\fItoolkitoption\fP ...] [-\fIoption\fP ...]
.SH DESCRIPTION
The \fIxkeycaps\fP program displays a keyboard.  Moving the mouse over a 
key describes the keysyms and modifiers that that key generates.  Clicking
left on a key simulates a KeyPress event.  Clicking right on a key brings
up a menu of operations, including a command to change the keysyms that
the key generates.  This program is, in part, a graphical front-end to
.BR xmodmap (1).
.SH OPTIONS
.I xkeycaps
accepts all of the standard toolkit options, and also accepts the
following options:
.TP 4
.B \-keyboard \fIkeyboard\-name\fP\fR or \fP\fB\-kbd\fP \fIkeyboard\-name\fP
Specifies the type of keyboard to display.  There are many different computer
keyboards in the world, and \fIxkeycaps\fP must know which one you are using 
in order to function correctly.  Case does not matter when specifying a 
keyboard name.

If you're running on the console display of a Sun or HP, then \fIxkeycaps\fP
will interrogate the attached keyboard hardware directly to determine
what keyboard you're using.  But if you're running remotely, or on another
type of machine, then you must specify a keyboard somehow.
.TP 4
.B \-help
Lists the recognised values for the \fB\-keyboard\fP option.
.TP 4
.B \-gutterwidth \fInumber\fP\fR or \fP\fB\-gw\fP \fInumber\fP
Specifies the number of pixels of space to leave between each key.
.TP 4
.B \-font \fIfontname\fP
Specifies the font to use to display the keycaps.
.SH ""
The following standard X Toolkit command line arguments are commonly 
used with \fIxkeycaps\fP:
.TP 4
.B \-display \fIhost:dpy\fP
This option specifies the X server to contact.
.TP 4
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the window.
.TP 4
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.
The default is light gray.
.TP 4
.B \-fg \fIcolor\fP
This option specifies the color to use for the foreground of the window.
The default is black.
.TP 4
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding 
the window.
.TP 4
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH DISPLAY
The bottom part of the window is a drawing of a keyboard.  In the top left of
each key is printed the string which actually appears on the surface of the
key.  In the bottom right of the key is the (hexadecimal) keycode that this
key generates.

At the top of the screen are several lines of text describing the key
under the mouse (or the most recently typed key.)  These lines are:
.TP 12
.B KeyCode:
This displays the text printed on the physical key, and the keycode generated
by that key in hex, decimal, and octal.
.TP 12
.B KeySym:
This displays the set of KeySyms that this key currently generates.  
.TP 12
.B ASCII:
This displays the ASCII equivalent of this key, taking into account the
current modifier keys which are down.
.TP 12
.B Modifiers:
this displays the modifier bits which this key generates.  If a key generates
modifiers, it is a chord-key like \fIShift\fP or \fIControl\fP.
.TP 12
.B AutoRepeat:
Whether the X server claims that this key autorepeats.  I
say ``\fIclaims\fP'' because the OpenWindows X server is the only one I
have encountered for which this information is accurate.  The per-key
autorepeat flag seems to be almost-universally ignored.
.SH COMMANDS
There are several buttons in the upper left corner of the window.  They are:
.TP 4
.B Quit
Exits the program.
.TP 4
.B Select Keyboard
Pops up a dialog box from which you can change which keyboard is displayed.
The left column lists the known types of keyboards, and the right column
lists the known layouts (mappings) of those keyboards.
.TP 4
.B Type At Window
After selecting this, you are asked to click on some other window.  After
doing this, clicking on keys on the keyboard display will simulate key
events on the window you selected.  Selecting the root window or
the \fIxkeycaps\fP window turns this off.

If you are using a window manager (\fItwm\fP, for example) in which you
can lock the keyboard focus on a window and still click on other windows
without having the focus change, then you can accomplish the same thing
merely by focusing on another window and clicking on the keys in
the \fIxkeycaps\fP window.
.TP 4
.B Restore Default Map
This command restores the keyboard to its default state.  If you execute
this command while displaying a keyboard which is not the type of keyboard
you are really using, your keymap will be in a nonsensical state.  There is
no way for \fIxkeycaps\fP to tell what keyboard you are using except by
taking your word for it, so don't lie.
.TP 4
.B Write Output
This command writes an \fIxmodmap\fP input file representing the current
state of the keyboard (including all of your changes) to the standard output.
It prompts you with a dialog box: you can either write an \fIxmodmap\fP 
file representing the state of every key, or you can write a smaller
file which describes only the changes.

You can arrange for these bindings to be installed each time you log in
by placing the command
.EX
xmodmap \fIthe-file-written-by-xkeycaps\fP
.EE
in the appropriate init file.  If you don't know where that is, ask your
system administrator.
.PP
Clicking left on a key simulates a \fBKeyPress\fP event.  Releasing the button
simulates a \fBKeyRelease\fP event.  If you click left on a key and move the
mouse while the button is down, \fBKeyPress\fP and \fBKeyRelease\fP events 
will be simulated on every key you move the mouse over.  Think of the mouse 
as your finger: if you drag the mouse over several keys, they will go down
and up in turn.

Clicking left on a key which is associated with modifier bits (such as
Shift or Control) causes that key to ``lock'' down.  Clicking left again
releases the key.  In this way, you can generate key-chords with the mouse:
to generate \fIControl-C\fP, click left on the \fIControl\fP key, and then 
click on the \fIC\fP key.  Click on \fIControl\fP again to turn the control
modifier off.

Typing a key on the \fIreal\fP keyboard simulates 
a \fBKeyPress\fP/\fBKeyRelease\fP event pair in the same way that
clicking on a key does.

You can also combine mouse and keyboard input: for example, if you use
the mouse to select the \fIShift\fP key, and type a character, the event
that is simulated will have the \fIShift\fP modifier set.  And if you
hold down the real \fIControl\fP key, and click on the \fIC\fP key in
the window, a \fIControl-C\fP event will be generated.  (Assuming, that 
is, that your window manager does not intercept control-left-button for its 
own purposes.)

Clicking right on a key pops up a menu of commands for the given key.
They are:
.TP 4
.B Exchange Keys
After selecting this menu item, you are asked to click on another key.
That key and the key on which you brought up the menu will be exchanged.
This actually changes the current keyboard mapping.
.TP 4
.B Duplicate Key
After selecting this menu item, you are asked to click on another key.
That key will be made a copy of the key on which you brought up the menu.
That is, the two keys will generate the same set of keysyms and modifiers.
This actually changes the current keyboard mapping.
.TP 4
.B Disable Key
The key on which you brought up the menu will be made to generate no
keysyms and no modifiers.  This actually changes the current keyboard mapping.
.TP 4
.B Restore Key To Default
The key on which you brought up the menu will be restored to its default
state; no other key will be altered.  This actually changes the current
keyboard mapping.
.TP 4
.B Edit KeySyms of Key
This pops up the "Edit Key" window, which allows you to arbitrarily change
which keysyms and modifiers this key generates.

On the left side of the window is the list of the keysyms that this key
currently generates.  (A key may generate up to eight keysyms; the 
interpretation of these keysyms is described in the X protocol document,
and is summarized later in the \fBKEYSYMS AND KEYCODES\fP section of
this man page.)

The second column is a multiple-choice list of the eight modifier bits
that this key may generate.  For example, if you want a key to behave
as a ``control'' key, you should select the \fBControl\fP modifier.

The third and fourth column (the scrolling lists) are for changing the 
keysym associated with the key.  When you select a keysym-position from 
the first column, the character set and keysym will be displayed in
the scrolling lists.  Clicking on a keysym in the ``KeySym'' column will
install that keysym in the highlighted slot in the first column.

To select a keysym from a different character set, click on the character
set name in the second column.  (The \fBLatin1\fP and \fBKeyboard\fP
character sets are the most commonly used.)

At the bottom of the window are three buttons: \fBUndo\fP, \fBAbort\fP, 
and \fBOk\fP.  Clicking on \fBUndo\fP reverts the Edit Key window to the
current state of the key in question.  \fBAbort\fP closes the Edit Key
window without making any changes.  \fBOk\fP closes the Edit Key window
and installs your changes (the current keyboard mapping is modified.)
.SH X RESOURCES
\fIxkeycaps\fP understands all of the core resource names and classes 
as well as:
.TP 4
.B *Keyboard.keyboard\fP (class \fBKeyboard\fR)\fP
Which keyboard to display; this is the same as the \fB\-keyboard\fP 
command-line option.  If this is not specified, the default keyboard
is guessed, based on the server's vendor identification string.
.TP 4
.B *Keyboard.Keyboard.selectCursor\fP (class \fBCursor\fR)\fP
The cursor to use when selecting a key or window with the mouse.
The default is the \fIcrosshair\fP cursor.
.TP 4
.B *Keyboard.Key.highlight\fP (class \fBBackground\fR)\fP
The color to use to highlight a key when it is depressed.  If this is
the same as the background color of the key, it is highlighted with a
stipple pattern instead.
.TP 4
.B *Keyboard.Key.keycapColor\fP (class \fBForeground\fR)\fP
The color to paint the keycap string.
.TP 4
.B *Keyboard.Key.keycodeColor\fP (class \fBForeground\fR)\fP
The color to paint the keycode number.
.TP 4
.B *Keyboard.Key.borderColor\fP (class \fBColor\fR)\fP
The color of the box around each key.
.TP 4
.B *Keyboard.Key.keycapFont\fP (class \fBFont\fR)\fP
The font to use to draw the keycap string.
.TP 4
.B *Keyboard.Key.keycodeFont\fP (class \fBFont\fR)\fP
The font to use to draw the keycode number.
.TP 4
.B *Keyboard.Key.borderWidth\fP (class \fBInt\fR)\fP
The thickness of the box around each key.
.TP 4
.B *Keyboard.Key.gutterWidth\fP (class \fBInt\fR)\fP
How many pixels to leave between this key and it's neighbors to the right
and bottom.
.PP
The class of each key widget is ``Key,'' as you see above.  The name of
each key is the string(s) printed on its face.  So if you wanted (for example)
the \fBShift\fP keys to have wider borders, you could specify that with
.EX
xkeycaps*Keyboard.Shift.borderWidth: 2
.EE
.SH ACTIONS
It is possible to rebind the actions which happen when a key or mouse button
is pressed or released.  These actions are available on the \fBKeyboard\fP
widget:
.TP 4
.B "HighlightKey(\fIcondition\fP, \fIarg\fP)"
This places the key in question in the highlighted state.

If no \fIargument\fP is passed to this action, then the key is determined by
the event which invoked this action.  If this action is invoked by
a \fBKeyPress\fP or \fBKeyRelease\fP event, the key-widget is the key
corresponding to the key that the event represents.  If it is 
a \fBButtonPress\fP, \fBButtonRelease\fP, or \fBPointerMotion\fP event, 
then the key-widget is the one under the mouse.

The \fIargument\fP may be one of the words \fImouse\fP, \fIhighlighted\fP,
or \fIdisplayed\fP, meaning the key under the mouse, the key most recently
highlighted, or the key currently being described in the ``Info'' area
at the top of the window, respectively.

The \fIcondition\fP may be one of the words \fIifmod\fP, \fIunlessmod\fP,
\fIiftracking\fP, \fIunlesstracking\fP, \fIifhighlighted\fP, or 
\fIunlesshighlighted\fP.  If \fIifmod\fP was specified and the key in
question (as determined by the \fIargument\fP or by the invoking event) is 
not a modifier key, then this action is not executed.  The \fIunlessmod\fP 
condition is the opposite.  The \fIiftracking\fP and \fIunlesstracking\fP 
conditions allow you to do some actions only if (or unless) the key is 
being ``tracked'' with the mouse (see below.)  The \fIifhighlighted\fP
and \fIunlesshighlighted\fP actions allow you to do some things only if
(or unless) the key in question is currently in the highlighted state.
.TP 4
.B "UnhighlightKey(\fIcondition\fP, \fIarg\fP)"
This places the key in question in the unhighlighted state.  Arguments
are as above.
.TP 4
.B "ToggleKey(\fIcondition\fP, \fIarg\fP)"
This makes the key be highlighted if it is unhighlighted, or unhighlighted 
if it is highlighted.  Arguments are as above.
.TP 4
.B "SimulateKeyPress(\fIcondition\fP, \fIarg\fP)"
This action makes a \fBKeyPress\fP event corresponding to the key be
synthesized on the focus window.  Arguments are as above.
.TP 4
.B "SimulateKeyRelease(\fIcondition\fP, \fIarg\fP)"
This action makes a \fBKeyRelease\fP event corresponding to the key be
synthesized on the focus window.  Arguments are as above.
.TP 4
.B "TrackKey(\fIcondition\fP, \fIarg\fP)"
This makes the key in question begin being ``tracked'', which means that
moving the mouse off of it will simulate a button-release action, and then
will simulate a button-press action on the key that the mouse has moved
on to.  This action may only be invoked from a \fBButtonPress\fP
or \fBButtonRelease\fP event.
.TP 4
.B "UntrackKey(\fIcondition\fP, \fIarg\fP)"
This makes the key in question no longer be ``tracked.''
.TP 4
.B "DescribeKey(\fIcondition\fP, \fIarg\fP)"
This action causes the key and its bindings to be displayed in the ``Info''
section at the top of the window, if it is not already described there.
.PP
The default actions for the \fBKeyboard\fP widget are:
.EX
<Motion>:   DescribeKey(mouse,unlessTracking)      \\n\\
\\
<KeyDown>:  HighlightKey()                         \\
            DescribeKey(unlessMod)                 \\
            DescribeKey(displayed)                 \\
            SimulateKeyPress()                     \\n\\
\\
<KeyUp>:    UnhighlightKey()                       \\
            DescribeKey(displayed)                 \\
            SimulateKeyRelease()                   \\n\\
\\
<Btn1Down>: HighlightKey(unlessMod)                \\
            ToggleKey(ifMod)                       \\
            TrackKey(unlessMod)                    \\
            SimulateKeyPress(ifHighlighted)        \\
            SimulateKeyRelease(unlessHighlighted)  \\n\\
\\
<Btn1Up>:   UntrackKey(highlighted)                \\
            SimulateKeyRelease(highlighted,unlessMod) \\
            UnhighlightKey(highlighted,unlessMod)  \\n\\
\\
<Btn3Down>: XawPositionSimpleMenu(keyMenu)         \\
            MenuPopup(keyMenu)                     \\n
.EE
If you don't want a key to be described each time the mouse moves over
it, you can remove the \fB<Motion>\fP action.  In that case, you should
probably add \fBDescribeKey()\fP to the \fB<Btn1Down>\fP and \fB<KeyDown>\fP
actions.

If you want the key under the mouse to be described even while the mouse
is moving with a button down, then remove the \fIunlessTracking\fP
parameter from the \fBDescribeKey\fP action bound to \fB<Motion>\fP.

If you don't want the modifier keys to toggle, then change the \fBButton1\fP
actions to
.EX
xkeycaps*Keyboard.actions:  #override               \\
        <Btn1Down>: HighlightKey()                  \\
                    TrackKey(unlessmod)             \\
                    SimulateKeyPress()              \\n\\
        <Btn1Up>:   UntrackKey(highlighted)         \\
                    SimulateKeyRelease(highlighted) \\
                    UnhighlightKey(highlighted)     \\n
.EE
Remember that these actions exist on the \fIKeyboard\fP widget, not on
the \fIKey\fP widgets.  If you add actions to the \fIKey\fP widgets,
things will malfunction.
.SH KEYSYMS AND KEYCODES
The following description is from the X Protocol document, and is reprinted
here for your convenience:

.RS 4
A list of \fBKeySym\fPs is associated with each \fBKeyCode\fP.  If that 
list (ignoring trailing \fBNoSymbol\fP entries) is a single \fBKeySym\fP ``K'',
then the list is treated as if it were the 
list \fB``K NoSymbol K NoSymbol''\fP.  
If the list (ignoring trailing \fBNoSymbol\fP entries) is a pair 
of \fBKeySym\fPs ``K1 K2'', then the list is treated as if it were the 
list \fB``K1 K2 K1 K2''\fP.  If the list (ignoring trailing \fBNoSymbol\fP 
entries) is a triple of \fBKeySym\fPs \fB``K1 K2 K3''\fP, then the list
is treated as if it were the list \fB``K1 K2 K3 NoSymbol''\fP.

The first four elements of the list are split into two groups
of \fBKeySym\fPs.  Group 1 contains the first and second \fBKeySym\fPs, 
Group 2 contains third and fourth \fBKeySym\fPs.  Within each group, if the
second element of the group is \fBNoSymbol\fP, then the group should be
treated as if the second element were the same as the first element, except
when the first element is an alphabetic \fBKeySym\fP ``K'' for which both
lowercase and uppercase forms are defined.  In that case, the group should
be treated as if the first element were the lowercase form of ``K'' and the
second element were the uppercase form of ``K''.

The standard rules for obtaining a \fBKeySym\fP from a KeyPress event make
use of only the Group 1 and Group 2 \fBKeySym\fPs; no interpretation of
other \fBKeySym\fPs in the list is given here.  (That is, the last four
KeySyms are unused.)

Which group to use is determined by modifier state.  Switching
between groups is controlled by the \fBKeySym\fP named \fBMode_switch\fP.

By attaching that \fBKeySym\fP to some \fBKeyCode\fP and attaching 
that \fBKeyCode\fP to any one of the modifiers \fBMod1\fP 
through \fBMod5\fP.  This modifier is called the ``group modifier''.  
For any \fBKeyCode\fP, Group 1 is used when the group modifier is off, 
and Group 2 is used when the group modifier is on.

Within a group, which \fBKeySym\fP to use is also determined by
modifier state.  The first \fBKeySym\fP is used when the \fBShift\fP 
and \fBLock\fP modifiers are off.  The second \fBKeySym\fP is used when 
the \fBShift\fP modifier is on, or when the \fBLock\fP modifier is on 
and the second \fBKeySym\fP is uppercase alphabetic, or when the \fBLock\fP
modifier is on and is interpreted as \fBShiftLock\fP.  Otherwise,
when the \fBLock\fP modifier is on and is interpreted as \fBCapsLock\fP,
the state of the \fBShift\fP modifier is applied first to select
a \fBKeySym\fP, but if that \fBKeySym\fP is lowercase alphabetic, then 
the corresponding uppercase \fBKeySym\fP is used instead.
.RE
.SH THE MODIFIER MAPPING
The following description is from the InterClient Communications 
Conventions Manual:

.RS 4
X11 supports 8 modifier bits,  of which 3 are pre-assigned to \fBShift\fP,
\fBLock\fP and \fBControl\fP.  Each modifier bit is controlled by the state
of a set of keys, and these sets are specified in a table accessed by
\fBGetModifierMapping()\fP and \fBSetModifierMapping()\fP.

A client needing to use one of the pre-assigned modifiers should assume that
the modifier table has been set up correctly to control these modifiers.
The \fILock\fP modifier should be interpreted as \fICaps Lock\fP 
or \fIShift Lock\fP according as the keycodes in its controlling set
include \fBXK_Caps_Lock\fP or \fBXK_Shift_Lock\fP.

Clients should determine the meaning of a modifier bit from the keysyms
being used to control it.

A client needing to use an extra modifier,  for example \fIMeta\fP,  should:
.RS 2

Scan the existing modifier mappings.
If it finds a modifier that contains a keycode whose set of keysyms
includes \fBXK_Meta_L\fP or \fBXK_Meta_R\fP, it should use that modifier bit.

If there is no existing modifier controlled by \fBXK_Meta_L\fP 
or \fBXK_Meta_R\fP, it should select an unused modifier bit (one with an
empty controlling set) and:
.RS 2

If there is a keycode with \fBXL_Meta_L\fP in its set of keysyms, add that
keycode to the set for the chosen modifier, then

if there is a keycode with \fBXL_Meta_R\fP in its set of keysyms, add that
keycode to the set for the chosen modifier, then

if the controlling set is still empty,  interact with the user to
select one or more keys to be \fBMeta\fP.
.RE

If there are no unused modifier bits, ask the user to take corrective action.
.RE
.RE

This means that the \fBMod1\fP modifier does not necessarily mean \fIMeta\fP,
although some applications (such as \fItwm\fP and \fIemacs 18\fP) assume that.
Any of the five unassigned modifier bits could mean Meta; what matters is
that a modifier bit is generated by a keycode which is bound to the
keysym \fBMeta_L\fP or \fBMeta_R\fP.

Therefore, if you want to make a ``meta'' key, the right way is to make
the keycode in question generate both a \fBMeta\fP keysym, and some
previously-unassigned modifier bit.

.SH ENVIRONMENT
.PP
.TP 4
.B DISPLAY
to get the default host and display number.
.TP 4
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 4
.B XKEYSYMDB
to get the location of the \fBXKeysymDB\fP file, which lists the 
vendor-specific keysyms.  
.SH "SEE ALSO"
X(1),
xmodmap(1),
xset(1),
xdpyinfo(1)
.SH BUGS
Because this program has default colors that aren't "black" and "white",
the \fB\-rv\fP command-line option doesn't work.  But the incantation
.EX
% xkeycaps -fg white -bg black -bd white
.EE
will do what you want on a monochrome screen.

The NeXT default map is believed to be incorrect; someone with access to 
a NeXT will need to debug this.

I have a hard time believing the geometry specified for the HP 700 keyboard is
correct; I've never seen a keyboard which has one row directly below another,
they are always offset by roughly 1/7th of a key width.

There is no portable way to be sure what keyboard is being used; this means
it will often not default to the correct one, and if the user makes changes
to the keymap while displaying a keyboard which is not the right one, very
bad things can happen.

If you depress more than a dozen keys at a time, many X servers get confused,
and don't transmit enough \fBKeyRelease\fP events; the result of this is
that the \fIxkeycaps\fP keys will get ``stuck'' until they are pressed again.
(Don't go like that.)

The \fBAutoRepeat\fP flag is apparently useless on all X servers except the
OpenWindows one (I've never seen another server that didn't ignore it.)

You don't get to select from the set of \fBVendor\fP keysyms (those keysyms
which are defined in the \fBXKeysymDB\fP file) unless you're running X11r5
or newer.

NCD's non-US keyboards do not use the standard R4/R5 mechanism for attaching
more than two keysyms to one key; instead of simply having three or four 
keysyms attached to the keycode in question, the Compose key changes the
actual keycode of the key (it turns its high bit on.)  The xkeycaps program
doesn't really understand this.  Someone from NCD support told me that in
future releases they will do things the R4/R5 way instead of the way they
do things now, so hacking xkeycaps to understand the current behavior is 
probably not worth the effort.

The \fIType at Window\fP command doesn't seem to work on the WreckStation
version of XTerm.  I assume some variation of the normal XTerm's
\fIAllow SendEvents\fP command is necessary.

If the popup menu is always greyed out, or doesn't correspond to 
the key that you bring it up over, it's probably because you're 
running \fIxswarm\fP, an old version of \fIxautolock\fP, or some other 
program that antisocially interferes with event-propagation.  (Don't go
like that.)

Because of the nonlinear way in which this program uses \fBXLookupString\fP,
there's no sensible way for it to do compose processing, and show you the 
results of ``dead'' key or Multi_key sequences.

The output should be written to a file instead of to standard-output; but
the Athena widget set doesn't seem to come with a file-requestor widget,
and I don't want to write one.

It needs to know about more keyboard types (and no doubt always will...)

L-shaped keys aren't drawn accurately.  We should use the Shape extension
for that.

In addition to displaying the ASCII version of the given character, it
should display the corresponding character in the character set (Latin2,
Kana, Greek, etc.)  This would require having fonts for all of those 
character sets, though, and as far as I can tell, they don't all come
standard.

When running on a Sun and talking to an OpenWindows server, we should parse
the appropriate file from $OPENWINHOME/etc/keytables/ to determine the
default keymap.  No doubt there are system-specific ways of doing this in
other environments as well.

The HP C compiler complains about "invalid pointer initialization" in the
header files.  This is a bug in that compiler, not in xkeycaps.  This compiler
bug goes away if you invoke HP's cc with the the -Aa (ANSI) option.

The \fIxmodmap\fP program still sucks.  Since its \fIADD\fP and \fIREMOVE\fP
directives take keysyms as arguments instead of keycodes, there are things
that you can do with \fIXKeyCaps\fP that you can't represent in
an \fIxmodmap\fP script (at least, not without great pain.)

The \fIxmodmap\fP program has no commands for changing the autorepeat status
of keys, so that information is not written in the output.  Perhaps we could
write out an appropriate \fIxset\fP command instead.
.SH COPYRIGHT
Copyright \(co 1991-1993 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@lucid.com>, 10-nov-91.
Please let me know if you find any bugs or make any improvements.

Thanks to:
Eric Benson,
Markus Berndt,
Roger Binns,
black@westford.ccur.com,
Volker Bosch,
Dave Brooks,
Francois Regis Colin,
Michael Elbel,
Joe English,
Magnus Hammerin,
Tom Ivar Helbekkmo,
Hide Horiuchi,
Chris Jones,
Philippe Kipfer,
John Knox,
Simon Leinen,
Cliff Marcellus,
Tom McConnell,
Grant McDorman,
Jason Merrill,
Pekka Nikander,
Todd Nix,
Steven W. Orr,
Pavel Rosendorf,
Joerg Stippa,
Juergen Stuber,
Markus Stumpf,
Anthony Thyssen,
Gord Vreugdenhil,
Jan Wedekind,
Bj|rn Wennberg,
Mats Wichmann,
and
Carl Witty.
