#ifndef FILEMGR_H
#define FILEMGR_H

#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>

#include "../../configure.h"

#ifdef BROKEN_SUN_HEADERS
#include "../../fvwm/sun_headers.h"
#endif

#include "../../fvwm/xpm.h"

#define MIN_PIXMAP_WIDTH 65
#define MIN_PIXMAP_HEIGHT 20
#define VERT_PAD 2
#define HORIZ_PAD 5
#define EDGE_PAD 2
#define DOUBLE_CLICK_TIME 750

#define NUM_ONE_OP_CMDS 3
#define NUM_TWO_OP_CMDS 2
#define FIRST_TWO_OP_CMD "move"
#define SECOND_TWO_OP_CMD "copy"

typedef struct _XpmIcon 
{
  Pixmap pixmap;
  Pixmap mask;
  XpmAttributes attributes;
} XpmIcon;


struct filelist
{
  char *filename;
  char *type;
  char *command;     /* don't free this, its a pointer to the mapping struct*/
  mode_t st_mode;
  off_t size;
  char mode[11];
  struct filelist *nextfile;
  Pixmap icon;
  Pixmap icon_mask;
  int icon_w;
  int icon_h;
  int icon_x;         /* nominal location of the icon */
  int icon_y;
  int actual_x;       /* actual location of the pixmap */
  int actual_y;
  int label_x;        /* actual location of the label */
  int label_y;
  int icon_depth;
  Window IconWin;
  int LabelW;
  int CheckedOut;
  Window HoldingWin;
  Window LabelWin;
  char selected;
  char drawn_selected;
  char updated;
  int icon_loc_count;
};

struct mapping
{
  char *name;
  char *type;
  char *permissions;
  char *command;
  char *pixmap_file;
  struct mapping *next;
  Pixmap icon;
  Pixmap icon_mask;
  int icon_w;
  int icon_h;
  int icon_depth;
};

struct dir_win
{
  struct filelist *file_root;
  char *dir_name;
  int nfiles;
  int w;
  int h;
  int nx;
  Window main_win;
  Window open_win;
  Window size_win;
  Window two_op_win;
  Window one_op_win;
  int one_op_cmd;
  int two_op_cmd;
  int open_width;
  int open_x;
  Window top_win;
  struct dir_win *next;
  int pixmap_width;
  int pixmap_height;
  int frame_x;
  int frame_y;
  int frame_width;
  int frame_height;
  int icon_x;
  int icon_y;
  int icon_width;
  int icon_height;
  long stacking_order;
  long last_update_time;
  char open;
};

struct dir_win *create_dir_list(struct dir_win **dir_root,
				char *dirname,int all, 
				struct mapping *mapping_root);
void delete_filelist(struct dir_win *this_dir, struct dir_win **dir_list_root,
		     struct mapping *mapping_root);
struct mapping *read_config_file(void);
char *get_one_part(char *line, char *terminator,char **end);
int matchWildcards(char *pattern, char *string);
void find_icon(struct filelist *list, struct mapping *mapping_root);
void print_icon_bindings(struct mapping *root);
void LoadIcon(struct mapping *map);
char *findIconFile(char *icon, char *pathlist);
void GetBitmapFile(struct mapping *map);
void GetXPMFile(struct mapping *map);
Pixel GetShadow(Pixel background);
Pixel GetColor(char *name);
Pixel GetHilite(Pixel background);
void nocolor(char *a, char *b);
void change_window_name(Window w,char *str);
void CopyString(char **dest, char *source);
void ParseOptions(char *filename);
char *Cs3(char *a, char *b, char *c);
void CreateWindow(struct dir_win *dir);
void Loop(struct dir_win **list_root);
void CreateIconWindow(Window Parent,struct filelist *list);
void ConfigureIconWindow(struct filelist *list,int min_width, int min_height);
void FindWindows(Window win,struct dir_win *dir_root,
		 struct dir_win **dir, struct filelist **list);
void RedrawIcon(struct filelist *list, char *temp_name);
void ReconfigureWin(struct dir_win *dir,char force, int w, int h);
void OpenFile(struct dir_win *dir, struct filelist *list,
	      struct dir_win **dir_root, struct mapping *mapping_root,
	      char *newname);
void free_mapping(struct mapping *root);
char *ExpandDirName(char *dir);
void RenameFile(struct filelist *list, struct dir_win *dir, char *newname,
		struct dir_win **dir_root, int do_all, 
		struct mapping *mapping_root);
void ResizeIconWin(struct filelist *list, char *newname,int newwidth);
void initialize_X(void);
void Sort(struct dir_win *thisdir);
void refresh_dir_list(struct dir_win *thisdir,
		      struct dir_win **dir_root,
		      int do_all,
		      struct mapping *mapping_root);
int My_XNextEvent(Display *dpy, XEvent *event,struct dir_win **dir_root);
void process_message(unsigned long type,unsigned long *body, 
		     struct dir_win **dir_root);
void DeadPipe(int nonsense);
void RedrawWindow(struct dir_win *dir, char *newname);
void RelabelFile(struct dir_win *dir, char *newname);
void OpenNamedFile(char *name,struct dir_win **dir_root,
		   int do_all,struct mapping *mapping_root,
		   struct dir_win *thatdir);
struct mapping *matchup(struct mapping *mapping_root,char *name,
			     char *type,char *permissions);
void update_garbage_dir(struct dir_win *garbage_dir, int do_all);
void MoveIcon(struct dir_win *dir, struct filelist *filelist,XEvent *Event,
	      int select_x, int select_y);
void CheckOut(struct filelist *filelist, int x, int y);
void SendInfo(int *fd,char *message,unsigned long window);
void MoveToNewDir(struct dir_win *olddir, struct filelist *list,
		  struct dir_win *new_dir, struct dir_win **dir_root,
		  struct mapping *mapping_root);
void FindSpot(struct dir_win *dir,struct filelist *list,
	      int nx,int ny,int xcmax);
char *ExpandDollarsignFile(char *intext,char *key, char *replacement, 
			   int add_to_end);
void expand_mode(char *mode, long st_mode);
void AddToDir(struct filelist *list,struct dir_win *thisdir,
	      struct dir_win *olddir);
void RelabelCommands(struct dir_win *dir);
void LoadXThings(void);
#endif
