/* pmconfig.h -- 
 * Created: Tue May  2 14:37:06 1995 by r.faith@ieee.org
 * Revised: Sat May 13 10:16:32 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * $Id: pmconfig.h,v 1.1 1995/05/13 19:09:51 faith Exp $
 * 
 */

#ifndef _PMCONFIG_H_
#define _PMCONFIG_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* Many of these ifdef's are derived from GNU autoconf documentation. */

/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
# define alloca __builtin_alloca
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

/* Get string functions */
#if STDC_HEADERS
# include <string.h>
#else
# if HAVE_STRINGS_H
#  include <strings.h>
# endif
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif
# ifndef HAVE_STRDUP
char *strdup();
# endif

/* Get time functions */
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

/* Include some standard header files. */
#include <stdio.h>
#if HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
# if 1 || !(defined(__sparc__) && defined(DMALLOC_FUNC_CHECK))
#  include <stdlib.h>
# endif
#endif

/* Handle getopt correctly */
#if HAVE_GETOPT_H
# include <getopt.h>
#else
extern int  getopt( int, char **, char * );
extern int  optind;
extern char *optarg;
#endif

/* Provide major, minor, and makedev */
#ifdef MAJOR_IN_MKDEV
# include <sys/mkdev.h>
#else
# ifdef MAJOR_IN_SYSMACROS
#  include <sys/sysmacros.h>
# else
#  include <sys/types.h>
				/* Only include the following if necessary */
#  if 0
#  ifndef major
#   define major(d) (((unsigned)(d))>>8)
#  endif
#  ifndef minor
#   define minor(d) ((d)&0xff)
#  endif
#  ifndef makedev
#   define makedev(major,minor) (((major)<<8)|(minor))
#  endif
#  endif
# endif
#endif

/* Provide assert() */
#include <assert.h>

/* Provide ctype functions */
#include <ctype.h>

/* Provide passwd/group file functions */
#include <pwd.h>
#include <grp.h>

/* Get errno */
#include <errno.h>

/* Get stat */
#include <sys/stat.h>

#ifndef MAXPATHLEN
# if HAVE_SYS_PARAM_H
#  include <sys/param.h>
# endif
# ifdef PATH_MAX
#  define MAXPATHLEN PATH_MAX
# else
#  define MAXPATHLEN 1024
# endif
#endif

#ifndef RAND_MAX
# include <limits.h>
# define RAND_MAX INT_MAX
#endif

/* System dependent declarations: Many brain damaged systems don't provide
   declarations for standard library calls.  We provide them here for
   situations that we know about and occasionally use. */

#if defined(__sparc__)
extern char   *strdup( const char * );

extern int    _filbuf( FILE * );
extern int    _flsbuf( unsigned char, FILE * );
extern void   fclose( FILE * );
extern int    fflush( FILE * );
extern int    fprintf( FILE *, const char *, ... );
extern int    fputc( char, FILE * );
extern int    fputs( const char *, FILE * );
extern int    fread( void *, int, int, FILE * );
extern int    fwrite( void *, int, int, FILE * );
extern int    lstat(const char *, struct stat *);
extern void   *memmove( void *, const void *, size_t );
extern int    on_exit( void (*)(), caddr_t );
extern int    pclose( FILE * );
extern void   perror( const char * );
extern int    printf( const char *, ... );
extern long   random( void );
extern void   srandom( int );
extern char   *strerror( int );
extern int    strncmp( const char *, const char *, int );
extern long   strtol( const char *, char **, int );
extern int    toupper( int );
extern time_t time( time_t * );
extern int    unlink( const char * );
extern int    vfprintf( FILE *, const char *, ... );
extern int    vsprintf( char *, const char *, ... );
#endif				/* __sparc__ */

#if defined(__ultrix__) && defined(__MIPSEL__)
extern long random( void );
extern void srandom( int );
#endif

#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#endif
#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#endif
#ifndef BUFSIZ
#define BUFSIZ 1024
#endif
#define PM_BUFFERSIZE (10*BUFSIZ)

#endif
