/* pmdb_close.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_close.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to close the pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Mon Nov  6 12:05:46 1995 by hoffman
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: close.c,v $
 * Revision 1.3  1995/11/06 18:35:20  hoffman
 * pm package cache routines added.
 *
 * Revision 1.2  1995/10/28  01:20:38  faith
 * Performance analysis and improvements
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

extern int	PmdbDeleteCount;

/* =============== pmdb_close
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_close( void )
{
   int i;

   /* ----- flush any package record cache entres.
    */

   flush_pcache();
   
   /* ----- If there have been deletions compress the database.
    */
   
   if (PmdbDeleteCount > PMDB_DELETE_COUNT) {
      pmdb_reorganize();
      PmdbDeleteCount = 0;
   }

   for (i = 0; i < PMDB_FILE_COUNT; i++) {
      if (PMDBFile[i].gdbmFile) {
	 gdbm_close( PMDBFile[i].gdbmFile );
	 PMDBFile[i].gdbmFile = NULL;
      }
      if (PMDBFile[i].name) {
	 free( PMDBFile[i].name );
	 PMDBFile[i].name = NULL;
      }
   }
    
   return 0;
} /* end pmdb_close */
