/* pmdb_delete_package.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_delete_package.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: function to delete a package record from the pm database.
 * Created: Fri May 12 23:37:03 1995 by hoffman
 * Revised: Wed Nov  8 12:49:20 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: delete_pack.c,v $
 * Revision 1.5  1995/11/08 17:57:05  faith
 * Use PMDB_DISP_* consistently
 *
 * Revision 1.4  1995/10/28  01:20:41  faith
 * Performance analysis and improvements
 *
 * Revision 1.3  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

extern int	 PmdbDeleteCount;

/* =============== pmdb_delete_package
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_delete_package( const char *keyStr )
{
   int		i;
   
   datum	key;
   datum	fkey;
   datum	data;

   PMDBPackageRec	package;
   
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_FILES].gdbmFile == NULL) return -1;

   /* ----- get key string */

   key.dsize = strlen( keyStr);
   key.dptr  = (char *)keyStr;

   /* ---------- Read the record and delete any associated file recs
    *
    *  All file records not marked as "I" (installed) are ignored. Others
    *  are deleted from the PMDBFile.files file. The ancillary record is
    *  also deleted from the PMDBFile.ancillary file.
    */

   data = gdbm_fetch( PMDBFile[PMDB_PACKAGES].gdbmFile, key);
   if (data.dptr == NULL) return -2;

   unpack_package_record( keyStr, &data, &package);

   for (i=0; i<package.count; i++) {
      if (package.disp[i][0] == PMDB_DISP_INSTALLED) { /* delete file recs */
	 fkey.dptr  = (char *)package.file[i];
	 fkey.dsize = strlen( package.file[i]);
	 gdbm_delete( PMDBFile[PMDB_FILES].gdbmFile, fkey);
      }
   }
   pmdb_free_package_rec( &package);
   free( data.dptr);
      
   gdbm_delete( PMDBFile[PMDB_ANCILLARY].gdbmFile, key);
   gdbm_delete( PMDBFile[PMDB_PACKAGES].gdbmFile,  key);
   
   return 0;
} /* end pmdb_delete_package */

