/* pmdb_free_file_rec.c, Copyright (c) 1995, RedHat Software.
 * 
 * Program: pmdb_free_file_rec.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to free a PMDBRecord.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Sat May 13 15:01:33 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: free_file_rec.c,v $
 * Revision 1.2  1995/05/13 20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_free_file_rec
 *
 *  Function to free the contents of a PMDBFileRec.
 *
 */

int pmdb_free_file_rec( PMDBFileRec *record )
{
   int		i;
   
   /* ----- Make sure the record is there */

   if (record == NULL) return -3;


   /* ----- free the strings pointed to by the data record
    *
    */

   for (i=0; i<PMDB_FR_ENTRIES; i++) {
      if (NULL != record->field[i]) free( (char *)record->field[i]);
   }
   
   return 0;
} /* end pmdb_free_file_rec */

