/* pmdb_open.c, Copyright (c) 1995, RedHat Software
 * 
 * Program: pmdb_open.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to open the pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Mon Nov  6 12:15:11 1995 by hoffman
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: open.c,v $
 * Revision 1.6  1995/11/06 18:35:21  hoffman
 * pm package cache routines added.
 *
 * Revision 1.5  1995/10/28  01:20:44  faith
 * Performance analysis and improvements
 *
 * Revision 1.4  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.3  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.2  1995/05/13  18:06:59  hoffman
 * PM database library for RedHat Software.
 *
 * Revision 1.1  1995/05/04  17:21:17  hoffman
 * Initial revision
 *
 * 
 */

#define PMDB_MAIN
#include "pmdb.h"

/* =============== pmdb_open
 *
 *  Function to open the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_open( const char *path, const int flags)
{
   int        i, j;
   GDBM_FILE  gdbmFile;
   const char *defaultName;
   char       *fname;

   for (i = 0; i < PMDB_FILE_COUNT; i++) {
      switch (i) {
      case PMDB_FILES:     defaultName = PMDB_FILES_NAME;     break;
      case PMDB_PACKAGES:  defaultName = PMDB_PACKAGES_NAME;  break;
      case PMDB_ANCILLARY: defaultName = PMDB_ANCILLARY_NAME; break;
      default:			/* This can't happen */
	 fprintf( stderr, "Internal error in pmdb_open\n" );
	 exit( 2 );
      }
      if (!path || !*path) j = strlen( PMDB_DEFAULT_PATH );
      else                 j = strlen( path );
      fname = malloc( j + strlen( defaultName ) + 2 );
      if (!path || !*path) strcpy( fname, PMDB_DEFAULT_PATH );
      else                 strcpy( fname, path );
      strcat( fname, defaultName );
   
      if (NULL == (gdbmFile = gdbm_open( fname,
					 PMDB_BLOCK_SIZE,
					 flags,
					 0,
					 PMDB_FATAL_FUNC))) {
	 fprintf( stderr,"pmdb_open: opening %s: %s\n",
		  fname, strerror(errno));
	 free( fname);
	 for (j = 0; j < i; j++) {
	    free( PMDBFile[j].name );
	    gdbm_close( PMDBFile[j].gdbmFile );
	 }
	 return errno;
      }
      PMDBFile[i].gdbmFile = gdbmFile;
      PMDBFile[i].name     = fname;
   }

   /* ----- Make sure the package cache is initialized.
    */
   init_pcache();

   /* ----------- return
    */
      
   return 0;
} /* end pmdb_open */
