/* pmdb_read_ancil.c, Copyright (c) 1995, RedHat Software.
 * 
 * Program: pmdb_read_ancil.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: function to read the pm ancillary database file.
 * Created: Thu May 11 15:57:15 1995 by hoffman
 * Revised: Wed Oct 25 23:19:37 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: read_ancil.c,v $
 * Revision 1.3  1995/10/28 01:20:46  faith
 * Performance analysis and improvements
 *
 * Revision 1.2  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_read_ancil
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_read_ancil( const char *keyStr, PMDBAncilRec *record)
{
   datum	data;
   datum	key;
      
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_ANCILLARY].gdbmFile == NULL) return -1;

   if (keyStr == NULL) return -2;
   if (record == NULL) return -3;

   /* ----- get key string */

   key.dsize = strlen( keyStr);
   key.dptr  = (char *)keyStr;
   
   /* ---------- get (read) the data
    *
    */
   data = gdbm_fetch( PMDBFile[PMDB_ANCILLARY].gdbmFile, key);
   if (NULL == data.dptr) {
      return gdbm_errno;
   }

   /* ----- unpack the data record into the user provied record struct.
    *
    *  The individual strings that make up the data segment of the db record
    *  are unpacked and strduped into the user provided PMDBRecord.
    */

   unpack_ancil_record( keyStr, &data, record);
   
   /* ----- clean up and exit
    */

   free( data.dptr);
    
   return 0;
} /* end pmdb_read_ancil */

