/* pmdb_read_first_file.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_read_first_file.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: function to read the first file record in a pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Wed Nov  1 14:16:21 1995 by hoffman
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: read_first_f.c,v $
 * Revision 1.3  1995/11/06 18:35:25  hoffman
 * pm package cache routines added.
 *
 * Revision 1.2  1995/10/28  01:20:48  faith
 * Performance analysis and improvements
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* ---------- shared variable to hold previous key
 *
 */

datum	PmdbLastFileKey;


/* =============== pmdb_read_first_file
 *
 *  Function to read the first file record in the pmdb
 *  database system. 
 *
 */

int pmdb_read_first_file( PMDBFileRec *record )
{
   datum	data;
   datum	key;

   char		*s;
      
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_FILES].gdbmFile == NULL) return -1;

   if (record == NULL) return -3;

   /* ---------- get (read) the data
    *
    *  This call reads the first sequential record from the files database.
    *  Note that the pmdb version stamp record is excluded -- if it is read
    *  it is discarded and the next record read. This is to prevent confusion
    *  on the part of the user.
    *
    */

   key = gdbm_firstkey( PMDBFile[PMDB_FILES].gdbmFile);
   if (NULL == key.dptr) {
      return 1;
   }


   s = malloc( key.dsize + 1);	/* fileName (key) */
   (void) strncpy( s, key.dptr, key.dsize);
   s[key.dsize] = '\0';

   if (0 == strcmp( s, PMDB_VERSION_KEY)) {
      free( s);
      free( key.dptr); 
      key = gdbm_nextkey( PMDBFile[PMDB_FILES].gdbmFile, key);
      if (NULL == key.dptr) {
	 return 1;
      }
      /* --- found non-version stamp first record */
      s = malloc( key.dsize + 1);	/* fileName (key) */
      (void) strncpy( s, key.dptr, key.dsize);
      s = '\0';
   }
   
   /* ---------- get (read) the data
    *
    */
   data = gdbm_fetch( PMDBFile[PMDB_FILES].gdbmFile, key);
   if (NULL == data.dptr) {
      return gdbm_errno;
   }


   /* ----- save the old key for subsequent read_next calls
    */

   PmdbLastFileKey.dsize = key.dsize;
   PmdbLastFileKey.dptr  = key.dptr;
	 

   /* ----- unpack the data record into the user provied record struct.
    *
    *  The individual strings that make up the data segment of the db record
    *  are unpacked and strduped into the user provided PMDBRecord.
    */
 
   unpack_file_record( s, &data, record);
		
   /* ----- clean up and exit
    */

   free( data.dptr);
   
   return 0;
} /* end pmdb_read_first_file */

