/* pmdb_read_first_package.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_read_first_package.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: function to read the first file record in a pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Wed Oct 25 23:19:38 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: read_first_p.c,v $
 * Revision 1.3  1995/10/28 01:20:49  faith
 * Performance analysis and improvements
 *
 * Revision 1.2  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* ---------- shared variable to hold previous key
 *
 */

datum	PmdbLastPackageKey;


/* =============== pmdb_read_first_package
 *
 *  Function to read the first package record in the pmdb
 *  database system. 
 *
 */

int pmdb_read_first_package( PMDBPackageRec *record )
{
   datum	data;
   datum	key;

   char		*s;
      
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_PACKAGES].gdbmFile == NULL) return -1;

   if (record == NULL) return -3;

   /* ---------- get (read) the data
    *
    *  This call reads the first sequential record from the packages database.
    *  Note that the pmdb version stamp record is excluded -- if it is read
    *  it is discarded and the next record read. This is to prevent confusion
    *  on the part of the user.
    *
    */

   key = gdbm_firstkey( PMDBFile[PMDB_PACKAGES].gdbmFile);
   if (NULL == key.dptr) {
      return 1;
   }


   s = malloc( key.dsize + 1);	/* fileName (key) */
   (void) strncpy( s, key.dptr, key.dsize);
   s[key.dsize] = '\0';

   if (0 == strcmp( s, PMDB_VERSION_KEY)) {
      free( s);
      free( key.dptr);
      key = gdbm_nextkey( PMDBFile[PMDB_PACKAGES].gdbmFile, key);
      if (NULL == key.dptr) {
	 return 1;
      }
      /* --- found non-version stamp first record */
      s = malloc( key.dsize + 1);	/* packages name (key) */
      (void) strncpy( s, key.dptr, key.dsize);
      s = '\0';
   }
   
   /* ---------- get (read) the data
    *
    */
   data = gdbm_fetch( PMDBFile[PMDB_PACKAGES].gdbmFile, key);
   if (NULL == data.dptr) {
      return gdbm_errno;
   }


   /* ----- save the old key for subsequent read_next calls
    */

   PmdbLastPackageKey.dsize = key.dsize;
   PmdbLastPackageKey.dptr  = key.dptr;
	 

   /* ----- unpack the data record into the user provied record struct.
    *
    *  The individual strings that make up the data segment of the db record
    *  are unpacked and strduped into the user provided PMDBPackageRec.
    */
 
   unpack_package_record( s, &data, record);
		
   /* ----- clean up and exit
    */

   free( s );
   free( data.dptr);
   
   return 0;
} /* end pmdb_read_first_package */

