/* pmdb_read_version.c, Copyright (c) 1995, RedHAt Software
 * 
 * Program: pmdb_read_version.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to lock the pm database.
 * Created: Tue May  9 12:56:34 1995 by hoffman
 * Revised: Wed Oct 25 23:21:27 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: read_version.c,v $
 * Revision 1.2  1995/10/28 01:20:52  faith
 * Performance analysis and improvements
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_read_version
 *
 *  Function to read the verson stamp from a pmdb database. The database
 *  must have been previously opened with pmdb_open.
 *
 */

char *pmdb_read_version( void)
{
   datum	data;
   datum	key;

   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_FILES].gdbmFile == NULL) return NULL;

   /* ----- get key string */

   key.dptr  = (char *) PMDB_VERSION_KEY;
   key.dsize = strlen( key.dptr);
   
   /* ----- get (read) the data
    *
    */

   data = gdbm_fetch( PMDBFile[PMDB_FILES].gdbmFile, key);
   
   return data.dptr;
} /* end pmdb_read */

