/* pmdb_utils.c, Copyright (c) 1995, RedHat Software.
 * 
 * Program: pmdb_utils.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to lock the pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Wed Nov  8 12:55:02 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: utils.c,v $
 * Revision 1.5  1995/11/08 17:57:08  faith
 * Use PMDB_DISP_* consistently
 *
 * Revision 1.4  1995/10/28  01:20:54  faith
 * Performance analysis and improvements
 *
 * Revision 1.3  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_utils
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int match_file( const char *file, const char *path)
{
   char *s;

   if (NULL != (s = rindex( path, '/'))) {
      s++;
      if (0 == strcmp( file, s))
	    return 1;
   }
   return 0;
} /* end match_file */

void unpack_file_record( const char *key, datum *data, PMDBFileRec *record)
{
   int		i;
   char		*ptr;
   
   record->field[PMDB_FR_KEY] = strdup( key);
 
   ptr = data->dptr;
   for (i=1; i<PMDB_FR_ENTRIES; i++) {
      record->field[i] = strdup( ptr);
      ptr += strlen( record->field[i]) + 1;
   }
   
   return;
} /* end unpack_file_record */

void pack_file_record( PMDBFileRec *record, datum *data)
{
   int		i;
   int		size = 0;
   char		*ptr;
   char		*buffer;
   
   for (i=1; i<PMDB_FR_ENTRIES; i++)
	 size += strlen(record->field[i]) + 1;

   ptr = malloc( size);
   buffer = ptr;
   
   for (i=1; i<PMDB_FR_ENTRIES; i++) {
      strcpy( ptr, record->field[i]);
      ptr +=  strlen( record->field[i]) + 1;
   }
   
   /* ----- setup the data array */

   data->dsize = size;
   data->dptr  = buffer;

   
   return;
} /* end pack_file_record */

void unpack_package_record( const char *key,
			    datum *data, PMDBPackageRec *record)
{
   int		i;
   int		j;
   int		size;
   char		*ptr;

   record->field[PMDB_PR_KEY] = strdup( key);
   
   ptr  = data->dptr;
   size = 0;
   for (i=1; i<PMDB_PR_ENTRIES; i++) {
      record->field[i] = strdup( ptr);
      j = strlen( record->field[i]) + 1;
      size += j;
      ptr  += j;
   }

   record->count   = 0;
   record->entries = 0;
   record->file    = NULL;
   record->disp    = NULL;
   if (size < data->dsize) {
      i = 0;
      while (size < data->dsize) {
	 if (i >= record->entries) {
	    if (record->entries) record->entries *= 2;
	    else                 record->entries = 2;
	    record->file = realloc( record->file,
				    (record->entries+1)*sizeof(char*));
	    record->disp = realloc( record->disp,
				    (record->entries+1)*sizeof(char*));
	 }
	 record->file[i] = strdup( ptr);
	 j = strlen( record->file[i]) + 1;
	 size += j;
	 ptr  += j;
	 record->disp[i] = strdup( ptr);
	 j = strlen( record->disp[i]) + 1;
	 size += j;
	 ptr  += j;
	 i++;
      }	
      record->count = i; 
   }

   return;
} /* end unpack_package_record */

void pack_package_record( PMDBPackageRec *record, datum *data)
{
   int		i;
   int		size = 0;
   char		*ptr;
   const char   *pt;
   char		*buffer;

   /* --- first get the size */
   
   for (i=1; i<PMDB_PR_ENTRIES; i++)
	 size += strlen(record->field[i]) + 1;

   if (record->count > 0) {
      for (i=0; i<record->count; i++) {
	 size += strlen(record->file[i]) + 1;
	 size += strlen(record->disp[i]) + 1;
      }
   }

   /* --- allocate storage and copy the data */
   
   buffer = malloc( size);
   ptr = buffer;

   for (i=1; i<PMDB_PR_ENTRIES; i++) {
#if 0
      strcpy( ptr, record->field[i]);
      ptr +=  strlen( record->field[i]) + 1;
#else
      for (pt = record->field[i]; *pt; *ptr++ = *pt++);
      *ptr++ = '\0';
#endif
   }
   
   if (record->count > 0) {
      for (i=0; i<record->count; i++) {
#if 0
	 strcpy( ptr, record->file[i]);
	 ptr +=  strlen( record->file[i]) + 1;
	 strcpy( ptr, record->disp[i]);
	 ptr +=  strlen( record->disp[i]) + 1;
#else
	 for (pt = record->file[i]; *pt; *ptr++ = *pt++);
	 *ptr++ = '\0';
	 for (pt = record->disp[i]; *pt; *ptr++ = *pt++);
	 *ptr++ = '\0';
#endif
      }
   }
   
   /* ----- setup the data array */

   data->dsize = size;
   data->dptr  = buffer;

   
   return;
} /* end pack_package_record */

void unpack_ancil_record( const char *keyStr,
			  datum *data, PMDBAncilRec *record)
{
   int		i;
   int		j;
   int		size = 0;
   char		*ptr;

   /* ----- unpack ancillary data record
    *
    *  The ancillary record is just a set of type/field pairs.
    */

   record->key     = strdup( keyStr);
   record->count   = 0;
   record->entries = 0;
   record->type    = NULL;
   record->field   = NULL;
   if (size < data->dsize) {
      i = 0;
      ptr = data->dptr;
      while (size < data->dsize) {
	 if (i >= record->entries) {
	    if (record->entries) record->entries *= 2;
	    else                 record->entries = 2;
	    record->type  = realloc( record->type,
				     (record->entries+1)*sizeof(char*));
	    record->field = realloc( record->field,
				     (record->entries+1)*sizeof(char*));
	 }
	 record->type[i] = strdup( ptr);
	 j = strlen( record->type[i]) + 1;
	 size += j;
	 ptr  += j;
	 record->field[i] = strdup( ptr);
	 j = strlen( record->field[i]) + 1;
	 size += j;
	 ptr  += j;
	 i++;
      }	
      record->count = i; 
   }

   return;
} /* end unpack_ancil_record */

void pack_ancil_record( PMDBAncilRec *record, datum *data)
{
   int		i;
   int		size = 0;
   char		*ptr;
   char		*buffer;

   /* --- first get the size */

   if (record->count > 0) {
      for (i=0; i<record->count; i++) {
	 size += strlen(record->type[i]) + 1;
	 size += strlen(record->field[i]) + 1;
      }
   }
   else {
      data->dptr  = NULL;
      data->dsize = 0;
      return;
   }

   /* --- allocate storage and copy the data */
   
   buffer = malloc( size);
   ptr = buffer;
 
   for (i=0; i<record->count; i++) {
      strcpy( ptr, record->type[i]);
      ptr +=  strlen( record->type[i]) + 1;
      strcpy( ptr, record->field[i]);
      ptr +=  strlen( record->field[i]) + 1;
   }
   
   /* ----- setup the data array */

   data->dsize = size;
   data->dptr  = buffer;

   return;
} /* end pack_ancil_record */

void add_file_to_package( const char *fileName, PMDBPackageRec *package)
{
   int		i;
   
   if (fileName == NULL) return;

   i = package->count + 1;
   if (i >= package->entries) {
      if (package->entries) package->entries *= 2;
      else                  package->entries = i + 2;
      package->file = realloc( package->file,
			       (package->entries+1) * sizeof(char *));
      package->disp = realloc( package->disp,
			       (package->entries+1) * sizeof(char *));
   }
   
   package->file[i-1] = strdup( fileName);
   package->disp[i-1] = malloc( 2 );
   package->disp[i-1][0] = PMDB_DISP_INSTALLED;
   package->disp[i-1][1] = '\0';
   
   package->count = i;
   return;	 
} /* end add_file_to_package */

/* ---------- mark_file_in_package
 *
 *  This function checks for the existance of a file pointer in the
 *  file/disp list of a PMDBPackageRec and updates its disp if needed.
 *  It returns the following codes:
 *
 *       -1 = file name not found in list.
 *        0 = file found and disp does not need updating.
 *        1 = file found and disp changed (PMDBPackageRec needs to be
 *            rewritten to the packages file).
 */

int mark_file_in_package( const char *fileName,
			  PMDBPackageRec *package, char mark)
{
   int		i;
   
   if (fileName == NULL) return -1;

   for (i=0; i<package->count; i++) {
      if (0 == strcmp(package->file[i], fileName)) {
	 if (package->disp[i][0] == mark) {
	    return 0;
	 }
	 free( (char *)package->disp[i]);	/* out with the old and */
	 package->disp[i] = malloc( 2 );
	 package->disp[i][0] = mark;
	 package->disp[i][1] = '\0';
	 return 1;				/* in with the new.     */
      }
   }
   return -1;	 
} /* mark_file_in_package */

/* end pmdb_utils */
