/* pmdb_write_package.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_write_package.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to write file records to the pm database.
 * Created: Thu May 11 18:56:09 1995 by hoffman
 * Revised: Wed Oct 25 23:19:38 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: write_pack.c,v $
 * Revision 1.3  1995/10/28 01:20:59  faith
 * Performance analysis and improvements
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_write_package
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_write_package( PMDBPackageRec *record )
{
   datum	data;
   datum	key;

   int		i;
   
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_PACKAGES].gdbmFile == NULL) return -1;

   /* ----- get key string */

   if ((record->field[PMDB_FR_KEY] == NULL) ||
       (0 == (i = strlen( record->field[PMDB_PR_KEY])))) return -2;

   key.dsize = i;
   key.dptr  = (char *)record->field[PMDB_PR_KEY];
   
   /* ----- setup the data array
    *
    *  The data fields from 1 to PMDB_PR_ENTRIES are packed into the data
    *  record. Make sure every things is initialized or segfaults will
    *  happen!
    */

   pack_package_record( record, &data);

   /* ----- put (write) the data
    *
    *  this requires two operations, well three. First is to write to the
    *  primary data file. Second, the index file is read using field 1,
    *  packageName, as a key.  The filename is then added to the record and
    *  it is writen to the index file.
    */

   if (0 != (gdbm_store( PMDBFile[PMDB_PACKAGES].gdbmFile,
			 key, data, GDBM_REPLACE))) {
      return gdbm_errno;
   }

   free( data.dptr);
   
   return 0;
} /* end pmdb_write_package */

