/* debug.c -- Debugging support
 * Created: Wed May  3 13:49:10 1995 by r.faith@ieee.org
 * Revised: Wed Oct 25 15:50:59 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: debug.c,v 1.2 1995/10/28 01:21:06 faith Exp $
 * 
 */

#include "pmlib.h"

unsigned int pm_debug_flags = 0;

#define T(name,new) else if (!strcmp( flag, name )) pm_debug_flags |= new

void pm_debug( const char *flag )
{
   if (!strcmp( flag, "none" )) pm_debug_flags = 0;
   T( "all",      ~0 );
   T( "verbose",  PM_VERBOSE );
   T( "tar",      PM_TAR );
   T( "config",   PM_CONFIG );
   T( "notes",    PM_NOTES );
   T( "file",     PM_FILE );
   T( "search",   PM_SEARCH );
   T( "exec",     PM_EXEC );
   T( "child",    PM_CHILD );
   T( "nochroot", PM_NOCHROOT );
   T( "install",  PM_INSTALL );
   T( "stderr",   PM_STDERR );
   T( "db",       PM_DB );
   T( "time",     PM_TIME );
   T( "debug",    PM_DEBUG );
   T( "never",    PM_NEVER );
   else
      pm_fatal( PMERR_INVDBFLG, "%s\n", flag );
}
