/* gen.c -- Generate filenames
 * Created: Mon May  8 14:36:29 1995 by r.faith@ieee.org
 * Revised: Mon May  8 15:01:01 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: gen.c,v 1.1 1995/05/13 19:07:13 faith Exp $
 * 
 */

#include "pmlib.h"

/* Make a canonical name for the %doc subdirectory.  Note that, unlike most
   other calls, this returns a pointer to a static buffer that does not have
   to be freed but that will be overwritten by the next call to this
   function. */

const char *pm_gen_canonical( const char *subName )
{
   static char buffer[MAXPATHLEN];

   strcpy( buffer, PmPkgName ?: "unknown" );
   strcat( buffer, "-" );
   strcat( buffer, PmPkgVersion ?: "unknown" );
   if (PmPkgRelease && *PmPkgRelease) {
      strcat( buffer, "-" );
      strcat( buffer, PmPkgRelease );
   }
   if (subName && *subName) {
      strcat( buffer, "-" );
      strcat( buffer, subName );
   }
   return buffer;
}

const char *pm_gen_notespath( const char *subName )
{
   static char buffer[MAXPATHLEN];
   char        filename[MAXPATHLEN];
   const char  *path;

   strcpy( filename, pm_gen_canonical( subName ) );
   if (PmNotesExt) strcat( filename, PmNotesExt );

   path = pm_file_path( 3, PmDBDir, PmDistribution, filename );
   
   strcpy( buffer, path );
   xfree( (char *)path );
   return buffer;
}
