/* notes-copy.c -- Support for copying a notes file to the /var tree
 * Created: Mon May  8 15:08:28 1995 by r.faith@ieee.org
 * Revised: Sat May 13 23:59:57 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: notes-copy.c,v 1.2 1995/05/14 07:41:07 faith Exp $
 * 
 */

#include "pmlib.h"
#include "notes.h"

void pm_notes_copy( List list, List files, const char *subName )
{
   const char *path = pm_gen_notespath( subName );
   FILE       *str;
   int        copy = 1;

   static int copy_notes( const char *line )
      {
	 Macros *m;

	 if ((m = pm_find_macro( line, NULL, NULL ))) {
	    if (m->type == Sect && (m->stage & PM_DISTFILES)) copy = 0;
	    else                                              copy = 1;
	    if (m->type == Var || m->type == Ftp) return 0;
	 }
	 if (copy) fprintf( str, "%s\n", line );
	 return 0;
      }

   static int insert_files( const char *filename )
      {
	 PmEntry entry = pm_entry_create( filename );

	 PRINTF(PM_NOTES,("Making entry for %s\n",entry->name));

	 pm_entry_write( str, entry );
	 pm_entry_free( entry );
	 return 0;
      }

   pm_entry_init();
   
   str = pm_file_create( path );
   pm_notes_header( str, subName );
   pm_list_iterate( list, copy_notes );
   
				/* If %distfiles changes, update notes.c !!! */
   fprintf( str, "%%distfiles %s\n", subName );
   pm_list_iterate( files, insert_files );
   fclose( str );

   pm_entry_shutdown();
}
