/* notes.h -- Header for notes file manipulation routines
 * Created: Mon May  8 14:44:46 1995 by r.faith@ieee.org
 * Revised: Sat Jan  6 17:21:06 1996 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: notes.h,v 1.4 1996/01/07 02:05:32 faith Exp $
 * 
 */

typedef enum { Var, Ftp, Sect, Macro } Types;

typedef struct Macros {
   const char   *name;
   int          required;
   Types        type;
   int          export;
   const char   **var;
   unsigned int stage;
   void         (*script)( struct Macros *m, const char *line, FILE *str );
   void         (*files)( struct Macros *m, const char *line, List list );
   const char   *suffix;
   int          max;
   int          cd;
} Macros;

extern void   pm_macro_setup( Macros *m, const char *line, FILE *str );
extern void   pm_macro_patch( Macros *m, const char *line, FILE *str );
extern void   pm_macro_doc( Macros *m, const char *line, FILE *str );
extern void   pm_macro_addinfo( Macros *m, const char *line, FILE *str );
extern void   pm_macro_delinfo( Macros *m, const char *line, FILE *str );
extern void   pm_macro_addline( Macros *m, const char *line, FILE *str );
extern void   pm_macro_delline( Macros *m, const char *line, FILE *str );

extern void   pm_macro_config( Macros *m, const char *line, List list );
extern void   pm_macro_doc_files( Macros *m, const char *line, List list );

extern Macros *pm_find_macro( const char *line, int *length, int *idx );

extern Macros macros[];
