/* notestest.c -- Test for notes file reader
 * Created: Thu May  4 10:09:03 1995 by r.faith@ieee.org
 * Revised: Sun May 14 14:27:57 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: notestest.c,v 1.3 1995/08/12 21:43:21 faith Exp $
 * 
 */

#include "pmlib.h"
#include <sys/fcntl.h>

const char *PgmName    = "NotesTest";
const char *PgmVersion = "$Revision: 1.3 $";

static int print( const char *filename )
{
   printf( "%s\n", filename );
   return 0;
}

static void printer( const char *line )
{
   printf( "%s\n", line );
}

int main( int argc, char **argv )
{
   List list = pm_notes_read( "notes.tmp" );
   List files;
   int fd;

   pm_debug( "config" );
   pm_debug( "notes" );
   pm_debug( "file" );
   pm_debug( "verbose" );
   
   pm_config( NULL );

   if ((fd = open( "tmp.tar.gz", O_RDONLY )) < 0)
      pm_fatal( PMERR_READOPEN, "%s\n", "tmp.tar.gz" );

   pm_untar( "tmp.tar.gz", fd, 1, printer );

   pm_notes_parse( list );
   pm_notes_header( stdout, NULL );
   pm_notes_script( list, PM_BUILD, "/tmp/tmp.test", NULL );

   files = pm_notes_files( list, NULL );
   pm_list_iterate( files, print );
   pm_list_free( files );
   
   pm_notes_free( list );
   pm_shutdown();
   
   return 0;
}
