/* sys.c -- Encapsulate system calls
 * Created: Sun May  7 08:42:05 1995 by r.faith@ieee.org
 * Revised: Sun May 14 01:57:22 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: sys.c,v 1.2 1995/05/14 07:41:07 faith Exp $
 * 
 */

#include "pmlib.h"

int pm_chmod( const char *path, mode_t mode )
{
   if (mode) {			/* Symlinks have mode 0 */
      if (TEST(PM_DEBUG)) printf( "chmod( %s, %04o )\n", path, mode );
      else                return chmod( path, mode );
   }
   return 0;
}

int pm_chown( const char *path, uid_t owner, gid_t group )
{
   if (TEST(PM_DEBUG)) printf( "chown( %s, %d, %d )\n", path, owner, group );
   else                return chown( path, owner, group );
   return 0;
}

int pm_symlink( const char *oldpath, const char *newpath )
{
   if (TEST(PM_DEBUG)) printf( "symlink( %s, %s )\n", oldpath, newpath );
   else                return symlink( oldpath, newpath );
   return 0;
}

int pm_rename( const char *oldpath, const char *newpath )
{
   pm_unlink( newpath );
   if (TEST(PM_DEBUG)) printf( "rename( %s, %s )\n", oldpath, newpath );
   else                return rename( oldpath, newpath );
   return 0;
}

int pm_unlink( const char *path )
{
   if (TEST(PM_DEBUG)) printf( "unlink( %s )\n", path );
   else                return unlink( path );
   return 0;
}

int pm_mkdir( const char *path, mode_t mode )
{
   if (TEST(PM_DEBUG)) printf( "mkdir( %s, %04o )\n", path, mode );
   else                return mkdir( path, mode );
   return 0;
}

int pm_rmdir( const char *path )
{
   if (TEST(PM_DEBUG)) printf( "rmdir( %s )\n", path );
   else                return rmdir( path );
   return 0;
}

int pm_umask( int mask )
{
   if (TEST(PM_DEBUG)) printf( "umask( %04o )\n", mask );
   else                return umask( mask );
   return 0;
}
