/* timer.c -- Perform milisecond timings
 * Created: Wed Oct 25 15:33:20 1995 by r.faith@ieee.org
 * Revised: Wed Oct 25 15:59:03 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: timer.c,v 1.1 1995/10/28 01:21:10 faith Exp $
 * 
 */

#include "pmlib.h"

#define DIFFTIME(now,then)\
   (((now).tv_sec - (then).tv_sec) * 1000000 + (now).tv_usec - (then).tv_usec)

static struct timeval initial;
static struct timeval reference;

void pm_reset_timer( void )
{
   gettimeofday( &initial, NULL );
   memcpy( (char *)&reference, (char *)&initial, sizeof( struct timeval ) );
}

long int pm_delta_time( void )
{
   struct timeval current;
   long int       d;

   gettimeofday( &current, NULL );
   d = DIFFTIME( current, reference );
   memcpy( (char *)&reference, (char *)&current, sizeof( struct timeval ) );
   return d / 1000;
}

long int pm_total_time( void )
{
   struct timeval current;

   gettimeofday( &current, NULL );
   return DIFFTIME( current, initial ) / 1000;
}
