/* build.c -- 
 * Created: Sun May  7 19:06:39 1995 by r.faith@ieee.org
 * Revised: Wed Oct 25 15:53:29 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: build.c,v 1.4 1995/10/28 01:21:14 faith Exp $
 * 
 */

#include "pm.h"

				/* This stuff is in pmdb.h, but we don't
                                   include it here. */
#ifndef PMDB_DISP_INSTALLED
#define PMDB_DISP_INSTALLED 'I'
#endif

static void update_database( List list )
{
   List        files;
   List        fileSections;
   int         i;
   char        installedDisp[2] = { PMDB_DISP_INSTALLED, '\0' };
   List        fileList;
   List        dispList;
   PmEntryList entries;
   const char  *oldSubName = PmPkgSubName;

   static int build_lists( const char *name )
      {
	 PmEntry entry = pm_entry_create( name );

	 pm_entry_list_add( entries, entry );
	 pm_list_add( fileList, name + 1 );
	 pm_list_add( dispList, installedDisp );
	 return 0;
      }

   if (TEST(PM_TIME)) pm_reset_timer();
   fileSections = pm_notes_files_sections( list );

				/* Iterate by hand to avoid exercising
                                   trampoline bug in early versions of gcc
                                   (multiple, nested, nested functions may
                                   fail on some architectures). */
   
   for (i = 0; i < fileSections->count; i++) {
      files = pm_notes_files( list, fileSections->lines[i] );
      fileList = pm_list_create();
      dispList = pm_list_create();
      entries  = pm_entry_list_create();

      pm_entry_init();
      pm_list_iterate( files, build_lists );
      pm_entry_shutdown();

      PmPkgSubName = fileSections->lines[i]; /* cruft */
      if (!PmQuiet) printf( "* Updating database for %s\n",
			    pm_gen_canonical( PmPkgSubName ) );
      pm_db_install_package( entries, fileList, dispList );

      pm_entry_list_free( entries );
      pm_list_free( dispList );
      pm_list_free( fileList );
      pm_list_free( files );
   }

   pm_list_free( fileSections );

   PmPkgSubName = oldSubName;
   PRINTF(PM_TIME,("(Database update: %ld mS)\n",pm_total_time()));
}

int build( const char *name, int option, const char *config )
{
   const char *notesFile = pm_resolve_notesfile( name );
   List       list       = pm_notes_read( notesFile );
   char       *tmp       = tempnam( PmTmp, PgmName );
   char       packCmd[MAXPATHLEN * 2];
   char       buffer[MAXPATHLEN * 2];
   char       path[MAXPATHLEN];
   const char *prog;
   int        exitStatus;
   time_t     start, stop;
   long int   elapsed, hours, minutes, seconds;

   time( &start );

   getcwd( path, BUFSIZ );
   if (*PgmPath == '.') {
      prog = pm_file_path( 2, path, PgmPath );
   } else prog = xstrdup( PgmPath );


   sprintf( packCmd, "cd %s\n%s ", path, prog );
   if (config) {
      sprintf( buffer, "--config %s ", config );
      strcat( packCmd, buffer );
   }
   sprintf( buffer, "--dbgmask 0x%x --package %s", pm_debug_flags, notesFile );
   strcat( packCmd, buffer );
   if (option & PM_PACKSOURCE) {
      sprintf( buffer, "\n%s ", prog );
      strcat( packCmd, buffer );
      if (config) {
	 sprintf( buffer, "--config %s ", config );
	 strcat( packCmd, buffer );
      }
      sprintf( buffer,
	       "--dbgmask 0x%x --spackage %s", pm_debug_flags, notesFile );
      strcat( packCmd, buffer );
   }
   strcat( packCmd, "\n" );
   xfree( (char *)prog );

   pm_notes_parse( list );
   pm_notes_check( 2 );		/* Magic number for builds */

				/* Compile */
   pm_notes_script( list, option, tmp, packCmd );
   pm_chmod( tmp, 0700 );
   exitStatus = pm_shell( tmp );
   pm_unlink( tmp );

   if (TEST(PM_VERBOSE)) pm_notes_header( stdout, NULL );
   
   time( &stop );

   elapsed = stop - start;
   hours   =  elapsed / 3600L;
   elapsed -= 3600L * hours;
   minutes =  elapsed / 60L;
   elapsed -= 60L * minutes;
   seconds =  elapsed;

   if (!PmQuiet) {
      if (exitStatus) {
	 printf( "\nBuild time: %02ld:%02ld:%02ld (for %s, status = %d) ***\n",
		 hours,
		 minutes,
		 seconds,
		 name,
		 exitStatus );
      } else {
	 printf( "\nBuild time: %02ld:%02ld:%02ld (for %s)\n",
		 hours,
		 minutes,
		 seconds,
		 name );
      }
   }

   if (!exitStatus && (option & PM_INST))
      update_database( list );

   xfree( tmp );
   pm_notes_free( list );
   xfree( (char *)notesFile );

   return exitStatus;
}
