/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include "checker.h"
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

static void store_pid(char *ptr, int p);

/* Generate a unique temporary file name from TEMPLATE.
   The last six characters of TEMPLATE must be "XXXXXX";
   they are replaced with a string that makes the filename unique.  */
char *
DEFUN(mktemp, (template), char *template)
{
  static CONST char letters[]
    = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  CONST char *ptr = letters;
  pid_t pid = getpid();	/* TG: instead of __getpid */
  size_t len;
  struct stat statbuf;

  len = strlen(template);
  if (len < 6 || strcmp(&template[len - 6], "XXXXXX"))
    {
      errno = EINVAL;
      return NULL;
    }

#if 0
  if (sprintf (&template[len - 5], "%.5u",
  	 (unsigned int) pid % 100000) != 5)
    return NULL;
#else
  store_pid(&template[len - 5], (unsigned int) pid % 100000);
#endif

  while (*ptr != '\0') {
    template[len - 6] = *ptr++;
    if (stat(template, &statbuf) < 0 && errno == ENOENT)  /* TG: __stat */
      return template;
  }

  return NULL;
}

static void store_pid(char *ptr, int p)
{
 int i;
 
 for(i=0; i<5; i++)
   ptr[i] = '0';
 
 i = 4;
 while(p && i >= 0 )
 {
   ptr[i--] = '0' + p % 10;
   p /= 10;
 }
}  