From: jta@prodnet.la.locus.com (JT Anderson)
Newsgroups: comp.sources.x
Subject: v12i051: xroach, Part01/01
Date: 26 Mar 91 22:52:40 GMT

Submitted-by: JT Anderson <jta@prodnet.la.locus.com>
Posting-number: Volume 12, Issue 51
Archive-name: xroach/part01

Xroach displays disgusting cockroaches on your root window. These
creapy crawlies scamper around until they find a window to hide under.
Whenever you move or iconify a window, the exposed beetles again scamper
for cover.

# This is a shar archive.  Extract with sh, not csh.
# The rest of this file will extract:
# xroach.man xroach.c patchlevel.h roachmap.h roach000.xbm roach015.xbm roach030.xbm roach045.xbm roach060.xbm roach075.xbm roach090.xbm roach105.xbm roach120.xbm roach135.xbm roach150.xbm roach165.xbm roach180.xbm roach195.xbm roach210.xbm roach225.xbm roach240.xbm roach255.xbm roach270.xbm roach285.xbm roach300.xbm roach315.xbm roach330.xbm roach345.xbm Imakefile
# ----------------< cut here >---------------------- 
echo extracting - xroach.man
sed 's/^X//' > xroach.man << '~FUNKY STUFF~'
X.TH XROACH 1 "Release 4" "X Version 11"
X.SH NAME
Xxroach \- cockroaches hide under your windows
X.SH SYNOPSIS
X.B xroach
X[-option .,..]
X.SH DESCRIPTION
X.I Xroach
Xdisplays disgusting cockroaches on your root window. These creapy crawlies
Xscamper
Xaround until they find a window to hide under. Whenever you move or iconify
Xa window, the exposed beetles again scamper for cover.
X.SH OPTIONS
X.TP 8
X.B \-display \fIdisplay_name\fB
XDrop the roaches on the given display. Make sure the display is nearby, so you
Xcan hear the screams.
X.TP 8
X.B \-rc \fIroach_color\fB
XUse the given string as the color for the bugs instead of the default "black".
X.TP 8
X.B \-speed \fIroach_speed\fB
XUse the given speed for the insects instead of the default 20.0. For example,
Xin winter the speed should be set to 5.0. In summer, 30.0 might be about
Xright.
X.TP 8
X.B \-roaches \fInum_roaches\fB
XThis is the number of the little critters. Default is 10.
X.SH BUGS
XAs given by the -roaches option. Default is 10.
X.SH COPYRIGHT
XCopyright 1991 by J.T. Anderson
X.SH AUTHORS
XJ.T. Anderson
X(jta@locus.com)
X.SH DEDICATION
XGreg McFarlane
X(gregm@otc.otca.oz.au)
X.SH "SEE ALSO"
Xxroachmotel(1), xddt(1)
X
~FUNKY STUFF~
echo extracting - xroach.c
sed 's/^X//' > xroach.c << '~FUNKY STUFF~'
X/*
X    Xroach - A game of skill.  Try to find the roaches under your windows.
X    
X    Copyright 1991 by J.T. Anderson
X
X    jta@locus.com
X    
X    This program may be freely distributed provided that all
X    copyright notices are retained.
X
X    To build:
X      cc -o xroach roach.c -lX11 [-lsocketorwhatever] [-lm] [-l...]
X
X    Dedicated to Greg McFarlane.   (gregm@otc.otca.oz.au)
X*/
X#include <X11/Xlib.h>
X#include <X11/Xutil.h>
X#include <X11/Xos.h>
X
X#include <stdio.h>
X#include <math.h>
X#include <malloc.h>
X#include <signal.h>
X
X#if __STDC__
X#include <stdlib.h>
X#else
Xlong strtol();
Xdouble strtod();
Xchar *getenv();
X#endif
X
Xchar Copyright[] = "Xroach\nCopyright 1991 J.T. Anderson";
X
X#include "roachmap.h"
X
Xtypedef unsigned long Pixel;
Xtypedef int ErrorHandler();
X
X#define SCAMPER_EVENT	(LASTEvent + 1)
X
X#if !defined(GRAB_SERVER)
X#define GRAB_SERVER	0
X#endif
X
XDisplay *display;
Xint screen;
XWindow rootWin;
Xunsigned int display_width, display_height;
Xint center_x, center_y;
XGC gc;
Xchar *display_name = NULL;
XPixel black, white;
X
Xint done = 0;
Xint eventBlock = 0;
Xint errorVal = 0;
X
Xtypedef struct Roach {
X    RoachMap *rp;
X    int index;
X    float x;
X    float y;
X    int intX;
X    int intY;
X    int hidden;
X    int turnLeft;
X    int steps;
X} Roach;
X
XRoach *roaches;
Xint maxRoaches = 10;
Xint curRoaches = 0;
Xfloat roachSpeed = 20.0;
X
XRegion rootVisible = NULL;
X
Xvoid Usage();
Xvoid SigHandler();
Xvoid AddRoach();
Xvoid MoveRoach();
Xvoid DrawRoaches();
Xvoid CoverRoot();
Xint CalcRootVisible();
Xint MarkHiddenRoaches();
XPixel AllocNamedColor();
X
Xvoid
Xmain(ac, av)
Xint ac;
Xchar *av[];
X{
X    XGCValues xgcv;
X    int ax;
X    char *arg;
X    RoachMap *rp;
X    int rx;
X    float angle;
X    XEvent ev;
X    char *roachColor = "black";
X    int nVis;
X    int needCalc;
X    
X    /*
X       Process command line options.
X    */
X    for (ax=1; ax<ac; ax++) {
X	arg = av[ax];
X	if (strcmp(arg, "-display") == 0) {
X	    display_name = av[++ax];
X	}
X	else if (strcmp(arg, "-rc") == 0) {
X	    roachColor = av[++ax];
X	}
X	else if (strcmp(arg, "-speed") == 0) {
X	    roachSpeed = strtod(av[++ax], (char **)NULL);
X	}
X	else if (strcmp(arg, "-roaches") == 0) {
X	    maxRoaches = strtol(av[++ax], (char **)NULL, 0);
X	}
X	else {
X	    Usage();
X	}
X    }
X
X    srand((int)time((long *)NULL));
X    
X    /*
X       Catch some signals so we can erase any visible roaches.
X    */
X    signal(SIGKILL, SigHandler);
X    signal(SIGINT, SigHandler);
X    signal(SIGTERM, SigHandler);
X    signal(SIGHUP, SigHandler);
X
X    display = XOpenDisplay(display_name);
X    if (display == NULL) {
X	if (display_name == NULL) display_name = getenv("DISPLAY");
X	(void) fprintf(stderr, "%s: cannot connect to X server %s\n", av[0],
X	    display_name ? display_name : "(default)");
X	exit(1);
X    }
X
X    screen = DefaultScreen(display);
X    rootWin = RootWindow(display, screen);
X    black = BlackPixel(display, screen);
X    white = WhitePixel(display, screen);
X
X    display_width = DisplayWidth(display, screen);
X    display_height = DisplayHeight(display, screen);
X    center_x = display_width / 2;
X    center_y = display_height / 2;
X    
X    /*
X       Create roach pixmaps at several orientations.
X    */
X    for (ax=0; ax<360; ax+=ROACH_ANGLE) {
X	rx = ax / ROACH_ANGLE;
X	angle = rx * 0.261799387799;
X	rp = &roachPix[rx];
X	rp->pixmap = XCreateBitmapFromData(display, rootWin,
X	    rp->roachBits, rp->width, rp->height);
X	rp->sine = sin(angle);
X	rp->cosine = cos(angle);
X    }
X
X    roaches = (Roach *)malloc(sizeof(Roach) * maxRoaches);
X
X    gc = XCreateGC(display, rootWin, 0L, &xgcv);
X    XSetForeground(display, gc, AllocNamedColor(roachColor, black));
X    XSetFillStyle(display, gc, FillStippled);
X    
X    while (curRoaches < maxRoaches)
X	AddRoach();
X    
X    XSelectInput(display, rootWin, ExposureMask | SubstructureNotifyMask);
X    
X    needCalc = 1;
X    while (!done) {
X	if (XPending(display)) {
X	    XNextEvent(display, &ev);
X	}
X	else {
X	    if (needCalc) {
X		needCalc = CalcRootVisible();
X	    }
X	    nVis = MarkHiddenRoaches();
X	    if (nVis) {
X		ev.type = SCAMPER_EVENT;
X	    }
X	    else {
X		DrawRoaches();
X		eventBlock = 1;
X		XNextEvent(display, &ev);
X		eventBlock = 0;
X	    }
X	}
X	
X	switch (ev.type) {
X	    
X	    case SCAMPER_EVENT:
X		for (rx=0; rx<curRoaches; rx++) {
X		    if (!roaches[rx].hidden)
X			MoveRoach(rx);
X		}
X		DrawRoaches();
X		XSync(display, False);
X		break;
X		
X	    case Expose:
X	    case MapNotify:
X	    case UnmapNotify:
X	    case ConfigureNotify:
X		needCalc = 1;
X		break;
X		
X	}
X    }
X    
X    CoverRoot();
X    
X    XCloseDisplay(display);
X}
X
X#define USEPRT(msg) fprintf(stderr, msg)
X
Xvoid
XUsage()
X{
X    USEPRT("Usage: xroach [options]\n\n");
X    USEPRT("Options:\n");
X    USEPRT("       -display displayname\n");
X    USEPRT("       -rc      roachcolor\n");
X    USEPRT("       -roaches numroaches\n");
X    USEPRT("       -speed   roachspeed\n");
X    
X    exit(1);
X}
X
Xvoid
XSigHandler()
X{
X       
X    /*
X       If we are blocked, no roaches are visible and we can just bail
X       out.  If we are not blocked, then let the main procedure clean
X       up the root window.
X    */
X    if (eventBlock) {
X	XCloseDisplay(display);
X	exit(0);
X    }
X    else {
X	done = 1;
X    }
X}
X
X/*
X   Generate random integer between 0 and maxVal-1.
X*/
Xint
XRandInt(maxVal)
Xint maxVal;
X{
X	return rand() % maxVal;
X}
X
X/*
X   Check for roach completely in specified rectangle.
X*/
Xint
XRoachInRect(roach, rx, ry, x, y, width, height)
XRoach *roach;
Xint rx;
Xint ry;
Xint x;
Xint y;
Xunsigned int width;
Xunsigned int height;
X{
X    if (rx < x) return 0;
X    if ((rx + roach->rp->width) > (x + width)) return 0;
X    if (ry < y) return 0;
X    if ((ry + roach->rp->height) > (y + height)) return 0;
X    
X    return 1;
X}
X
X/*
X   Check for roach overlapping specified rectangle.
X*/
Xint
XRoachOverRect(roach, rx, ry, x, y, width, height)
XRoach *roach;
Xint rx;
Xint ry;
Xint x;
Xint y;
Xunsigned int width;
Xunsigned int height;
X{
X    if (rx >= (x + width)) return 0;
X    if ((rx + roach->rp->width) <= x) return 0;
X    if (ry >= (y + height)) return 0;
X    if ((ry + roach->rp->height) <= y) return 0;
X    
X    return 1;
X}
X
X/*
X   Give birth to a roach.
X*/
Xvoid
XAddRoach()
X{
X    Roach *r;
X    
X    if (curRoaches < maxRoaches) {
X	r = &roaches[curRoaches++];
X	r->index = RandInt(ROACH_HEADINGS);
X	r->rp = &roachPix[r->index];
X	r->x = RandInt(display_width - r->rp->width);
X	r->y = RandInt(display_height - r->rp->height);
X	r->intX = -1;
X	r->intY = -1;
X	r->hidden = 0;
X	r->steps = RandInt(200);
X	r->turnLeft = RandInt(100) >= 50;
X    }
X}
X
X/*
X   Turn a roach.
X*/
Xvoid
XTurnRoach(roach)
XRoach *roach;
X{
X    if (roach->index != (roach->rp - roachPix)) return;
X
X    if (roach->turnLeft) {
X	roach->index += (RandInt(30) / 10) + 1;
X	if (roach->index >= ROACH_HEADINGS)
X	    roach->index -= ROACH_HEADINGS;
X    }
X    else {
X	roach->index -= (RandInt(30) / 10) + 1;
X	if (roach->index < 0)
X	    roach->index += ROACH_HEADINGS;
X    }
X}
X
X/*
X   Move a roach.
X*/
Xvoid
XMoveRoach(rx)
Xint rx;
X{
X    Roach *roach;
X    Roach *r2;
X    float newX;
X    float newY;
X    int ii;
X    
X    roach = &roaches[rx];
X    newX = roach->x + (roachSpeed * roach->rp->cosine);
X    newY = roach->y - (roachSpeed * roach->rp->sine);
X    
X    if (RoachInRect(roach, (int)newX, (int)newY, 
X			    0, 0, display_width, display_height)) {
X	
X	roach->x = newX;
X	roach->y = newY;
X
X	if (roach->steps-- <= 0) {
X	    TurnRoach(roach);
X	    roach->steps = RandInt(200);
X	}
X
X	for (ii=rx+1; ii<curRoaches; ii++) {
X	    r2 = &roaches[ii];
X	    if (RoachOverRect(roach, (int)newX, (int)newY,
X		r2->intX, r2->intY, r2->rp->width, r2->rp->height)) {
X	
X		TurnRoach(roach);
X	    }
X	}
X    }
X    else {
X	TurnRoach(roach);
X    }
X}
X    
X/*
X   Draw all roaches.
X*/
Xvoid
XDrawRoaches()
X{
X    Roach *roach;
X    int rx;
X    
X    for (rx=0; rx<curRoaches; rx++) {
X	roach = &roaches[rx];
X	
X	if (roach->intX >= 0) {
X	    XClearArea(display, rootWin, roach->intX, roach->intY,
X		roach->rp->width, roach->rp->height, False);
X	}
X    }
X    
X    for (rx=0; rx<curRoaches; rx++) {
X	roach = &roaches[rx];
X	
X	if (!roach->hidden) {
X	    roach->intX = roach->x;
X	    roach->intY = roach->y;
X	    roach->rp = &roachPix[roach->index];
X    
X	    XSetStipple(display, gc, roach->rp->pixmap);
X	    XSetTSOrigin(display, gc, roach->intX, roach->intY);
X	    XFillRectangle(display, rootWin, gc,
X		roach->intX, roach->intY, roach->rp->width, roach->rp->height);
X	}
X	else {
X	    roach->intX = -1;
X	}
X    }
X}
X
X/*
X   Cover root window to erase roaches.
X*/
Xvoid
XCoverRoot()
X{
X    XSetWindowAttributes xswa;
X    long wamask;
X    Window roachWin;
X    
X    xswa.background_pixmap = ParentRelative;
X    xswa.override_redirect = True;
X    wamask = CWBackPixmap | CWOverrideRedirect;
X    roachWin = XCreateWindow(display, rootWin, 0, 0,
X		    display_width, display_height, 0, CopyFromParent,
X		    InputOutput, CopyFromParent, wamask, &xswa);
X    XLowerWindow(display, roachWin);
X    XMapWindow(display, roachWin);
X    XFlush(display);
X}    
X
X#if !GRAB_SERVER
X
Xint
XRoachErrors(dpy, err)
XDisplay *dpy;
XXErrorEvent *err;
X{
X    errorVal = err->error_code;
X    
X    return 0;
X}
X
X#endif /* GRAB_SERVER */
X
X/*
X   Calculate Visible region of root window.
X*/
Xint
XCalcRootVisible()
X{
X    Region covered;
X    Region visible;
X    Window *children;
X    int nChildren;
X    Window dummy;
X    XWindowAttributes wa;
X    int wx;
X    XRectangle rect;
X    int winX, winY;
X    unsigned int winHeight, winWidth;
X    unsigned int borderWidth;
X    unsigned int depth;
X    
X    /*
X       If we don't grab the server, the XGetWindowAttribute or XGetGeometry
X       calls can abort us.  On the other hand, the server grabs can make for
X       some annoying delays.
X    */
X#if GRAB_SERVER
X    XGrabServer(display);
X#else
X    XSetErrorHandler(RoachErrors);
X#endif
X
X    /*
X       Get children of root.
X    */
X    XQueryTree(display, rootWin, &dummy, &dummy, &children, &nChildren);
X    
X    /*
X       For each mapped child, add the window rectangle to the covered
X       region.
X    */
X    covered = XCreateRegion();
X    for (wx=0; wx<nChildren; wx++) {
X	if (XEventsQueued(display, QueuedAlready)) return 1;
X	errorVal = 0;
X	XGetWindowAttributes(display, children[wx], &wa);
X	if (errorVal) continue;
X	if (wa.map_state == IsViewable) {
X	    XGetGeometry(display, children[wx], &dummy, &winX, &winY,
X		&winWidth, &winHeight, &borderWidth, &depth);
X	    if (errorVal) continue;
X	    rect.x = winX;
X	    rect.y = winY;
X	    rect.width = winWidth + (borderWidth * 2);
X	    rect.height = winHeight + (borderWidth * 2);
X	    XUnionRectWithRegion(&rect, covered, covered);
X	}
X    }
X    XFree(children);
X
X#if GRAB_SERVER
X    XUngrabServer(display);
X#else
X    XSetErrorHandler((ErrorHandler *)NULL);
X#endif
X    
X    /*
X       Subtract the covered region from the root window region.
X    */
X    visible = XCreateRegion();
X    rect.x = 0;
X    rect.y = 0;
X    rect.width = display_width;
X    rect.height = display_height;
X    XUnionRectWithRegion(&rect, visible, visible);
X    XSubtractRegion(visible, covered, visible);
X    XDestroyRegion(covered);
X    
X    /*
X       Save visible region globally.
X    */
X    if (rootVisible)
X	XDestroyRegion(rootVisible);
X    rootVisible = visible;
X    
X    
X    /*
X       Mark all roaches visible.
X    */
X    for (wx=0; wx<curRoaches; wx++) 
X	roaches[wx].hidden = 0;
X
X    return 0;
X}
X
X/*
X   Mark hidden roaches.
X*/
Xint
XMarkHiddenRoaches()
X{
X    int rx;
X    Roach *r;
X    int nVisible;
X    
X    nVisible = 0;
X    for (rx=0; rx<curRoaches; rx++) {
X	r = &roaches[rx];
X	
X	if (!r->hidden) {
X	    if (r->intX > 0 && XRectInRegion(rootVisible, r->intX, r->intY,
X			    r->rp->width, r->rp->height) == RectangleOut) {
X		r->hidden = 1;
X	    }
X	    else {
X		nVisible++;
X	    }
X	}
X    }
X    
X    return nVisible;
X}
X
X/*
X   Allocate a color by name.
X*/
XPixel
XAllocNamedColor(colorName, dfltPix)
Xchar *colorName;
XPixel dfltPix;
X{
X	Pixel pix;
X	XColor scrncolor;
X	XColor exactcolor;
X
X	if (XAllocNamedColor(display, DefaultColormap(display, screen),
X		colorName, &scrncolor, &exactcolor)) {
X		pix = scrncolor.pixel;
X	}
X	else {
X		pix = dfltPix;
X	}
X
X	return pix;
X}
~FUNKY STUFF~
echo extracting - patchlevel.h
sed 's/^X//' > patchlevel.h << '~FUNKY STUFF~'
X#define PATCHLEVEL 0
~FUNKY STUFF~
echo extracting - roachmap.h
sed 's/^X//' > roachmap.h << '~FUNKY STUFF~'
X#include "roach000.xbm"
X#include "roach015.xbm"
X#include "roach030.xbm"
X#include "roach045.xbm"
X#include "roach060.xbm"
X#include "roach075.xbm"
X#include "roach090.xbm"
X#include "roach105.xbm"
X#include "roach120.xbm"
X#include "roach135.xbm"
X#include "roach150.xbm"
X#include "roach165.xbm"
X#include "roach180.xbm"
X#include "roach195.xbm"
X#include "roach210.xbm"
X#include "roach225.xbm"
X#include "roach240.xbm"
X#include "roach255.xbm"
X#include "roach270.xbm"
X#include "roach285.xbm"
X#include "roach300.xbm"
X#include "roach315.xbm"
X#include "roach330.xbm"
X#include "roach345.xbm"
X
X#define ROACH_HEADINGS	24	/* number of orientations */
X#define ROACH_ANGLE	15	/* angle between orientations */
X
Xtypedef struct RoachMap {
X	char *roachBits;
X	Pixmap pixmap;
X	int width;
X	int height;
X	float sine;
X	float cosine;
X} RoachMap;
X
XRoachMap roachPix[] = {
X	{roach000_bits, None, roach000_height, roach000_width, 0.0, 0.0},
X	{roach015_bits, None, roach015_height, roach015_width, 0.0, 0.0},
X	{roach030_bits, None, roach030_height, roach030_width, 0.0, 0.0},
X	{roach045_bits, None, roach045_height, roach045_width, 0.0, 0.0},
X	{roach060_bits, None, roach060_height, roach060_width, 0.0, 0.0},
X	{roach075_bits, None, roach075_height, roach075_width, 0.0, 0.0},
X	{roach090_bits, None, roach090_height, roach090_width, 0.0, 0.0},
X	{roach105_bits, None, roach105_height, roach105_width, 0.0, 0.0},
X	{roach120_bits, None, roach120_height, roach120_width, 0.0, 0.0},
X	{roach135_bits, None, roach135_height, roach135_width, 0.0, 0.0},
X	{roach150_bits, None, roach150_height, roach150_width, 0.0, 0.0},
X	{roach165_bits, None, roach165_height, roach165_width, 0.0, 0.0},
X	{roach180_bits, None, roach180_height, roach180_width, 0.0, 0.0},
X	{roach195_bits, None, roach195_height, roach195_width, 0.0, 0.0},
X	{roach210_bits, None, roach210_height, roach210_width, 0.0, 0.0},
X	{roach225_bits, None, roach225_height, roach225_width, 0.0, 0.0},
X	{roach240_bits, None, roach240_height, roach240_width, 0.0, 0.0},
X	{roach255_bits, None, roach255_height, roach255_width, 0.0, 0.0},
X	{roach270_bits, None, roach270_height, roach270_width, 0.0, 0.0},
X	{roach285_bits, None, roach285_height, roach285_width, 0.0, 0.0},
X	{roach300_bits, None, roach300_height, roach300_width, 0.0, 0.0},
X	{roach315_bits, None, roach315_height, roach315_width, 0.0, 0.0},
X	{roach330_bits, None, roach330_height, roach330_width, 0.0, 0.0},
X	{roach345_bits, None, roach345_height, roach345_width, 0.0, 0.0},
X};
X
~FUNKY STUFF~
echo extracting - roach000.xbm
sed 's/^X//' > roach000.xbm << '~FUNKY STUFF~'
X#define roach000_width 48
X#define roach000_height 48
X
Xstatic char roach000_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
X 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x06, 0x80,
X 0x00, 0x00, 0x03, 0x00, 0x03, 0x60, 0x00, 0x00, 0x7e, 0x80, 0xc1, 0x3f,
X 0x00, 0x00, 0xc0, 0x83, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0xc6, 0x30, 0x00,
X 0x00, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xef, 0x01,
X 0x00, 0x00, 0xfe, 0xff, 0xe7, 0x11, 0x10, 0xc0, 0xff, 0xff, 0xf7, 0x03,
X 0x02, 0xf0, 0xff, 0xff, 0xf3, 0x3f, 0x00, 0xf0, 0xff, 0xff, 0xf3, 0x3b,
X 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0xe0, 0xff, 0xff, 0xf3, 0x3f,
X 0x00, 0xe0, 0xff, 0xff, 0xf3, 0x3f, 0x00, 0xe0, 0xff, 0xff, 0xf3, 0x07,
X 0x01, 0xe0, 0xff, 0xff, 0xf7, 0x13, 0x08, 0xc0, 0xff, 0xff, 0xf7, 0x03,
X 0x00, 0x00, 0xfe, 0xff, 0xe7, 0x01, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00,
X 0x00, 0x00, 0x00, 0x88, 0x18, 0x00, 0x00, 0x00, 0xf8, 0xc7, 0xf0, 0x03,
X 0x00, 0x00, 0xfe, 0x81, 0xc1, 0x3f, 0x00, 0x00, 0x06, 0x00, 0x01, 0x30,
X 0x00, 0x00, 0x03, 0x00, 0x02, 0x40, 0x00, 0x80, 0x01, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach015.xbm
sed 's/^X//' > roach015.xbm << '~FUNKY STUFF~'
X#define roach015_width 48
X#define roach015_height 48
X
Xstatic char roach015_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, 0x00, 0x0c,
X 0x00, 0x00, 0x00, 0x80, 0x00, 0x06, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x07,
X 0x00, 0x00, 0x00, 0x40, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x60, 0x3c, 0x00,
X 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x10, 0x00, 0x10, 0x06, 0x00,
X 0x00, 0x60, 0xfc, 0x30, 0x72, 0x04, 0x00, 0xc0, 0x9f, 0xe3, 0xf3, 0x1e,
X 0x00, 0x00, 0x00, 0xfe, 0xfb, 0x1d, 0x00, 0x00, 0xc0, 0xff, 0xfb, 0x3d,
X 0x00, 0x00, 0xf8, 0xff, 0xf9, 0x3f, 0x00, 0x00, 0xfe, 0xff, 0xfb, 0x3f,
X 0x3c, 0x00, 0xff, 0xff, 0xfb, 0x07, 0x00, 0xc0, 0xff, 0x1f, 0xf8, 0x17,
X 0x00, 0xe0, 0xff, 0xe1, 0xf7, 0x07, 0x00, 0xf0, 0x1f, 0xfe, 0xf7, 0x03,
X 0x00, 0xf0, 0xe1, 0xff, 0xe7, 0x03, 0x00, 0x00, 0xfe, 0xff, 0xcf, 0x01,
X 0x00, 0xc0, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x7f, 0xfc,
X 0x00, 0xc0, 0xff, 0x3f, 0xc3, 0x1f, 0x01, 0xc0, 0xff, 0x23, 0x03, 0x00,
X 0x00, 0x00, 0x00, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1c, 0x00,
X 0x00, 0x00, 0x80, 0x07, 0x20, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x40, 0x00,
X 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach030.xbm
sed 's/^X//' > roach030.xbm << '~FUNKY STUFF~'
X#define roach030_width 48
X#define roach030_height 48
X
Xstatic char roach030_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x38, 0x40, 0x00, 0x00, 0x00, 0x10, 0x1e, 0x00,
X 0x00, 0x00, 0x00, 0x18, 0x07, 0x00, 0x00, 0x00, 0x00, 0x98, 0x01, 0x09,
X 0x00, 0x00, 0x00, 0x8c, 0x01, 0x04, 0x00, 0x00, 0x00, 0x8c, 0xb8, 0x07,
X 0x00, 0x00, 0x00, 0x84, 0x7c, 0x0f, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x8e,
X 0x00, 0x00, 0x00, 0xf8, 0xfc, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0xfc, 0x05,
X 0x00, 0x04, 0x1e, 0xff, 0xfd, 0x17, 0x00, 0xf8, 0x87, 0xff, 0xf9, 0x03,
X 0x00, 0xe0, 0xc0, 0xff, 0xf9, 0x07, 0x00, 0x00, 0xf0, 0x7f, 0xf0, 0x07,
X 0x00, 0x00, 0xf8, 0x1f, 0xe7, 0x03, 0x00, 0x00, 0xfe, 0xcf, 0xcf, 0xc1,
X 0x03, 0x00, 0xff, 0xf3, 0x1f, 0xe0, 0x00, 0x80, 0xff, 0xfc, 0xff, 0x3f,
X 0x00, 0x80, 0x3f, 0xfe, 0xbf, 0x07, 0x00, 0xc0, 0x9f, 0xff, 0x07, 0x00,
X 0x00, 0xc0, 0xe7, 0xff, 0x0f, 0x00, 0x00, 0xc0, 0xf9, 0xff, 0x3c, 0x00,
X 0x00, 0x00, 0xfe, 0xff, 0xf8, 0x01, 0x00, 0x00, 0xff, 0x8f, 0x00, 0x02,
X 0x00, 0x00, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x30, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach045.xbm
sed 's/^X//' > roach045.xbm << '~FUNKY STUFF~'
X#define roach045_width 48
X#define roach045_height 48
X
Xstatic char roach045_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x01,
X 0x00, 0x00, 0x00, 0xc0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x62, 0xc0, 0x43,
X 0x00, 0x00, 0x00, 0x62, 0xfe, 0x13, 0x00, 0x00, 0x00, 0x23, 0xff, 0x07,
X 0x00, 0x00, 0x00, 0x23, 0xff, 0x07, 0x00, 0x00, 0x00, 0x63, 0xff, 0x0b,
X 0x00, 0x00, 0x00, 0x73, 0xff, 0x01, 0x00, 0x00, 0x00, 0x7e, 0xfe, 0x01,
X 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x03, 0x00, 0x00, 0x40, 0xfe, 0xf9, 0x03,
X 0x07, 0x00, 0xf0, 0xff, 0xf1, 0xc3, 0x00, 0x00, 0x18, 0xff, 0xc0, 0xe3,
X 0x00, 0x00, 0x8e, 0x7f, 0x1e, 0x70, 0x00, 0x00, 0xc7, 0x3f, 0xff, 0x1f,
X 0x00, 0xfc, 0xe3, 0x9f, 0x7f, 0x07, 0x00, 0xe0, 0xe1, 0xcf, 0x3f, 0x00,
X 0x00, 0x00, 0xf0, 0xe7, 0x3f, 0x00, 0x00, 0x00, 0xf8, 0xf1, 0x1f, 0x00,
X 0x00, 0x00, 0xfc, 0xfc, 0xe7, 0x0f, 0x00, 0x00, 0x7e, 0xfe, 0x03, 0x00,
X 0x00, 0x00, 0x3e, 0xff, 0x03, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x02, 0x00,
X 0x00, 0x00, 0xcf, 0x7f, 0x03, 0x00, 0x00, 0x00, 0xe7, 0x1f, 0x03, 0x00,
X 0x00, 0x00, 0xf2, 0x8f, 0x03, 0x00, 0x00, 0x00, 0xf8, 0x83, 0x01, 0x00,
X 0x00, 0x00, 0xf8, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach060.xbm
sed 's/^X//' > roach060.xbm << '~FUNKY STUFF~'
X#define roach060_width 48
X#define roach060_height 48
X
Xstatic char roach060_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10,
X 0x00, 0x00, 0x00, 0x60, 0x00, 0x08, 0x00, 0x00, 0x00, 0x30, 0x74, 0x04,
X 0x00, 0x00, 0x00, 0x30, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x18, 0xfc, 0x01,
X 0x00, 0x00, 0x00, 0x88, 0xff, 0x00, 0x00, 0x00, 0x40, 0xc8, 0xff, 0x02,
X 0x00, 0x00, 0xc0, 0xd8, 0x7f, 0x00, 0x00, 0x00, 0xc0, 0xd8, 0xff, 0x80,
X 0x01, 0x00, 0x80, 0x90, 0xff, 0xe1, 0x00, 0x00, 0x80, 0x18, 0xff, 0x61,
X 0x00, 0x00, 0x80, 0x3f, 0xfe, 0x33, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x19,
X 0x00, 0x00, 0x00, 0xfe, 0xf1, 0x18, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x0f,
X 0x00, 0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 0x00, 0xe0, 0x7f, 0x7f, 0x00,
X 0x00, 0x00, 0x90, 0xbf, 0x7f, 0x00, 0x00, 0x00, 0x98, 0xbf, 0x3f, 0x38,
X 0x00, 0x00, 0xd8, 0xdf, 0x7f, 0x0f, 0x00, 0x00, 0xcc, 0xef, 0xdf, 0x01,
X 0x00, 0x00, 0xe6, 0xef, 0x0f, 0x00, 0x00, 0xc0, 0xe3, 0xf7, 0x0f, 0x00,
X 0x00, 0x00, 0xe0, 0xf7, 0x1f, 0x00, 0x00, 0x00, 0xf0, 0xfb, 0x1f, 0x00,
X 0x00, 0x00, 0xf0, 0xf9, 0x1b, 0x00, 0x00, 0x00, 0xf0, 0xfd, 0x19, 0x00,
X 0x00, 0x00, 0xf8, 0xfe, 0x08, 0x00, 0x00, 0x00, 0x78, 0x7e, 0x0c, 0x00,
X 0x00, 0x00, 0x70, 0x3f, 0x04, 0x00, 0x00, 0x00, 0x30, 0x3f, 0x06, 0x00,
X 0x00, 0x00, 0x80, 0x1f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x07, 0x06, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach075.xbm
sed 's/^X//' > roach075.xbm << '~FUNKY STUFF~'
X#define roach075_width 48
X#define roach075_height 48
X
Xstatic char roach075_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00,
X 0x00, 0x00, 0x00, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00,
X 0x00, 0x00, 0x00, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3e, 0x00,
X 0x00, 0x00, 0x00, 0x06, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x60,
X 0x00, 0x00, 0x00, 0xc6, 0x3f, 0x20, 0x00, 0x00, 0x00, 0xe6, 0x3f, 0x18,
X 0x00, 0x00, 0x00, 0xf2, 0x7f, 0x18, 0x00, 0x00, 0x08, 0xf2, 0x7f, 0x18,
X 0x00, 0x00, 0x30, 0xf6, 0xff, 0x0c, 0x00, 0x00, 0x20, 0xe4, 0xff, 0x0c,
X 0x00, 0x00, 0x60, 0x98, 0xff, 0x0c, 0x00, 0x00, 0x40, 0x38, 0x38, 0x06,
X 0x00, 0x00, 0xc0, 0xff, 0xe0, 0x01, 0x00, 0x00, 0x80, 0xff, 0xfe, 0x00,
X 0x00, 0x00, 0x00, 0x7e, 0xfe, 0x78, 0x00, 0x00, 0x00, 0x7e, 0x7f, 0x1c,
X 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x0e, 0x00, 0x00, 0xc0, 0x7f, 0xff, 0x03,
X 0x00, 0x00, 0xc0, 0x3e, 0x7f, 0x00, 0x00, 0x00, 0x20, 0xbf, 0x3f, 0x00,
X 0x00, 0x00, 0x20, 0xbf, 0x3f, 0x00, 0x00, 0x00, 0x20, 0xbf, 0x7f, 0x00,
X 0x00, 0x00, 0x10, 0x9f, 0x5f, 0x00, 0x00, 0x00, 0x10, 0xdf, 0x5f, 0x00,
X 0x00, 0x00, 0x18, 0xdf, 0x4f, 0x00, 0x00, 0x00, 0x0c, 0xdf, 0x4f, 0x00,
X 0x00, 0x00, 0x86, 0xcf, 0x47, 0x00, 0x00, 0x00, 0x80, 0xef, 0x47, 0x00,
X 0x00, 0x00, 0x80, 0xef, 0x63, 0x00, 0x00, 0x00, 0x00, 0xef, 0x63, 0x00,
X 0x00, 0x00, 0x00, 0xe7, 0x41, 0x00, 0x00, 0x00, 0x00, 0xf7, 0x81, 0x00,
X 0x00, 0x00, 0x00, 0xf0, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach090.xbm
sed 's/^X//' > roach090.xbm << '~FUNKY STUFF~'
X#define roach090_width 48
X#define roach090_height 48
X
Xstatic char roach090_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0xc0, 0xc0, 0x03, 0x0c, 0x00, 0x00, 0xc0, 0xd0, 0x07, 0x0c,
X 0x00, 0x00, 0xc0, 0xc0, 0x07, 0x04, 0x00, 0x00, 0xc0, 0x60, 0x07, 0x06,
X 0x00, 0x00, 0xc0, 0x80, 0x03, 0x06, 0x00, 0x00, 0xc0, 0xf0, 0x3f, 0x06,
X 0x00, 0x00, 0x80, 0xf8, 0x7f, 0x06, 0x00, 0x00, 0x80, 0xf9, 0x7f, 0x06,
X 0x00, 0x00, 0x80, 0xf9, 0x7f, 0x02, 0x00, 0x00, 0x00, 0xfb, 0x7f, 0x03,
X 0x00, 0x00, 0x00, 0xf3, 0x9f, 0x61, 0x00, 0x00, 0x18, 0x1c, 0x70, 0x30,
X 0x00, 0x00, 0x30, 0xfc, 0x7e, 0x18, 0x00, 0x00, 0x60, 0xfc, 0x7e, 0x0c,
X 0x00, 0x00, 0xc0, 0xfc, 0x7e, 0x06, 0x00, 0x00, 0xc0, 0xff, 0xfe, 0x03,
X 0x00, 0x00, 0x00, 0xfc, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7e, 0x00,
X 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfe, 0x01,
X 0x00, 0x00, 0x00, 0xff, 0x7e, 0x01, 0x00, 0x00, 0x80, 0xfc, 0x7e, 0x03,
X 0x00, 0x00, 0x80, 0xfc, 0x7e, 0x02, 0x00, 0x00, 0x80, 0xfc, 0x7e, 0x02,
X 0x00, 0x00, 0x80, 0xf8, 0x3e, 0x06, 0x00, 0x00, 0xc0, 0xf8, 0x3e, 0x06,
X 0x00, 0x00, 0xc0, 0xf8, 0x3e, 0x06, 0x00, 0x00, 0xc0, 0xf8, 0x3e, 0x04,
X 0x00, 0x00, 0xc0, 0xf8, 0x3e, 0x0c, 0x00, 0x00, 0x60, 0xf8, 0x3e, 0x08,
X 0x00, 0x00, 0x20, 0xf8, 0x3e, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x1e, 0x00,
X 0x00, 0x00, 0x00, 0xf0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach105.xbm
sed 's/^X//' > roach105.xbm << '~FUNKY STUFF~'
X#define roach105_width 48
X#define roach105_height 48
X
Xstatic char roach105_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
X 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc1, 0x00,
X 0x00, 0x00, 0x06, 0xf8, 0xc0, 0x00, 0x00, 0x00, 0x1c, 0xfa, 0xc1, 0x00,
X 0x00, 0x00, 0x18, 0x88, 0x83, 0x00, 0x00, 0x00, 0x10, 0xe0, 0x9f, 0x00,
X 0x00, 0x00, 0x30, 0xf8, 0x9f, 0x00, 0x00, 0x00, 0x20, 0xfc, 0x9f, 0x10,
X 0x00, 0x00, 0x60, 0xfe, 0x5f, 0x18, 0x00, 0x00, 0x60, 0xfe, 0x4f, 0x0c,
X 0x00, 0x00, 0x60, 0xfc, 0x27, 0x0c, 0x00, 0x00, 0xc0, 0x78, 0x3c, 0x0e,
X 0x00, 0x00, 0x80, 0x07, 0x7c, 0x06, 0x00, 0x00, 0x00, 0xfc, 0xfe, 0x03,
X 0x00, 0x00, 0x08, 0xfc, 0xfe, 0x00, 0x00, 0x00, 0x78, 0xfc, 0xfd, 0x00,
X 0x00, 0x00, 0xe0, 0xfc, 0xfd, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xfd, 0x07,
X 0x00, 0x00, 0x00, 0xf8, 0xfd, 0x05, 0x00, 0x00, 0x00, 0xf8, 0xfb, 0x05,
X 0x00, 0x00, 0x00, 0xf8, 0xfb, 0x09, 0x00, 0x00, 0x00, 0xfc, 0xfb, 0x19,
X 0x00, 0x00, 0x00, 0xfc, 0xf3, 0x19, 0x00, 0x00, 0x00, 0xe4, 0xf7, 0x31,
X 0x00, 0x00, 0x00, 0xe4, 0xf7, 0x31, 0x00, 0x00, 0x00, 0xe4, 0xf7, 0xc1,
X 0x00, 0x00, 0x00, 0xc4, 0xe7, 0x03, 0x01, 0x00, 0x00, 0xcc, 0xef, 0x03,
X 0x00, 0x00, 0x00, 0x8c, 0xef, 0x03, 0x00, 0x00, 0x00, 0x8c, 0xef, 0x01,
X 0x00, 0x00, 0x00, 0x0c, 0xcf, 0x01, 0x00, 0x00, 0x00, 0x0c, 0xde, 0x01,
X 0x00, 0x00, 0x00, 0x06, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach120.xbm
sed 's/^X//' > roach120.xbm << '~FUNKY STUFF~'
X#define roach120_width 48
X#define roach120_height 48
X
Xstatic char roach120_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00,
X 0x00, 0x00, 0x10, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x00,
X 0x00, 0x00, 0x00, 0x1e, 0x38, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x30, 0x00,
X 0x00, 0x00, 0x00, 0x9f, 0x63, 0x00, 0x00, 0x00, 0x80, 0xe6, 0x67, 0x04,
X 0x00, 0x80, 0x00, 0xfa, 0x27, 0x04, 0x00, 0x00, 0x07, 0xfc, 0x2f, 0x06,
X 0x00, 0x00, 0x0c, 0xfc, 0x07, 0x06, 0x00, 0x00, 0x18, 0xfe, 0x37, 0x02,
X 0x00, 0x00, 0x18, 0xff, 0x3b, 0x02, 0x00, 0x00, 0x30, 0xfe, 0xfc, 0x03,
X 0x00, 0x00, 0x60, 0x3e, 0xfc, 0x00, 0x00, 0x00, 0x60, 0xc0, 0xfe, 0x00,
X 0x00, 0x00, 0xc0, 0xff, 0xfd, 0x07, 0x00, 0x00, 0x00, 0xfc, 0xfd, 0x0f,
X 0x00, 0x00, 0x00, 0xfc, 0xfb, 0x1b, 0x00, 0x00, 0x20, 0xf8, 0xf3, 0x37,
X 0x00, 0x00, 0xf0, 0xf9, 0xf7, 0x67, 0x00, 0x00, 0xc0, 0xff, 0xef, 0xc7,
X 0x00, 0x00, 0x00, 0xe0, 0xef, 0x8f, 0x01, 0x00, 0x00, 0xe0, 0xdf, 0x0f,
X 0x0f, 0x00, 0x00, 0xe0, 0x9f, 0x0f, 0x00, 0x00, 0x00, 0xb0, 0xbf, 0x1f,
X 0x00, 0x00, 0x00, 0x20, 0x3f, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x7e, 0x1e,
X 0x00, 0x00, 0x00, 0x20, 0xfe, 0x3e, 0x00, 0x00, 0x00, 0x60, 0xfc, 0x3c,
X 0x00, 0x00, 0x00, 0x40, 0xf8, 0x3d, 0x00, 0x00, 0x00, 0xc0, 0xf8, 0x19,
X 0x00, 0x00, 0x00, 0x80, 0xf1, 0x03, 0x00, 0x00, 0x00, 0x80, 0xc1, 0x03,
X 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach135.xbm
sed 's/^X//' > roach135.xbm << '~FUNKY STUFF~'
X#define roach135_width 48
X#define roach135_height 48
X
Xstatic char roach135_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x40, 0xc0, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
X 0x00, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x01, 0x02, 0x0e, 0x00,
X 0x00, 0x00, 0x04, 0x03, 0x88, 0x01, 0x00, 0x00, 0xd8, 0xef, 0x88, 0x01,
X 0x00, 0x00, 0xc0, 0xff, 0x89, 0x01, 0x00, 0x00, 0x80, 0xfd, 0x8b, 0x01,
X 0x00, 0x00, 0xa0, 0xfc, 0x9f, 0x01, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x01,
X 0x00, 0x00, 0x00, 0xfe, 0x7d, 0x00, 0x00, 0xc0, 0x01, 0xff, 0xfe, 0x00,
X 0x00, 0x00, 0x06, 0x7f, 0xfe, 0x07, 0x00, 0x00, 0x0e, 0x3f, 0xfe, 0x1f,
X 0x00, 0x00, 0x3c, 0xcf, 0xfd, 0x27, 0x00, 0x00, 0x70, 0xe0, 0xfb, 0xc7,
X 0x00, 0x00, 0xe0, 0xff, 0xf7, 0x8f, 0x7f, 0x00, 0x00, 0xf8, 0xef, 0x1f,
X 0x07, 0x00, 0x00, 0xf0, 0xdf, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x7f,
X 0x00, 0x00, 0x80, 0xf7, 0x7f, 0x7e, 0x00, 0x00, 0xe0, 0xdf, 0xff, 0xfc,
X 0x00, 0x00, 0x00, 0x80, 0xff, 0xf9, 0x01, 0x00, 0x00, 0x80, 0xfe, 0xf3,
X 0x01, 0x00, 0x00, 0x80, 0xfd, 0xe7, 0x01, 0x00, 0x00, 0x00, 0xf1, 0xcf,
X 0x01, 0x00, 0x00, 0x00, 0xe3, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x86, 0x3f,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach150.xbm
sed 's/^X//' > roach150.xbm << '~FUNKY STUFF~'
X#define roach150_width 48
X#define roach150_height 48
X
Xstatic char roach150_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x04, 0x70, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0xe0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x80, 0x21, 0x00,
X 0x00, 0x00, 0x00, 0x01, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x00,
X 0x00, 0x00, 0xc0, 0x7b, 0x42, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x42, 0x00,
X 0x00, 0x00, 0xe1, 0xfd, 0x7f, 0x00, 0x00, 0x00, 0xf0, 0xfe, 0x3f, 0x04,
X 0x00, 0x00, 0x60, 0xfe, 0xfe, 0x3f, 0x00, 0x00, 0x50, 0xff, 0xfe, 0x61,
X 0x70, 0x00, 0x00, 0x7f, 0xfe, 0x87, 0x0f, 0x00, 0x00, 0x7f, 0xff, 0x0f,
X 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0x00, 0x00, 0x07, 0xdf, 0xf3, 0x7f,
X 0x00, 0x80, 0x1f, 0xee, 0xcf, 0xff, 0x00, 0x00, 0x38, 0xf0, 0x3f, 0xff,
X 0x01, 0x00, 0xe0, 0xff, 0xff, 0xfc, 0x03, 0x00, 0x00, 0xe0, 0xff, 0xf3,
X 0x07, 0x00, 0x00, 0xc0, 0xff, 0xcf, 0x07, 0x00, 0x00, 0xc0, 0xff, 0x3f,
X 0x07, 0x00, 0x00, 0x7c, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x3e, 0xfc, 0xff,
X 0x01, 0x00, 0x00, 0x00, 0xec, 0xff, 0x03, 0x00, 0x00, 0x00, 0x18, 0xff,
X 0x01, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach165.xbm
sed 's/^X//' > roach165.xbm << '~FUNKY STUFF~'
X#define roach165_width 48
X#define roach165_height 48
X
Xstatic char roach165_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x06, 0x00,
X 0x00, 0x00, 0x80, 0x1f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x1c, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x18, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x10, 0x00, 0x00, 0x00, 0x44, 0xf8, 0x1f, 0x3e,
X 0x0e, 0x00, 0x30, 0x7c, 0xff, 0xe0, 0x07, 0x00, 0xe0, 0x7e, 0xff, 0x03,
X 0x00, 0x00, 0xf0, 0x7e, 0xff, 0x07, 0x00, 0x00, 0x70, 0xff, 0xff, 0x3f,
X 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0x00, 0x00, 0x60, 0x7f, 0xff, 0xff,
X 0x01, 0x00, 0x50, 0x7f, 0x80, 0xff, 0x0f, 0x00, 0x00, 0x3f, 0x1f, 0xf8,
X 0x1f, 0x00, 0x00, 0xbf, 0xff, 0x01, 0x1f, 0x00, 0x00, 0xde, 0xff, 0x1f,
X 0x00, 0x00, 0x00, 0xec, 0xff, 0xff, 0x01, 0x00, 0x3e, 0xf0, 0xff, 0xff,
X 0x07, 0x00, 0xff, 0x8f, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x07, 0xf9, 0xff,
X 0x07, 0x00, 0x00, 0x80, 0x11, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x30, 0x00,
X 0x00, 0x00, 0x00, 0x70, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x1f,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach180.xbm
sed 's/^X//' > roach180.xbm << '~FUNKY STUFF~'
X#define roach180_width 48
X#define roach180_height 48
X
Xstatic char roach180_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
X 0x02, 0x00, 0x08, 0x80, 0x01, 0x00, 0x01, 0x00, 0xf8, 0x81, 0x03, 0x80,
X 0x01, 0x00, 0xe0, 0x0f, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x10, 0x84, 0x07,
X 0x00, 0x00, 0x00, 0x20, 0x84, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x03,
X 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0x01, 0x00, 0x00, 0x9c, 0xff, 0xff,
X 0x07, 0x00, 0x20, 0xbe, 0xff, 0xff, 0x0f, 0x00, 0xe0, 0x7f, 0xff, 0xff,
X 0x1f, 0x00, 0xf0, 0x7f, 0xff, 0xff, 0x0f, 0x00, 0x70, 0x7f, 0x00, 0x00,
X 0x00, 0x00, 0x70, 0x7f, 0xff, 0xff, 0x0f, 0x00, 0x70, 0x7f, 0xff, 0xff,
X 0x1f, 0x00, 0x48, 0x7f, 0xff, 0xff, 0x1f, 0x80, 0x20, 0x7f, 0xff, 0xff,
X 0x0f, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x07, 0x00, 0x00, 0x9c, 0xff, 0x1f,
X 0x00, 0x00, 0x00, 0x48, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x20, 0xc4, 0x00,
X 0x00, 0x00, 0xf0, 0x1f, 0x8c, 0xff, 0x00, 0x00, 0xf8, 0x03, 0x07, 0x80,
X 0x01, 0x00, 0x18, 0x80, 0x03, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00,
X 0x02, 0x00, 0x00, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach195.xbm
sed 's/^X//' > roach195.xbm << '~FUNKY STUFF~'
X#define roach195_width 48
X#define roach195_height 48
X
Xstatic char roach195_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1c,
X 0x00, 0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xff,
X 0x01, 0x00, 0xe7, 0x07, 0xff, 0xff, 0x07, 0x00, 0xfc, 0x1c, 0xff, 0xff,
X 0x0f, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x3f,
X 0x08, 0x00, 0x00, 0xde, 0xff, 0xc3, 0x1f, 0x00, 0x00, 0xbe, 0x3f, 0xfc,
X 0x1f, 0x00, 0x00, 0x7f, 0xc3, 0xff, 0x1f, 0x00, 0x20, 0x7f, 0xfc, 0xff,
X 0x0f, 0x00, 0x60, 0x7f, 0xff, 0xff, 0x01, 0x00, 0x70, 0x7f, 0xff, 0x7f,
X 0x00, 0x00, 0x70, 0xfe, 0xff, 0x3f, 0x00, 0x00, 0xf0, 0xfe, 0xff, 0x07,
X 0x00, 0x00, 0xe0, 0xfe, 0xff, 0xc1, 0x03, 0x00, 0x10, 0xfd, 0x7f, 0xff,
X 0x0f, 0x00, 0xc0, 0x78, 0x11, 0x00, 0x18, 0x00, 0x02, 0xb0, 0x20, 0x00,
X 0x00, 0x00, 0x01, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x38, 0x00,
X 0x00, 0x00, 0x00, 0x7c, 0x1c, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x0c, 0x00,
X 0x00, 0x00, 0xc0, 0x01, 0x04, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach210.xbm
sed 's/^X//' > roach210.xbm << '~FUNKY STUFF~'
X#define roach210_width 48
X#define roach210_height 48
X
Xstatic char roach210_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
X 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf0,
X 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0x01, 0x00, 0x00, 0x03, 0x8c, 0xff,
X 0x01, 0x00, 0x00, 0x3e, 0xfc, 0x7f, 0x00, 0x00, 0x00, 0x60, 0xfc, 0x1f,
X 0x04, 0x00, 0x00, 0xc0, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0xc0, 0xff, 0xc3,
X 0x0f, 0x00, 0x80, 0xe7, 0xff, 0xf0, 0x07, 0x00, 0xf0, 0xf8, 0x3f, 0xfc,
X 0x03, 0x00, 0x7f, 0xf0, 0x1f, 0xff, 0x01, 0x00, 0x0e, 0xcc, 0xc7, 0xff,
X 0x00, 0x00, 0x00, 0x9e, 0xf1, 0x7f, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f,
X 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x0f, 0x0f, 0x00, 0x00, 0xff, 0xfe, 0x87,
X 0x33, 0x00, 0xa0, 0xff, 0xfe, 0xff, 0x00, 0x00, 0xe0, 0xff, 0xfd, 0x1c,
X 0x00, 0x00, 0xf0, 0xff, 0x7d, 0x00, 0x00, 0x00, 0xe3, 0xfd, 0xfd, 0x00,
X 0x00, 0x00, 0xe0, 0xf9, 0x85, 0x00, 0x00, 0x00, 0xc0, 0xf1, 0xc7, 0x00,
X 0x00, 0x00, 0x40, 0xc2, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0x00,
X 0x00, 0x00, 0x20, 0x80, 0x63, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x20, 0x00,
X 0x00, 0x00, 0x08, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach225.xbm
sed 's/^X//' > roach225.xbm << '~FUNKY STUFF~'
X#define roach225_width 48
X#define roach225_height 48
X
Xstatic char roach225_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3f,
X 0x00, 0x00, 0x00, 0x00, 0xc6, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x9f,
X 0x01, 0x00, 0x00, 0x00, 0xf1, 0xcf, 0x01, 0x00, 0x00, 0x00, 0xf9, 0xe7,
X 0x01, 0x00, 0x00, 0x00, 0xff, 0xf3, 0x01, 0x00, 0x00, 0x0f, 0xff, 0xf9,
X 0x01, 0x00, 0xc0, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x7e,
X 0x00, 0x00, 0x00, 0xe0, 0x9f, 0x7f, 0x00, 0x00, 0x00, 0xf0, 0xcf, 0x3f,
X 0x3e, 0x00, 0x80, 0xff, 0xe7, 0x1f, 0x07, 0x00, 0xc0, 0xf0, 0xf3, 0xdf,
X 0x03, 0x00, 0x70, 0xe0, 0xf9, 0xcf, 0x00, 0x00, 0x38, 0x3c, 0xfc, 0x67,
X 0x00, 0x00, 0x1e, 0x7e, 0xfe, 0x1f, 0x00, 0x80, 0x0f, 0xfe, 0xfc, 0x01,
X 0x00, 0x00, 0x00, 0xfe, 0xfd, 0x01, 0x00, 0x00, 0x00, 0xfe, 0xfb, 0x01,
X 0x00, 0x00, 0x00, 0xff, 0x7b, 0x03, 0x00, 0x00, 0x00, 0xfd, 0x0f, 0x03,
X 0x00, 0x00, 0x80, 0xf9, 0x1f, 0x03, 0x00, 0x00, 0xc0, 0xe3, 0x1f, 0x03,
X 0x00, 0x00, 0x80, 0x9f, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x07, 0x18, 0x01,
X 0x00, 0x00, 0x02, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
X 0x00, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach240.xbm
sed 's/^X//' > roach240.xbm << '~FUNKY STUFF~'
X#define roach240_width 48
X#define roach240_height 48
X
Xstatic char roach240_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x01,
X 0x00, 0x00, 0x00, 0x80, 0xc1, 0x03, 0x00, 0x00, 0x00, 0x80, 0xf1, 0x11,
X 0x00, 0x00, 0x00, 0x80, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x80, 0xf8, 0x3c,
X 0x00, 0x00, 0x00, 0x40, 0x7c, 0x3c, 0x00, 0x00, 0x00, 0x40, 0x7e, 0x3e,
X 0x00, 0x00, 0x00, 0x20, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0xa0, 0x3f, 0x1f,
X 0x00, 0x00, 0x00, 0xe0, 0x9f, 0x1f, 0x3e, 0x00, 0x00, 0xc0, 0x9f, 0x0f,
X 0x07, 0x00, 0x00, 0xc0, 0xcf, 0x8f, 0x00, 0x00, 0x00, 0xe6, 0xe7, 0xcf,
X 0x00, 0x00, 0xc0, 0xf9, 0xe7, 0x47, 0x00, 0x00, 0x00, 0xf0, 0xf3, 0x67,
X 0x00, 0x00, 0x00, 0xf8, 0xf3, 0x37, 0x00, 0x00, 0x00, 0xf8, 0xf9, 0x1f,
X 0x00, 0x00, 0x00, 0xff, 0xfd, 0x07, 0x00, 0x00, 0xc0, 0x03, 0xfc, 0x01,
X 0x00, 0x00, 0x60, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x30, 0xfc, 0xfc, 0x03,
X 0x00, 0x00, 0x30, 0xfe, 0xfb, 0x06, 0x00, 0x00, 0x30, 0xfe, 0x77, 0x06,
X 0x00, 0x00, 0x1c, 0xfc, 0x37, 0x06, 0x00, 0x00, 0x02, 0xfc, 0x2f, 0x06,
X 0x00, 0x00, 0x00, 0xf8, 0x7f, 0x04, 0x00, 0x00, 0x00, 0xe5, 0x6f, 0x0c,
X 0x00, 0x00, 0x00, 0x8e, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x60, 0x00,
X 0x00, 0x00, 0x00, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x80, 0xf0, 0x30, 0x00,
X 0x00, 0x00, 0x40, 0x10, 0x30, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00,
X 0x00, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
X 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach255.xbm
sed 's/^X//' > roach255.xbm << '~FUNKY STUFF~'
X#define roach255_width 48
X#define roach255_height 48
X
Xstatic char roach255_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x02, 0x18, 0x00, 0x00, 0x00, 0x00, 0x06, 0x9c, 0x01,
X 0x00, 0x00, 0x00, 0x0c, 0x9e, 0x03, 0x00, 0x00, 0x00, 0x18, 0x8f, 0x03,
X 0x00, 0x00, 0x00, 0x18, 0xcf, 0x03, 0x00, 0x00, 0x00, 0x98, 0xcf, 0x03,
X 0x00, 0x00, 0x00, 0x88, 0xcf, 0x83, 0x01, 0x00, 0x00, 0xc8, 0xc7, 0xe3,
X 0x00, 0x00, 0x00, 0xc8, 0xe7, 0x63, 0x00, 0x00, 0x00, 0xec, 0xe7, 0x33,
X 0x00, 0x00, 0x00, 0xec, 0xe7, 0x33, 0x00, 0x00, 0x00, 0xf8, 0xe3, 0x13,
X 0x00, 0x00, 0x00, 0xf8, 0xf3, 0x1b, 0x00, 0x00, 0x00, 0xf0, 0xf3, 0x1b,
X 0x00, 0x00, 0x00, 0xf0, 0xf3, 0x09, 0x00, 0x00, 0x80, 0xff, 0xf9, 0x07,
X 0x00, 0x00, 0xc0, 0xf8, 0xf9, 0x01, 0x00, 0x00, 0xe0, 0xf8, 0xf9, 0x01,
X 0x00, 0x00, 0x10, 0xfc, 0xf9, 0x01, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x07,
X 0x00, 0x00, 0x00, 0x02, 0xfc, 0x0c, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x0c,
X 0x00, 0x00, 0x80, 0xf8, 0x63, 0x18, 0x00, 0x00, 0xc0, 0xfc, 0x6f, 0x18,
X 0x00, 0x00, 0x60, 0xfc, 0x9f, 0x30, 0x00, 0x00, 0x60, 0xfc, 0x3f, 0x01,
X 0x00, 0x00, 0x60, 0xf8, 0x3f, 0x01, 0x00, 0x00, 0x20, 0xe0, 0x3f, 0x01,
X 0x00, 0x00, 0x38, 0xb0, 0x8f, 0x01, 0x00, 0x00, 0x08, 0xf4, 0x83, 0x01,
X 0x00, 0x00, 0x00, 0xf0, 0x81, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x85, 0x00,
X 0x00, 0x00, 0x00, 0x08, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x81, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
X 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach270.xbm
sed 's/^X//' > roach270.xbm << '~FUNKY STUFF~'
X#define roach270_width 48
X#define roach270_height 48
X
Xstatic char roach270_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0xc0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x1c, 0x00,
X 0x00, 0x00, 0x00, 0xe0, 0x1c, 0x00, 0x00, 0x00, 0x20, 0xf0, 0x3c, 0x18,
X 0x00, 0x00, 0xc0, 0xf0, 0x3c, 0x0c, 0x00, 0x00, 0x80, 0xf1, 0x3c, 0x06,
X 0x00, 0x00, 0x00, 0xf9, 0x7c, 0x06, 0x00, 0x00, 0x00, 0xf9, 0x7c, 0x06,
X 0x00, 0x00, 0x00, 0xf9, 0x7c, 0x06, 0x00, 0x00, 0x00, 0xf9, 0x7c, 0x06,
X 0x00, 0x00, 0x00, 0xf9, 0x7c, 0x06, 0x00, 0x00, 0x00, 0xfb, 0x7c, 0x02,
X 0x00, 0x00, 0x00, 0xff, 0xfc, 0x02, 0x00, 0x00, 0x00, 0xfe, 0xfc, 0x01,
X 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xfc, 0x00,
X 0x00, 0x00, 0x00, 0xf8, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x07,
X 0x00, 0x00, 0x80, 0xfc, 0xfc, 0x0c, 0x00, 0x00, 0xc0, 0xfc, 0xfc, 0x18,
X 0x00, 0x00, 0x60, 0x78, 0xfc, 0x10, 0x00, 0x00, 0x30, 0x18, 0xc0, 0x20,
X 0x00, 0x00, 0x00, 0xc6, 0x1f, 0x01, 0x00, 0x00, 0x00, 0xe3, 0x7f, 0x02,
X 0x00, 0x00, 0x00, 0xf1, 0xff, 0x06, 0x00, 0x00, 0x80, 0xf1, 0xff, 0x06,
X 0x00, 0x00, 0x80, 0xf1, 0xff, 0x06, 0x00, 0x00, 0x80, 0xe1, 0x7f, 0x06,
X 0x00, 0x00, 0x80, 0x81, 0x1f, 0x06, 0x00, 0x00, 0x80, 0x81, 0x0f, 0x04,
X 0x00, 0x00, 0x80, 0x81, 0x2f, 0x04, 0x00, 0x00, 0xc0, 0x80, 0x0f, 0x0c,
X 0x00, 0x00, 0x40, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
X 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach285.xbm
sed 's/^X//' > roach285.xbm << '~FUNKY STUFF~'
X#define roach285_width 48
X#define roach285_height 48
X
Xstatic char roach285_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x60, 0x00, 0x01, 0x00, 0x00, 0x00, 0xe6, 0x80, 0x00,
X 0x00, 0x00, 0x00, 0xe6, 0xc1, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x63, 0x00,
X 0x00, 0x00, 0x00, 0xcf, 0x47, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x47, 0x00,
X 0x00, 0x00, 0x03, 0xdf, 0x4f, 0x00, 0x00, 0x00, 0x1c, 0x9f, 0xcf, 0x00,
X 0x00, 0x00, 0x30, 0x9f, 0x9f, 0x00, 0x00, 0x00, 0x30, 0xbf, 0x9f, 0x00,
X 0x00, 0x00, 0x20, 0xbf, 0xbf, 0x00, 0x00, 0x00, 0x40, 0x3e, 0xff, 0x00,
X 0x00, 0x00, 0x40, 0x3e, 0x7f, 0x00, 0x00, 0x00, 0xc0, 0x7e, 0x7f, 0x00,
X 0x00, 0x00, 0xc0, 0x7f, 0x7f, 0x03, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x07,
X 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x1c, 0x00, 0x00, 0x00, 0xfc, 0xfe, 0x18,
X 0x00, 0x00, 0x00, 0xfc, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfd, 0x00,
X 0x00, 0x00, 0x00, 0xfd, 0x01, 0x07, 0x00, 0x00, 0x80, 0x7c, 0xf8, 0x0e,
X 0x00, 0x00, 0xc0, 0xb8, 0xff, 0x0d, 0x00, 0x00, 0x40, 0xd8, 0xff, 0x09,
X 0x00, 0x00, 0x00, 0xcc, 0xff, 0x19, 0x00, 0x00, 0x00, 0xee, 0xff, 0x19,
X 0x00, 0x00, 0x00, 0xe6, 0xff, 0x18, 0x00, 0x00, 0x00, 0xc6, 0x7f, 0x30,
X 0x00, 0x00, 0x00, 0x86, 0x7f, 0x60, 0x00, 0x00, 0x00, 0x06, 0x7e, 0xc1,
X 0x00, 0x00, 0x00, 0x04, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0x00,
X 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x01,
X 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach300.xbm
sed 's/^X//' > roach300.xbm << '~FUNKY STUFF~'
X#define roach300_width 48
X#define roach300_height 48
X
Xstatic char roach300_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
X 0x00, 0x00, 0x00, 0x1f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x04, 0x00,
X 0x00, 0x00, 0x60, 0x7c, 0x0c, 0x00, 0x00, 0x00, 0xe0, 0x7c, 0x0c, 0x00,
X 0x00, 0x00, 0xf0, 0xf8, 0x08, 0x00, 0x00, 0x00, 0xe0, 0xf9, 0x11, 0x00,
X 0x00, 0x00, 0xe0, 0xf3, 0x13, 0x00, 0x00, 0x00, 0xe0, 0xf3, 0x17, 0x00,
X 0x00, 0x00, 0xc0, 0xe7, 0x1f, 0x00, 0x00, 0xc0, 0xc7, 0xc7, 0x1f, 0x00,
X 0x00, 0x00, 0xcc, 0xcf, 0x9f, 0x00, 0x00, 0x00, 0x88, 0x9f, 0xff, 0x07,
X 0x00, 0x00, 0x98, 0x9f, 0xff, 0x3c, 0x00, 0x00, 0xb0, 0x3f, 0x7f, 0x00,
X 0x00, 0x00, 0x60, 0x7f, 0xff, 0x00, 0x00, 0x00, 0xe0, 0x7f, 0xfe, 0x00,
X 0x00, 0x00, 0x00, 0xfe, 0x7e, 0x0f, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x1c,
X 0x00, 0x00, 0x00, 0xfc, 0xf1, 0x19, 0x00, 0x00, 0x00, 0x7e, 0xf8, 0x33,
X 0x00, 0x00, 0x00, 0x79, 0xfc, 0x63, 0x00, 0x00, 0x80, 0x31, 0xfe, 0x63,
X 0x00, 0x00, 0x80, 0x31, 0xff, 0xc3, 0x01, 0x00, 0x80, 0x91, 0xff, 0x01,
X 0x03, 0x00, 0x80, 0x91, 0xff, 0x04, 0x00, 0x00, 0x80, 0x98, 0x7f, 0x01,
X 0x00, 0x00, 0x00, 0x18, 0xff, 0x03, 0x00, 0x00, 0x00, 0x10, 0xf0, 0x05,
X 0x00, 0x00, 0x00, 0x30, 0x60, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach315.xbm
sed 's/^X//' > roach315.xbm << '~FUNKY STUFF~'
X#define roach315_width 48
X#define roach315_height 48
X
Xstatic char roach315_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x60, 0x20, 0x00, 0x00,
X 0x00, 0x00, 0xf0, 0xe1, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xc7, 0x01, 0x00,
X 0x00, 0x00, 0xe0, 0x9f, 0x01, 0x00, 0x00, 0x00, 0xc6, 0x3f, 0x02, 0x00,
X 0x00, 0x00, 0x8e, 0x7f, 0x06, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x06, 0x00,
X 0x00, 0x00, 0x3e, 0xfe, 0xc3, 0x00, 0x00, 0x00, 0x7c, 0xfc, 0xe7, 0x1f,
X 0x00, 0x00, 0xfc, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0xf8, 0xf1, 0x1f, 0x00,
X 0x00, 0x00, 0xf8, 0xe7, 0x3f, 0x00, 0x00, 0x80, 0xf1, 0xcf, 0x3f, 0x02,
X 0x00, 0x00, 0xe6, 0x9f, 0xff, 0x07, 0x00, 0x00, 0xcc, 0x3f, 0x1f, 0x08,
X 0x00, 0x00, 0x9c, 0x7f, 0xce, 0x31, 0x00, 0x00, 0xf0, 0xff, 0xe0, 0x63,
X 0x00, 0x00, 0xc0, 0xfe, 0xf1, 0xe7, 0x03, 0x00, 0x00, 0xfc, 0xf9, 0xc7,
X 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x07, 0x00, 0x00, 0x00, 0xfe, 0xfc, 0x03,
X 0x00, 0x00, 0x00, 0x62, 0xfe, 0x05, 0x00, 0x00, 0x00, 0x42, 0xfe, 0x0e,
X 0x00, 0x00, 0x00, 0x42, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x46, 0xfe, 0x47,
X 0x00, 0x00, 0x00, 0x66, 0x84, 0x03, 0x00, 0x00, 0x00, 0xc2, 0x40, 0x00,
X 0x04, 0x00, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach330.xbm
sed 's/^X//' > roach330.xbm << '~FUNKY STUFF~'
X#define roach330_width 48
X#define roach330_height 48
X
Xstatic char roach330_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0x00, 0x00,
X 0x00, 0x00, 0xfe, 0xc1, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x8f, 0xf0, 0x01,
X 0x00, 0x00, 0xf8, 0xff, 0x38, 0x00, 0x00, 0x80, 0xe0, 0xff, 0x0f, 0x00,
X 0x00, 0x80, 0xc3, 0xff, 0x07, 0x00, 0x00, 0x80, 0x0f, 0xff, 0x1f, 0x03,
X 0x00, 0x80, 0x3f, 0xfc, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xf0, 0x7f, 0x38,
X 0x00, 0x00, 0xfe, 0xe3, 0x8f, 0xe1, 0x07, 0x00, 0xf8, 0x8f, 0xc7, 0xc3,
X 0x00, 0x00, 0xf0, 0x3f, 0xe6, 0x07, 0x00, 0x00, 0xe1, 0xff, 0xf0, 0x07,
X 0x00, 0xc0, 0xc7, 0xff, 0xf9, 0x07, 0x00, 0x30, 0xbc, 0xff, 0xf9, 0x07,
X 0x00, 0x00, 0xf0, 0xfd, 0xfd, 0x1f, 0x00, 0x00, 0x00, 0xf8, 0xfd, 0x7f,
X 0x00, 0x00, 0x00, 0xf0, 0xfc, 0x1d, 0x08, 0x00, 0x00, 0xc8, 0xfd, 0x1e,
X 0x00, 0x00, 0x00, 0x0c, 0x7d, 0x06, 0x00, 0x00, 0x00, 0x08, 0x19, 0x02,
X 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00,
X 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - roach345.xbm
sed 's/^X//' > roach345.xbm << '~FUNKY STUFF~'
X#define roach345_width 48
X#define roach345_height 48
X
Xstatic char roach345_bits[] = {
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x40, 0x00,
X 0x00, 0x00, 0x00, 0x0e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00,
X 0x00, 0x00, 0xff, 0x23, 0x03, 0x00, 0x00, 0x80, 0xff, 0xff, 0x83, 0x03,
X 0x00, 0xc0, 0xff, 0xff, 0xe3, 0xff, 0x03, 0x80, 0xff, 0xff, 0x3f, 0x70,
X 0x00, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0x00, 0x40, 0x00, 0xff, 0xcf, 0x03,
X 0x00, 0xe0, 0x0f, 0xf0, 0xef, 0x03, 0x00, 0xc0, 0x7f, 0x00, 0xf7, 0x07,
X 0x00, 0xc0, 0xff, 0x07, 0xf0, 0x07, 0x00, 0x00, 0xff, 0x7f, 0xf0, 0xff,
X 0x13, 0x00, 0xfe, 0xff, 0xf1, 0x3f, 0x00, 0x00, 0xf0, 0xff, 0xf9, 0x3b,
X 0x00, 0x00, 0xc0, 0xff, 0xf9, 0x1f, 0x00, 0x00, 0x82, 0xff, 0xfb, 0x1f,
X 0x00, 0x00, 0xff, 0xfb, 0xfb, 0x03, 0x00, 0x80, 0xe1, 0xe1, 0xf3, 0x81,
X 0x00, 0x40, 0x00, 0x30, 0x62, 0x00, 0x02, 0x00, 0x00, 0x30, 0x04, 0x00,
X 0x04, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x78, 0x00,
X 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x80, 0x00, 0x06,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
X 0x00};
~FUNKY STUFF~
echo extracting - Imakefile
sed 's/^X//' > Imakefile << '~FUNKY STUFF~'
XSYS_LIBRARIES = -lm
XLOCAL_LIBRARIES = $(XLIB)
XSRCS = xroach.c
XOBJS = xroach.o
X
XComplexProgramTarget(xroach)
~FUNKY STUFF~

--
Dan Heller
------------------------------------------------
O'Reilly && Associates		 Z-Code Software
Senior Writer			       President
argv@ora.com			argv@zipcode.com
------------------------------------------------
General Email: argv@sun.com
Comp-sources-x stuff: comp-sources.x@uunet.uu.net

