/****************************************************************************
			     Sesh Nesout
	   Un programme d'aide a` la frappe hieroglyphique
		      utilisant le format glyph.
			   Serge Rosmorduc
****************************************************************************/
%{
#include <malloc.h>
typedef char * YYSTYPE;
char* genere();
extern void initialise_lex();
#include <stdio.h>
#ifndef NULL
#define NULL (char *)0
#endif
%}

%token TEXTE DEBUTHIEROGS FINHIEROGS
%token HIEROGLYPHE LIGAD
%token POINT
%token POINTPOINT  
%token KERNING  
%token ESPACE CARTO CARTF DEBCARTO MILCARTO FINCARTO
%token DIEZE0 DIEZE1
%token ROMAIN GAUCHEDROITE DROITEGAUCHE
%token INTERNALSPACE
%token HACHUREGA HACHUREVA HACHUREHA HACHURETA
%token HACHUREG HACHUREV HACHUREH HACHURET
%token FINLIGNE FINPAGE
%token TEXTESUPER POINTROUGE POINTNOIR
%token COULEUR0 COULEUR1
%token HAPLOGRAPHIE LACUNE LIGNELACUNE
%token DSTSUPERFETATOIRE FSTSUPERFETATOIRE
%token DSTEFFACE FSTEFFACE
%token DSTDISPARU FSTDISPARU
%token DSTRAJOUTSCRIBE FSTRAJOUTSCRIBE
%token DSTRAJOUTAUTEUR FSTRAJOUTAUTEUR
%token SEREKH ENCEINTE CHATEAU
%token DEBSEREKH MILSEREKH FINSEREKH
%token DEBENCEINTE MILENCEINTE FINENCEINTE
%token DEBCHATEAU MILCHATEAU FINCHATEAU

%left '-'
%left ':'  
%left '*'

%%

tout: tout TEXTE
      |tout hierogs
      | /* empty */
      ;

hierogs:
  DEBUTHIEROGS
  {printf("{%%\n\\leavevmode\\makeatletter%%\n");}
     /* lignes*/
     exprs  {printf("%s", $3);}  
  FINHIEROGS
  {printf("}%%\n\\end{hieroglyph}");}
  ;

 exprs:
  express
  | exprs express {$$= (YYSTYPE)genere($1,$2,NULL); free($1); free($2);}
  ;

express: /* BEAUCOUP PLUS PERMISSIF QUE GLYPH --- mais c'est voulu. est-ce un bien? non, mais je suis feignant */ 
  quadras
  |ESPACE    {$$= (YYSTYPE)genere("\\Hitmts%\n",NULL);} 
  |FINLIGNE  {$$= (YYSTYPE)genere("}\\end{hieroglyph}\n\n\\begin{hieroglyph}{\\leavevmode\\makeatletter%%\n",NULL);}
  |FINPAGE   {$$= (YYSTYPE)genere("\\nouvPage%\n",NULL);}
;


quadras:
  kerning quadra  {$$= (YYSTYPE)genere($1,$2, NULL); free($1); free($2);}
  | quadras '-' kerning quadra {$$= (YYSTYPE)genere( $1, "\\Hrp ",
						    $3, $4, NULL);
			       free($1); free($3); free($4);}
  ;

quadra:
  quadra_commun {$$= $1;}
  |hieroglyphe_externe
  | ROMAIN     {$$= (YYSTYPE)genere("{\\rm ", $1, "}", NULL); free($1);}
  
  | HAPLOGRAPHIE 
  | GAUCHEDROITE {$$= (YYSTYPE)genere("\\leftright", NULL);}
  | DROITEGAUCHE {$$= (YYSTYPE)genere("\\rightleft", NULL);}
  | LACUNE
  | LIGNELACUNE
  | TEXTESUPER  {$$= (YYSTYPE)genere("\\traittexte{", $1, "}", NULL); free($1);}
  | sousquadra ':' sousquadras      {$$= (YYSTYPE) genere("\\Hbt{\\HhbtI{",
						      $1, "}",
						      $3, "}", NULL);
			         free($1);free($3);}
  ;

sousquadras:
	sousquadra {$$= (YYSTYPE)genere("\\Hhbt{", $1, "}",NULL);
		    free($1);}
	| sousquadras ':' sousquadra {$$= (YYSTYPE)genere($1, "\\Hhbt{" ,
							  $3, "}",NULL);
				      free($1);free($3);}
;	

sousquadra: sousquadra '*' inhierliste {$$= (YYSTYPE)genere($1, "\\hfil", $3, NULL);
				      free($1); free($3);}
        | inhierliste
	;

inhierliste: quadra_commun
        | hieroglypheinterne
        | '(' quadras1 ')' {$$= $2;}
        ;

quadras1:
  quadra_interne  
  | quadras1 '-' quadra_interne {$$= (YYSTYPE)genere( $1, "\\hfil", $3, NULL);
		       free($1); free($3);}
  ;

quadra_interne:
  quadra_commun
  |hieroglypheinterne
  |ROMAIN             {$$= (YYSTYPE)genere("{\\footnotesize \\rm ", $1, "}", NULL);
		        free($1);}
  | sousquadra ':' sousquadras      {$$= (YYSTYPE) genere("\\Hbti{\\HhbtI{",
							  $1, "}",
							  $3, "}", NULL);
				     free($1);free($3);}
  | '(' quadras1 ')' {$$= $2;}
  ;


kerning: {$$= (YYSTYPE)genere("",NULL);}
  | kerning KERNING {$$= (YYSTYPE)genere($1, "\\negAROBspace", NULL);
		   free($1);}

hieroglyphe_externe:
  HIEROGLYPHE {$$= (YYSTYPE)genere("\\Hunh{", $1, "}", NULL);
		 free($1);}
  | HIEROGLYPHE HACHUREGA {$$= (YYSTYPE)
														 genere("\\hachurega{\\Hunh{", $1, "}}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHUREHA {$$= (YYSTYPE)
															genere("\\hachureha{\\Hunh{",$1, "}}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHUREVA {$$= (YYSTYPE)
															genere("\\hachureva{\\Hunh{",$1, "}}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHURETA {$$= (YYSTYPE)
															genere("\\hachureta{\\Hunh{",$1, "}}" ,NULL);
														free($1);
													}
;

hieroglypheinterne: HIEROGLYPHE
  | HIEROGLYPHE HACHUREGA  {$$= (YYSTYPE)
															genere("\\hachurega{", $1, "}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHUREHA {$$= (YYSTYPE)
															genere("\\hachureha{",$1, "}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHUREVA {$$= (YYSTYPE)
															genere("\\hachureva{",$1, "}", NULL);
														free($1);
													}
  | HIEROGLYPHE HACHURETA {$$= (YYSTYPE)
															genere("\\hachureta{",$1, "}" ,NULL);
														free($1);
													}
  ;

DebutConstruction : 
  CARTO {$$= (YYSTYPE)genere("\\cartouche{", NULL);}
  | DEBCARTO {$$= (YYSTYPE)genere("\\debcartouche{", NULL);}
  | MILCARTO {$$= (YYSTYPE)genere("\\milcartouche{", NULL);}
  | FINCARTO {$$= (YYSTYPE)genere("\\fincartouche{", NULL);}
  | SEREKH {$$= (YYSTYPE)genere("\\serekh{", NULL);}
  | ENCEINTE {$$= (YYSTYPE)genere("\\enceinte{", NULL);}
  | CHATEAU {$$= (YYSTYPE)genere("\\chateau{", NULL);}
  | DEBSEREKH {$$= (YYSTYPE)genere("\\debserekh{", NULL);}
  | MILSEREKH {$$= (YYSTYPE)genere("\\milserekh{", NULL);}
  | FINSEREKH {$$= (YYSTYPE)genere("\\finserekh{", NULL);}
  | DEBENCEINTE {$$= (YYSTYPE)genere("\\debenceinte{", NULL);}
  | MILENCEINTE {$$= (YYSTYPE)genere("\\milenceinte{", NULL);}
  | FINENCEINTE {$$= (YYSTYPE)genere("\\finenceinte{", NULL);}
  | DEBCHATEAU {$$= (YYSTYPE)genere("\\debchateau{", NULL);}
  | MILCHATEAU {$$= (YYSTYPE)genere("\\milchateau{", NULL);}
  | FINCHATEAU {$$= (YYSTYPE)genere("\\finchateau{", NULL);}
;

 parentheseD:
  DSTSUPERFETATOIRE
| DSTEFFACE
| DSTDISPARU
| DSTRAJOUTSCRIBE
| DSTRAJOUTAUTEUR
;

parentheseF:
 FSTSUPERFETATOIRE
| FSTEFFACE
| FSTDISPARU
| FSTRAJOUTSCRIBE
| FSTRAJOUTAUTEUR
;


quadra_commun:
  POINT              {$$=(YYSTYPE)genere("\\Hqrtesp ",NULL);}
  |HACHUREG          {$$=(YYSTYPE)genere("\\hachureg ",NULL);}
  |HACHUREH          {$$=(YYSTYPE)genere("\\hachureh ",NULL);}
  |HACHUREV          {$$=(YYSTYPE)genere("\\hachurev ",NULL);}
  |HACHURET          {$$=(YYSTYPE)genere("\\hachuret ",NULL);}
  |DebutConstruction exprs CARTF {
		                               $$= (YYSTYPE)genere($1,$2,"}",NULL);
																	 free($1);
																	 free($2);
																 }
  | parentheseD exprs parentheseF { $$= $1; }
  | DIEZE0 exprs DIEZE1 {$$=(YYSTYPE)genere("\\hachure{",$2,"}%\n",NULL);
		       free($2);}
  | COULEUR0 exprs COULEUR1 {$$=(YYSTYPE)genere("\\enrouge{",$2,"}%\n",NULL);
		       free($2);}
  | POINTPOINT         {$$=(YYSTYPE)genere("\\Hesp ",NULL);}
  ;


%%

