#include <unistd.h>
#include <const.h>
#include <stdarg.h>
#include <asm/io.h>
#include <asm/regs.h>
#include <asm/system.h>
#include <cnix/sched.h>
#include <cnix/wait.h>
#include <cnix/fs.h>
#include <cnix/printk.h>

unsigned long start_mem,end_mem;

extern unsigned char getchar(void);
extern void puts(char *s);
extern void brelse (struct buf_head *bh);
extern void schedule(void);

extern void vga_init(void);
extern void intr_init(void);
extern void traps_init(void);
extern void timer_init(void);
extern void ide_init(void);
extern void buf_init(void);
extern void fs_init(void);
extern void sched_init(void);
extern void sleep_on(struct wait_queue **p);
extern void wake_up(struct wait_queue **p); 
extern void reboot(void);
extern void get_mem(unsigned long *,unsigned long *);
extern unsigned long paging_init(unsigned long ,unsigned long);
extern void mem_init(unsigned long , unsigned long);
extern void show_area();
extern unsigned long get_free_pages(int,int);
extern char *kmalloc(int size,int flags);
extern void kfree(char *p);

extern void floppy_init();
extern void floppy_test();

int errno;	
_syscall0(int, fork)
_syscall1(int, execve, char *, filename)

static void init(void);

int getnum(void)
{
	unsigned int ch, ret = -1;
	
	do{
		ch = getchar();
		if(ch >= '0' && ch <= '9'){
			if(ret == -1)
				ret = ch - '0';
			else
				ret = ret * 10 + ch - '0';
		}else
			break;	
	}while(1);
	
	return ret;
}

int main(void)		
{	
	int i, dev, block;
	struct buf_head * bh;
	
	/* Note!!! traps_init and intr_init must be executed first. */
	traps_init();
	intr_init();

	/* Now it's ok to enable interrupt. */
	sti();	
	
	vga_init();
	puts("Cnix beta version!\n"); 
	
	get_mem(&start_mem,&end_mem);
	printk("The system memory is %d M\n",(end_mem>>20));
	start_mem = paging_init(start_mem,end_mem);
	mem_init(start_mem,end_mem);
	show_area();

	buf_init();

	sched_init();

	timer_init();

	/* I think ide will  use delay function which will be supported by 
	 * timer, so after being laid timer_init.
	 */
	ide_init();

	printk("floppy driver init.\n");
	floppy_init();
	/*printk("floppy driver test.\n");
	floppy_test();*/

	if(!fork()){
		/*
		 * Another Process...
		if(!fork()){
			bh = bread(0, 2);
			for(i = 0; i < 1024; i++)
				printk("%x", bh->b_data[i]);
			for(;;) schedule();
		}
		*/

		while(1){
			printk("\nwhich dev[0-3] will you read? ");
			dev = getnum();
			printk("%d\n", dev);
			
			printk("which block will you read on this dev? ");
			block = getnum();
			printk("%d\n", block);

			if(dev < 0 || block < 0)
				continue;

			bh = bread(dev, block);

			if(NULL != bh)
				for(i = 0; i < 1024; i++)
					printk("%x", bh->b_data[i]);
			else
				printk("bh is NULL in main!\n");

			if(bh)
				brelse(bh);
	
		}

		for(;;) /* when add another process, add it : schedule()*/ ;
		
		init();
	}	

	/* 
	 * because it's in kernel, so must to sched itself, because
	 * when timer interrupt happen, it will not to schedule ret_from_intr
	 */
	/* But I think idle could do some useful work, like get some info about
	 * system.
	 */
	while(1){ schedule(); }
}

static void init()
{
	execve("cnix/shell");

	while(1);
}
