#include <errno.h>
#include <stdarg.h>
#include <vga.h> /* puts() */
#include <asm/regs.h>
#include <cnix/printk.h>

extern int find_empty_process(void);
extern int copy_process(int nr, struct regs_t regs);
extern unsigned char readchar(void);

int sys_fork(struct regs_t regs)
{
	int i, ret;

	i = find_empty_process();
	if(i < 0)
		return i;
	
	ret = copy_process(i, regs);
	
	if(ret < 0)
		return ret;

	return i;
}

/*int sys_execve(struct regs_t regs)
{
	int ret;

	ret = do_execve(regs.ebx, &regs);

	return ret;
}*/

int sys_printf(const char * string)
{
	printk("calling sys_printf...\n");
	puts(string);
	printk("ending call...\n");
	return 0;
}

unsigned long sys_getchar(void)
{
	unsigned char c;

	c = readchar();

	return c;
}

void sys_null_call(void)
{
	printk("calling sys_null_call...\n");
}
