'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/focus.n,v 1.9 93/04/01 09:52:39 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS focus tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
focus \- Direct keyboard events to a particular window
.SH SYNOPSIS
\fBfocus\fR
.br
\fBfocus \fIwindow\fR
.br
\fBfocus \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
.VS
The \fBfocus\fR command is used to manage the Tk input focus.
At any given time, one window in an application is designated as
the focus window for that application;  any key press or key release
events directed to any window in the application will be redirected
instead to the focus window.  If there is no focus window for an
application then keyboard events are discarded.
Typically, windows that are prepared to deal with the focus
(e.g. entries and other widgets that display editable text) will
claim the focus when mouse button 1 is pressed in them.
When an application is created its main window is initially given
the focus.
.PP
The \fBfocus\fR command can take any of the following forms:
.TP
\fBfocus\fR
If invoked with no arguments, \fBfocus\fR returns the path name of
the current focus window, or \fBnone\fR if there is no focus window.
.TP
\fBfocus \fIwindow\fR
If invoked with a single argument consisting of a window's path
name, \fBfocus\fR sets the input focus to that window.
The return value is an empty string.
.TP
\fBfocus default \fR?\fIwindow\fR?
If \fIwindow\fR is specified, it becomes the default focus window
(the window that receives the focus whenever the focus window is
deleted) and the command returns an empty string.
If \fIwindow\fR isn't specified, the command returns the path name
of the current default focus window, or \fBnone\fR if there is no
default.
\fIWindow\fR may be specified as \fBnone\fR to clear its existing
value.
The default window is initially \fBnone\fR.
.TP
\fBfocus none\fR
Clears the focus window, so that keyboard input to this application
will be discarded.

.SH "FOCUS EVENTS"
.PP
Tk's model of the input focus is different than X's model, and the
focus window set with the \fBfocus\fR command is not usually the
same as the X focus window.
Tk never explicitly changes the official X focus window.
It waits for the window manager to direct the X input focus to
and from the application's top-level windows, and it intercepts
\fBFocusIn\fR and \fBFocusOut\fR events coming from the X
server to detect these changes.
All of the focus events received from X are discarded by Tk;  they
never reach the application.
Instead, Tk generates a different stream of \fBFocusIn\fR and
\fBFocusOut\fR for the application.
This means that \fBFocusIn\fR and
and \fBFocusOut\fR events seen by the application will not obey the
conventions described in the documentation for Xlib.
.PP
Tk applications receive two kinds of \fBFocusIn\fR and \fBFocusOut\fR
events, which can be distinguished by their \fIdetail\fR fields.
Events with a \fIdetail\fR of \fBNotifyAncestor\fR are directed
to the current focus window when it becomes active or inactive.
A window is the active focus whenever two conditions are
simultaneously true: (a) the window is the focus window for its
application, and (b) some top-level window in the application has
received the X focus.
When this happens Tk generates a \fBFocusIn\fR event for the focus
window with detail \fBNotifyAncestor\fR.
When a window loses the active focus (either because the window manager
removed the focus from the application or because the focus window changed
within the application) then it receives a \fBFocusOut\fR event
with detail \fBNotifyAncestor\fR.
.PP
The events described above are directed to the application's focus
window regardless of which top-level window within the application
has received the focus.
The second kind of focus event is provided for applications that
need to know which particular top-level window has the X focus.
Tk generates \fBFocusIn\fR and \fBFocusOut\fR events with detail
\fBNotifyVirtual\fR for top-level windows whenever they receive or
lose the X focus.
These events are generated regardless of which window in the
application has the Tk input focus.
They do not imply that keystrokes will be directed to the window
that receives the event;  they simply indicate which top-level
window is active as far as the window manager is concerned.
If a top-level window is also the application's focus window,
then it will receive both \fBNotifyVirtual\fR and \fBNotifyAncestor\fR
events when it receives or loses the X focus.
.PP
Tk does not generate the hierarchical chains of \fBFocusIn\fR and
\fBFocusOut\fR events described in the Xlib documentation (e.g.
a window can get a \fBFocusIn\fR or \fBFocusOut\fR event without
all of its ancestors getting events too).
Furthermore, the \fImode\fR field in focus events is always
\fBNotifyNormal\fR and the only values ever present in the
\fIdetail\fR field are \fBNotifyAncestor\fR and \fBNotifyVirtual\fR.
.VE

.SH KEYWORDS
events, focus, keyboard, top-level, window manager
