# /etc/rc.d/rc.M - runs automatically when the system enters multi-user mode
#
# Written by Ian A. Murdock <imurdock@shell.portal.com>
#

PATH="/bin:/sbin:/usr/bin:/usr/sbin"

echo ""
echo "Going multiuser..."
echo ""

# Mount filesystems in /etc/fstab, skipping filesystems mounted via NFS
# (because TCP/IP cannot be configured until the filesystems have been
# mounted).
/bin/mount -avt nonfs

# Activate the swap device(s) in /etc/fstab.
/sbin/swapon -a

echo ""

# Setup TCP/IP connection and start various TCP/IP daemons (we do this
# here because /usr may be a remote filesystem).
/bin/sh /etc/rc.d/rc.inet1
/bin/sh /etc/rc.d/rc.inet2

# Set clock to localtime (use `-u' if your system clock is set to GMT).
/sbin/clock -u -s

# Start a few daemons.
echo -n "Starting daemons: "
if [ -x /usr/sbin/crond ]; then
	echo -n "crond "
	/usr/sbin/crond
fi
if [ -x /usr/sbin/lpd ]; then
	echo -n "lpd "
	/usr/sbin/lpd
fi
if [ -x /usr/lib/sendmail ]; then
	echo -n "smail "
	/usr/lib/sendmail -q10m
fi
echo "update"
/sbin/update &

# Configure serial ports.
/bin/sh /etc/rc.d/rc.serial

# Start process accounting.
#if [ -x /usr/sbin/accton ]; then
#	mv /var/adm/acct /var/adm/acct.old
#	cp /dev/null /var/adm/acct
#	/usr/sbin/accton /var/adm/acct
#fi

# Update quota files (if not a fastboot).
#if [ ! -e /etc/fastboot ]; then
#	if [ -x /usr/sbin/quotacheck ]; then
#		echo ""
#		/usr/sbin/quotacheck -avu
#	fi
#else
#	echo ""
#	echo "Not updating quota files..."
#fi

# Enable disk quotas.
#if [ -x /usr/sbin/quotaon ]; then
#	/usr/sbin/quotaon -avu
#fi

# Now cleanup and create a few things.

echo ""
echo -n "Performing a few administrative tasks..."

# First, create /etc/utmp so that we can login.
/bin/cp /dev/null /etc/utmp

# Next, trim down /var/adm/wtmp when it reaches a certain size so that it
# doesn't grow too large.
if [ -x /usr/bin/find ]; then
	/usr/bin/find /var/adm/wtmp -size +20k -exec rm -f {} \;
fi

# If we just erased /var/adm/wtmp (or if it does not exist for some reason),
# then create it.
if [ ! -e /var/adm/wtmp ]; then
	/bin/cp /dev/null /var/adm/wtmp
fi

# Erase /etc/fastboot now that we have skipped those operations that are not
# performed during a fastboot.
/bin/rm -f /etc/fastboot

# Preserve `vi' files after a crash before /tmp is wiped.
if [ -x /usr/bin/elvprsv ]; then
	/usr/bin/elvprsv /tmp/elv*
fi

# Wipe /tmp.
/bin/rm -rf /tmp/*

# Erase any files in /var/tmp that are older than a certain number of days.
if [ -x /usr/bin/find ]; then
	/usr/bin/find /var/tmp/* -mtime 3 -exec rm -f {} \; 2> /dev/null
fi

# Remove any lingering UUCP lock files.
/bin/rm -f /var/lock/LCK*

# Blank the screen after 10 minutes.
/usr/bin/setterm -blank 10

# Load the appropriate keytable.
/bin/loadkeys /etc/keytables/us.map

# Selection: cut-and-paste between virtual consoles.
#if [ -x /usr/sbin/selection ]; then
#	/usr/sbin/selection -tlogi -m/dev/cua0 &
#fi

echo "done."

# Do not delete these last `if's!  Debian Linux uses this to perform automatic
# updates when necessary (i.e., when /sbin/setup.sh or /sbin/upgrade.sh is
# found).
if [ -x /sbin/setup.sh ]; then
	/sbin/setup.sh
	rm -f /sbin/setup.sh
fi
if [ -x /sbin/upgrade.sh ]; then
	/sbin/upgrade.sh
	rm -f /sbin/upgrade.sh
fi

# Local setup.
/bin/sh /etc/rc.d/rc.local
