# /etc/rc.d/rc.S - runs automatically when the system boots
#
# Written by Ian A. Murdock <imurdock@shell.portal.com> (with sections
# taken from the bootutils 0.1 package)
#

PATH="/bin:/sbin:/usr/bin:/usr/sbin"

# Check the integrity of all filesystems (if not a fastboot)
if [ ! -e /etc/fastboot ]; then
	echo ""
        echo "Checking filesystems..."
	echo ""
        /sbin/fsck -A -a
        # If there was a failure, drop into single-user mode.
        if [ $? -gt 1 ] ; then
                echo "fsck failed.  Please reboot."
                /bin/sh
        fi
else
        echo ""
        echo "*** Filesystems are not being checked! ***"
fi

# Remount the root filesystem in read-write mode
/bin/mount -n -o remount /dev/hda3 /

# Remove /etc/mtab*, /etc/nologin and /etc/utmp
/bin/rm -f /etc/mtab* /etc/nologin /etc/utmp

echo ""
