/* 
 * "rustic" math library, for muLinux
 * (C) by M. Andreoli & E. Cavalli
 */

#define PI 3.14159265359
#define SQRT_E 1.6487212707

#define double double 

#define ABS(x)  ( (x)>=0?(x):(-x) )


/* exp() */

double exp2( double x)  
{
double x2,x212;
if(x<0.5) {
x2=x*x;
x212=12.0+x2;
return (x212+6.0*x)/(x212-6.0*x);
}
else {
x-=0.5;
x2=x*x;
x212=12.0+x2;
return SQRT_E*(x212+6.0*x)/(x212-6.0*x);
}

}

double exp(double x)
{
double r,rest;
int i,m,sign;

sign=x>=0?1.0:-1.0;
x=sign*x;

m=x;
rest=x-1.0*(int)x;
r=1.0;
for (i=0; i<m;i++) r=r*2.71828182; 
return sign>0? r*exp2(rest) : exp2(-rest)/r;
}



/* cos(x) */

double cos(double x)
{
double y,x2,x4;
int n;
x=ABS(x);

n=x/(2.0*PI);
y=x - n*PI*2.0-PI;

x2=y*y;
x4=x2*x2;
return -(1. - 0.4563492063492063*x2 + 
     0.0207010582010582*x4)/
   (1. + 0.04365079365079364*x2 + 
     0.00085978835978836*x4);

}

/* sin(x) */                                                                    
                                                                                
double sin(double x)                                                         
{                                                                               
return cos(PI/2.0-x);                                                                                
}                                                                               


