/*
 * typewriter, by M. Andreoli (1998)
 *
 * wait for character and send it to stderr
 * q for exit.
 * argv[1]= status file
 *  Usage:    typewriter 2> fifo
 */

#include <stdio.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>

#define TRUE 1
#define FALSE 0

int do_command(u_char);
int display_status();

struct termios old_tc; 
struct termios new_tc;
char status_file[64];
char status[128];

main (int argc, char *argv[]) {
    u_char cmd;

	strcpy(status_file,argv[1]);

	set_raw_term();

	while (1) {
        cmd = getchar();
	do_command(cmd);
	display_status();
	}
tcsetattr(0, TCSANOW, &old_tc);  

}


do_command (u_char c)
{

switch(c)
{
case 'q': {reset_term() ; fprintf(stderr,"%c\n",c); exit(0);}
}

if ( c !=  (u_char) 255 ) fprintf(stderr,"%c\n",c);


}

display_status()
{
FILE *fs;
fs=fopen(status_file,"r");
fgets(status,128,fs);
fclose(fs);
printf("\r %-020s",status);
}


set_raw_term() {
    tcgetattr(0, &old_tc);
    new_tc = old_tc;
    new_tc.c_lflag &= ~(ECHO | ICANON);		/* raw output */
    new_tc.c_cc[VTIME] = 1; 
    /*new_tc.c_cc[VMIN] = 0; */ 

    tcsetattr(0, TCSANOW, &new_tc);
}

reset_term() {
    tcsetattr(0, TCSANOW, &old_tc);
}			

