//  Wave - a sound waveform generator 
//  reduced for muLinux by M. Andreoli
//  argv[1]=freq, argv[2]=duration (1/10s)
//  based on Wave: 
	// Copyright (C) 1996 Jeff Tranter (jeff_tranter@pobox.com)

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
/*#include <math.h> */
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <linux/soundcard.h>

#include "math.h"

/* global variables */
int rate          = 8000;	// sampling rate in samples/second
int frequency;
double duration   = 0;		// playing duration in seconds, 0=infinite
int channels      = 1;		// 1 = mono 2 = stereo
int bits          = 8;		// sample size in bits
char *device      = "/dev/audio"; // output device or file
int fd;				// file descriptor for device
unsigned char *buffer = 0;	// buffer for one cycle of sound data



// generate and play 
static void Play()
{
  int numPoints = rate/frequency;
  int numCycles = int(frequency*duration)/10;
  int  i,j;
  buffer = new unsigned char[numPoints*channels*(bits/8)];

 /* generate one cycle */

      for (i = 0 ; i < numPoints ; i++) {
        j = int(128 *sin(2.0*M_PI*i/numPoints) + 128);
        if(j<0) j=0; if(j>255) j=255;
        buffer[i] = j;
      }


/* write data */
  for (i = 0 ; (i < numCycles) || duration == 0 ; i++)
    write(fd, buffer, numPoints);

}


// main program
int main(int argc, char *argv[])
{
  int arg,status;

/* parse args */

if ( ( argv[1][0]=='-' ) && (argv[1][1]=='h' ))
{
	fprintf(stderr,"Usage: wave [-h] frequency duration (1/10s)\n");
	exit(0);
}

  frequency=atol(argv[1]);
  duration=atof(argv[2]);

/* open device */
  fd = open(device, O_WRONLY|O_CREAT|O_TRUNC, 0777);
  if (fd == -1)
     fprintf(stderr, "%s:unable to open");
/* init device */
  status = ioctl(fd, SOUND_PCM_WRITE_BITS, &bits);
  if (status == -1)
        fprintf(stderr,"SOUND_PCM_WRITE_BITS ioctl failed");
  ioctl(fd, SOUND_PCM_WRITE_CHANNELS, &channels);
  ioctl(fd, SOUND_PCM_WRITE_RATE, &rate);
  arg = AFMT_U8;
  ioctl(fd, SOUND_PCM_SETFMT, &arg);
/* generate and play */
  Play();
/* close device */
  close(fd);
  return 0;
}
