/*
 * dip		A program for handling dialup IP connecions.
 *		IP Datagram dumping routines.
 *
 * Version:	@(#)ipdump.c	3.3.3	08/16/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "dip.h"
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#ifndef LINUX
void
ip_dump(char *ptr, int len)
{
  struct ip *ip;
  int flags, dlen, doff;

  ip = (struct ip *) ptr;
  dlen = ntohs(ip->ip_len);
  flags = (ntohs(ip->ip_off) & ~IP_OFFSET);
  doff = ((ntohs(ip->ip_off) & IP_OFFSET) << 3);

  fprintf(stderr, "\r*****\n");
  fprintf(stderr, "IP: %s->", inet_ntoa(ip->ip_src));
  fprintf(stderr, "%s\n", inet_ntoa(ip->ip_dst));
  fprintf(stderr, " len %u ihl %u ver %u ttl %u prot %u sum %u",
	dlen, ip->ip_hl, ip->ip_v, ip->ip_ttl, ip->ip_p, ip->ip_sum);

  if (ip->ip_tos != 0) fprintf(stderr, " tos 0x%02X", ip->ip_tos);
  if (doff != 0 || (flags & IP_MF))
	fprintf(stderr, " id %u offs %u", ntohs(ip->ip_id), doff);

  if (flags & IP_DF) fprintf(stderr, " DF");
  if (flags & IP_MF) fprintf(stderr, " MF");
  if (flags & IP_CE) fprintf(stderr, " CE");

  fprintf(stderr, "\n*****\n");
  (void) fflush(stderr);
}
#endif /* LINUX */
