/*
 * INET		An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET  is implemented using the  BSD Socket
 *		interface as the means of communication with the user level.
 *
 *		Definitions for the IP router.
 *
 * Version:	@(#)route.h	1.0.3	04/17/93
 *
 * Authors:	Ross Biro, <bir7@leland.Stanford.Edu>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */
#ifndef _ROUTE_H
#define _ROUTE_H


#include <linux/route.h>


extern void		rt_flush(struct device *dev);
extern void		rt_add(short flags, short metric, unsigned long addr,
			       unsigned long gw, struct device *dev);
extern struct device	*ip_route(struct options *opt, unsigned long daddr,
				  unsigned long *raddr);

extern int		rt_get_info(char * buffer);
extern int		rt_ioctl(unsigned int cmd, void *arg);

#endif	/* _ROUTE_H */
