/* localize.h (i18n/l10n) */
/* $OpenLDAP: pkg/ldap/include/ac/localize.h,v 1.1.2.1 2003/09/18 15:43:31 kurt Exp $ */
/*
 * Copyright 2003 The OpenLDAP Foundation, Redwood City, California, USA
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted only as authorized by the OpenLDAP
 * Public License.  A copy of this license is available at
 * http://www.OpenLDAP.org/license.html or in file LICENSE in the
 * top-level directory of the distribution.
 */

#ifndef _AC_LOCALIZE_H
#define _AC_LOCALIZE_H

#ifdef LDAP_LOCALIZE

#	include <locale.h>
#	include <libintl.h>

	/* enable i18n/l10n */
#	define gettext_noop(s)		s
#	define _(s)					gettext(s)
#	define N_(s)				gettext_noop(s)
#	define ldap_pvt_setlocale(c,l)		((void) setlocale(c, l))
#	define ldap_pvt_textdomain(d)		((void) textdomain(d))
#	define ldap_pvt_bindtextdomain(p,d)	((void) bindtextdomain(p, d))

#else

	/* disable i18n/l10n */
#	define _(s)					s
#	define N_(s)				s
#	define ldap_pvt_setlocale(c,l)		((void) 0)
#	define ldap_pvt_textdomain(d)		((void) 0)
#	define ldap_pvt_bindtextdomain(p,d)	((void) 0)

#endif

#endif /* _AC_LOCALIZE_H */
