# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global product oVirt
%global use_rhev %( test -z // && echo 1 || echo 0)
%define debug_package %{nil}


%global source_basename cockpit-ovirt-0.11.29

Name:           cockpit-ovirt
Version:        0.11.29
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}
License:        ASL 2.0
URL:            https://gerrit.ovirt.org/gitweb?p=cockpit-ovirt.git;a=summary
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{source_basename}.tar.gz


%if 0%{?rhel}
ExclusiveArch:  x86_64
%else
BuildRequires: nodejs-packaging
ExclusiveArch: %{nodejs_arches} noarch
%endif

#This is a hack for copr, but why is it needed?
BuildRequires: python
BuildRequires: ovirt-engine-nodejs
BuildRequires: ovirt-engine-nodejs-modules
BuildRequires: ovirt-engine-yarn

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}
BuildArch:      noarch


Requires:       cockpit
Requires:       cockpit-storaged
Requires:       ovirt-hosted-engine-setup >= 2.2.14
Requires:       otopi >= 1.5.2-1

Requires:       ansible

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n"%{source_basename}"

# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
for d in dashboard ; do
  pushd .
  cd ${d}
  %{_datadir}/ovirt-engine-nodejs-modules/setup-env.sh
  popd
done

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%if 0%{?use_rhev}
%configure --with-rhev
%else
%configure
%endif  #END RHEV

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

# Create /var/lib/ovirt-hosted-engine-setup/cockpit
mkdir -p %{buildroot}%{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit


%files dashboard
%doc README.md
%license LICENSE
%{_plugindir}/ovirt-dashboard
%{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit

%changelog
* Thu Jun 28 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.29-1
- Removal of unwanted sections in Gdeploy Conf file for create_volume
- Configure LV Cache section disables on empty fields
- Config changes made in multiple tabs not persistent in gdeployConf file
- wizard: Align "Configure LV Cache" to reflect UI heirarchy
- wizard: Add replica message for gluster deployments
- gdeploy: Fix gdeploy version verification issue
- wizard: Don't exit wizard when Escape is pressed
- wizard: Fix footer in Chrome
- wizard: Add placeholder for "Mount Options" field
- wizard: Fix confirm close dialog prompt

* Wed Jun 06 2018 Ryan Barry <rbarry@redhat.com> - 0.11.28-1
- Allow non-VDO devices in gluster brick creation

* Thu May 31 2018 Ryan Barry <rbarry@redhat.com> - 0.11.27-1
- Revert gdeploy cancel button

* Wed May 30 2018 Ryan Barry <rbarry@redhat.com> - 0.11.26-1
- Continuing HE fixes
- Prompt to exit the wizard if it's running

* Wed May 23 2018 Ryan Barry <rbarry@redhat.com> - 0.11.25-1
- More gdeploy fixes

* Wed May 02 2018 Ryan Barry <rbarry@redhat.com> - 0.11.24-1
- Don't rely on gdeploy to start the wizard

* Wed Apr 25 2018 Ryan Barry <rbarry@redhat.com> - 0.11.23-1
- Gdeploy and hosted engine fixes

* Wed Apr 18 2018 Ryan Barry <rbarry@redhat.com> - 0.11.22-1
- Hosted engine fixes

* Wed Apr 11 2018 Ryan Barry <rbarry@redhat.com> - 0.11.21-1
- Lost of hosted engine fixes

* Tue Apr 03 2018 Ryan Barry <rbarry@redhat.com> - 0.11.20-1
- Fix FC LUN discovery

* Thu Mar 22 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.19-1
- iSCSI related fixes for hosted engine

* Wed Mar 21 2018 Ryan Barry <rbarry@redhat.com> - 0.11.18-1
- Even more hosted engines fixes and improvements for ansible

* Wed Mar 14 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.17-1
- More hosted engine wizard fixes and improvements
- Gluster Management fixes

* Wed Mar 14 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.16-1
- More hosted engine wizard fixes and improvements
- Gluster Management fixes

* Fri Mar 09 2018 Ryan Barry <rbarry@redhat.com> - 0.11.15-0.1
- More hosted engine fixes

* Thu Mar 01 2018 Ryan Barry <rbarry@redhat.com> - 0.11.14-0.1
- Fix hosted engine otopi deployments

* Thu Mar 01 2018 Ryan Barry <rbarry@redhat.com> - 0.11.13-0.1
- gdeploy enhancements for multiple bricks
- Fix hosted engine otopi deployments

* Tue Feb 20 2018 Ryan Barry <rbarry@redhat.com> - 0.11.12-0.1
- wizard: Lots of otopi bug fixes
- Better ansible parsing

* Mon Feb 05 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.11-0.1
- wizard: Replace empty strings with none:None

* Fri Feb 02 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.10-0.1
- iscsi: pass None on empty values

* Thu Feb 01 2018 Ryan Barry <rbarry@redhat.com> - 0.11.9-0.1
- Hide iSCSI target discovery for the iSCSI flow

* Thu Feb 01 2018 Ryan Barry <rbarry@redhat.com> - 0.11.8-0.1
- Move the default to otopi deployment

* Wed Jan 31 2018 Ryan Barry <rbarry@redhat.com> - 0.11.7-0.1
- Correct the domain type for vintage deployments

* Fri Jan 26 2018 Ryan Barry <rbarry@redhat.com> - 0.11.6-0.1
- Continue using otopi flow in the HE wizard for now

* Wed Jan 24 2018 Ryan Barry <rbarry@redhat.com> - 0.11.5-0.1
- Continue modernizing the hosted engine wizard
- Move to ansible

* Wed Dec 13 2017 Ryan Barry <rbarry@redhat.com> - 0.11.4-0.1
- Continue modernizing the hosted engine wizard

* Wed Dec 13 2017 Ryan Barry <rbarry@redhat.com> - 0.11.3-0.1
- Correct some problems with the HE answerfile

* Wed Dec 13 2017 Ryan Barry <rbarry@redhat.com> - 0.11.2-0.1
- Rework tarball naming

* Wed Dec 13 2017 Ryan Barry <rbarry@redhat.com> - 0.11.1-0.7
- Hosted engine fixes

* Thu Nov  30 2017 Ryan Barry <rbarry@redhat.com> - 0.11.1-0.6
- Even more hosted engine fixes

* Tue Nov  28 2017 Ryan Barry <rbarry@redhat.com> - 0.11.1-0.5
- Even more hosted engine fixes

* Tue Nov  14 2017 Ryan Barry <rbarry@redhat.com> - 0.11.1-0.4
- More hosted engine fixes

* Tue Nov  07 2017 Ryan Barry <rbarry@redhat.com> - 0.11.1-0.3
- Hosted engine fixes

* Tue Oct  24 2017 Ryan Barry <rbarry@redhat.com> - 0.11.0-1.1
- Use new hosted engine wizard

* Fri Sep  1 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.0-1
- Rebase on upstream 0.11.0

* Wed Aug  9 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.23
- More Gdeploy fixes

* Mon Jul 31 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.22
- Gdeploy fixes

* Wed Jul 05 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.21
- hosted-engine: make the page optional by checking for the hosted-engine
  binary before enabling anything
- gdeploy: re-calculate thinpoolMetadata size dynamically

* Thu Jun 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.20
- vdsm: fix d3 import
- gdeploy: add qemu user to gluster group
- gdeploy: move multipath-disable before brick creation

* Wed Jun 07 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.19
- gdeploy: use chrony instead of ntpd
- gdeploy: disable repos when deploying

* Thu May 04 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.18
- gdeploy: calculate arbiter brick size
- gdeploy: restart glusterd instead of start.
- gdeploy: calculate thinpoolMetadata size dynamically.
- gdeploy: Add option disable repos while generating gdeploy config file
- gdeploy: Remove text message when mount point is empty
- gdeploy: include gdeploy multipath disable script
* Fri Apr 14 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.17
- Unset confirm_otopi after passing
* Thu Mar 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.15
- Add hostnames to brick_dir in gluster config
* Wed Mar 08 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.14
- Various gdeploy fixes
* Thu Mar 02 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.13
- Fix a misnamed variable
* Wed Mar 01 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.12
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.11
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.10
- Add a prompt for GPG keys for hosted engine setup
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.9
- Use yarn to build
* Thu Feb 09 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.8
- Pull in missed patches
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.7
- gdeploy fixes
- Don't prompt for a password in Firefox during HE setup
- Block HE setup if the host is already registered
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.6
- gdeploy fixes
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.5
- Disable uiplugin again
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.4
- Disable node dashboard on non-node systems
- Some vdsm fixes
* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.3
- Fix syntax in dashboard helper
* Tue Jan 03 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.2
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.1
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.0
- Add gdeploy to hosted engine
* Tue Dec 20 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.3
- Keep all of the hosted-engine output
* Fri Nov 4 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.2
- Fix a regression with the last patch where the password was
  shown in plaintext
* Mon Oct 24 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.1
- Be smarter about the password check in hosted-engine setup
* Wed Aug 10 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.6
- Don't include the cockpit metapackage on RHEL
* Wed Jul 27 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.2
- UX improvements
* Fri Jul 1 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6
- Run hosted-engine setup as a superuser if sudo is available
- Rename the dashboard so branding isn't needed
- UX improvements
* Thu Jun 16 2016 Marek Libra <mlibra@redhat.com> - 0.10.5
- UI improvements
* Wed Jun 08 2016 Marek Libra <mlibra@redhat.com> - 0.10.4
- UI bugfixes and minor usability improvements
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10.3
- Update the otopi parser
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10
- Add a hosted engine status pae
- Add cancellation buttons for hosted engine
- Catch abnormal exits
* Wed May 18 2016 Ryan Barry <rbarry@redhat.com> - 0.9
- Add links to other parts of cockpit on the dashboard
- Add the ability to show the host SSH key to the dashboard
- Terminate hosted engine setup when the page is exited
- Mask some fields in hosted engine setup
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Thu Apr 28 2016 Marek Libra <mlibra@redhat.com> - 0.7
- Add Webadmin Cockpit UI Plugin
* Mon Apr 25 2016 Marek Libra <mlibra@redhat.com> - 0.6
- Add vdsm VM Management
* Fri Apr 08 2016 Ryan Barry <rbarry@redhat.com> - 0.5
- Add node-dashboard
* Tue Mar 22 2016 Ryan Barry <rbarry@redhat.com> - 0.4
- Add node-dashboard
* Fri Mar 18 2016 Marek Libra <rbarry@redhat.com> - 0.3
- Update packaging to match upstream standards
- Convert to autotools
* Fri Mar 11 2016 Marek Libra <mlibra@redhat.com> - 0.2
* Thu Mar 03 2016 Marek Libra <mlibra@redhat.com> - 0.1
- Initial packaging

