/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1DHCPOptions;
import kubevirt.io.V1InterfaceBridge;
import kubevirt.io.V1InterfaceMasquerade;
import kubevirt.io.V1InterfaceSRIOV;
import kubevirt.io.V1InterfaceSlirp;
import kubevirt.io.V1Port;

/**
 * V1Interface
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Interface {
  @SerializedName("bootOrder")
  private Integer bootOrder = null;

  @SerializedName("bridge")
  private V1InterfaceBridge bridge = null;

  @SerializedName("dhcpOptions")
  private V1DHCPOptions dhcpOptions = null;

  @SerializedName("macAddress")
  private String macAddress = null;

  @SerializedName("masquerade")
  private V1InterfaceMasquerade masquerade = null;

  @SerializedName("model")
  private String model = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("pciAddress")
  private String pciAddress = null;

  @SerializedName("ports")
  private List<V1Port> ports = null;

  @SerializedName("slirp")
  private V1InterfaceSlirp slirp = null;

  @SerializedName("sriov")
  private V1InterfaceSRIOV sriov = null;

  public V1Interface bootOrder(Integer bootOrder) {
    this.bootOrder = bootOrder;
    return this;
  }

   /**
   * BootOrder is an integer value &gt; 0, used to determine ordering of boot devices. Lower values take precedence. Each interface or disk that has a boot order must have a unique value. Interfaces without a boot order are not tried. +optional
   * @return bootOrder
  **/
  @ApiModelProperty(value = "BootOrder is an integer value > 0, used to determine ordering of boot devices. Lower values take precedence. Each interface or disk that has a boot order must have a unique value. Interfaces without a boot order are not tried. +optional")
  public Integer getBootOrder() {
    return bootOrder;
  }

  public void setBootOrder(Integer bootOrder) {
    this.bootOrder = bootOrder;
  }

  public V1Interface bridge(V1InterfaceBridge bridge) {
    this.bridge = bridge;
    return this;
  }

   /**
   * Get bridge
   * @return bridge
  **/
  @ApiModelProperty(value = "")
  public V1InterfaceBridge getBridge() {
    return bridge;
  }

  public void setBridge(V1InterfaceBridge bridge) {
    this.bridge = bridge;
  }

  public V1Interface dhcpOptions(V1DHCPOptions dhcpOptions) {
    this.dhcpOptions = dhcpOptions;
    return this;
  }

   /**
   * If specified the network interface will pass additional DHCP options to the VMI +optional
   * @return dhcpOptions
  **/
  @ApiModelProperty(value = "If specified the network interface will pass additional DHCP options to the VMI +optional")
  public V1DHCPOptions getDhcpOptions() {
    return dhcpOptions;
  }

  public void setDhcpOptions(V1DHCPOptions dhcpOptions) {
    this.dhcpOptions = dhcpOptions;
  }

  public V1Interface macAddress(String macAddress) {
    this.macAddress = macAddress;
    return this;
  }

   /**
   * Interface MAC address. For example: de:ad:00:00:be:af or DE-AD-00-00-BE-AF.
   * @return macAddress
  **/
  @ApiModelProperty(value = "Interface MAC address. For example: de:ad:00:00:be:af or DE-AD-00-00-BE-AF.")
  public String getMacAddress() {
    return macAddress;
  }

  public void setMacAddress(String macAddress) {
    this.macAddress = macAddress;
  }

  public V1Interface masquerade(V1InterfaceMasquerade masquerade) {
    this.masquerade = masquerade;
    return this;
  }

   /**
   * Get masquerade
   * @return masquerade
  **/
  @ApiModelProperty(value = "")
  public V1InterfaceMasquerade getMasquerade() {
    return masquerade;
  }

  public void setMasquerade(V1InterfaceMasquerade masquerade) {
    this.masquerade = masquerade;
  }

  public V1Interface model(String model) {
    this.model = model;
    return this;
  }

   /**
   * Interface model. One of: e1000, e1000e, ne2k_pci, pcnet, rtl8139, virtio. Defaults to virtio.
   * @return model
  **/
  @ApiModelProperty(value = "Interface model. One of: e1000, e1000e, ne2k_pci, pcnet, rtl8139, virtio. Defaults to virtio.")
  public String getModel() {
    return model;
  }

  public void setModel(String model) {
    this.model = model;
  }

  public V1Interface name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Logical name of the interface as well as a reference to the associated networks. Must match the Name of a Network.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "Logical name of the interface as well as a reference to the associated networks. Must match the Name of a Network.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V1Interface pciAddress(String pciAddress) {
    this.pciAddress = pciAddress;
    return this;
  }

   /**
   * If specified, the virtual network interface will be placed on the guests pci address with the specifed PCI address. For example: 0000:81:01.10 +optional
   * @return pciAddress
  **/
  @ApiModelProperty(value = "If specified, the virtual network interface will be placed on the guests pci address with the specifed PCI address. For example: 0000:81:01.10 +optional")
  public String getPciAddress() {
    return pciAddress;
  }

  public void setPciAddress(String pciAddress) {
    this.pciAddress = pciAddress;
  }

  public V1Interface ports(List<V1Port> ports) {
    this.ports = ports;
    return this;
  }

  public V1Interface addPortsItem(V1Port portsItem) {
    if (this.ports == null) {
      this.ports = new ArrayList<>();
    }
    this.ports.add(portsItem);
    return this;
  }

   /**
   * List of ports to be forwarded to the virtual machine.
   * @return ports
  **/
  @ApiModelProperty(value = "List of ports to be forwarded to the virtual machine.")
  public List<V1Port> getPorts() {
    return ports;
  }

  public void setPorts(List<V1Port> ports) {
    this.ports = ports;
  }

  public V1Interface slirp(V1InterfaceSlirp slirp) {
    this.slirp = slirp;
    return this;
  }

   /**
   * Get slirp
   * @return slirp
  **/
  @ApiModelProperty(value = "")
  public V1InterfaceSlirp getSlirp() {
    return slirp;
  }

  public void setSlirp(V1InterfaceSlirp slirp) {
    this.slirp = slirp;
  }

  public V1Interface sriov(V1InterfaceSRIOV sriov) {
    this.sriov = sriov;
    return this;
  }

   /**
   * Get sriov
   * @return sriov
  **/
  @ApiModelProperty(value = "")
  public V1InterfaceSRIOV getSriov() {
    return sriov;
  }

  public void setSriov(V1InterfaceSRIOV sriov) {
    this.sriov = sriov;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Interface v1Interface = (V1Interface) o;
    return Objects.equals(this.bootOrder, v1Interface.bootOrder) &&
        Objects.equals(this.bridge, v1Interface.bridge) &&
        Objects.equals(this.dhcpOptions, v1Interface.dhcpOptions) &&
        Objects.equals(this.macAddress, v1Interface.macAddress) &&
        Objects.equals(this.masquerade, v1Interface.masquerade) &&
        Objects.equals(this.model, v1Interface.model) &&
        Objects.equals(this.name, v1Interface.name) &&
        Objects.equals(this.pciAddress, v1Interface.pciAddress) &&
        Objects.equals(this.ports, v1Interface.ports) &&
        Objects.equals(this.slirp, v1Interface.slirp) &&
        Objects.equals(this.sriov, v1Interface.sriov);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bootOrder, bridge, dhcpOptions, macAddress, masquerade, model, name, pciAddress, ports, slirp, sriov);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Interface {\n");
    
    sb.append("    bootOrder: ").append(toIndentedString(bootOrder)).append("\n");
    sb.append("    bridge: ").append(toIndentedString(bridge)).append("\n");
    sb.append("    dhcpOptions: ").append(toIndentedString(dhcpOptions)).append("\n");
    sb.append("    macAddress: ").append(toIndentedString(macAddress)).append("\n");
    sb.append("    masquerade: ").append(toIndentedString(masquerade)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    pciAddress: ").append(toIndentedString(pciAddress)).append("\n");
    sb.append("    ports: ").append(toIndentedString(ports)).append("\n");
    sb.append("    slirp: ").append(toIndentedString(slirp)).append("\n");
    sb.append("    sriov: ").append(toIndentedString(sriov)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

